/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DynamicViewDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.CustomElement;
import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import com.structurizr.model.StaticStructureElement;
import com.structurizr.util.StringUtils;
import com.structurizr.view.DynamicView;
import com.structurizr.view.RelationshipView;

final class DynamicViewContentParser
extends AbstractParser {
    private static final String GRAMMAR_1 = "[order:] <identifier> -> <identifier> [description] [technology]";
    private static final String GRAMMAR_2 = "[order:] <identifier> [description]";
    private static final String ORDER_DELIMITER = ":";
    private static final int SOURCE_IDENTIFIER_INDEX = 0;
    private static final int RELATIONSHIP_TOKEN_INDEX = 1;
    private static final int DESTINATION_IDENTIFIER_INDEX = 2;
    private static final int DESCRIPTION_INDEX = 3;
    private static final int TECHNOLOGY_INDEX = 4;
    private static final int RELATIONSHIP_IDENTIFIER_INDEX = 0;

    DynamicViewContentParser() {
    }

    RelationshipView parseRelationship(DynamicViewDslContext context, Tokens tokens) {
        DynamicView view = context.getView();
        RelationshipView relationshipView = null;
        String order = null;
        if (tokens.size() > 0 && tokens.get(0).endsWith(ORDER_DELIMITER)) {
            order = tokens.get(0);
            order = order.substring(0, order.length() - ORDER_DELIMITER.length());
            tokens.remove(0);
        }
        if (tokens.size() > 1 && "->".equals(tokens.get(1))) {
            if (tokens.hasMoreThan(4)) {
                throw new RuntimeException("Too many tokens, expected: [order:] <identifier> -> <identifier> [description] [technology]");
            }
            if (!tokens.includes(2)) {
                throw new RuntimeException("Expected: [order:] <identifier> -> <identifier> [description] [technology]");
            }
            String sourceId = tokens.get(0);
            String destinationId = tokens.get(2);
            Element sourceElement = context.getElement(sourceId);
            if (sourceElement == null) {
                throw new RuntimeException("The source element \"" + sourceId + "\" does not exist");
            }
            if (!(sourceElement instanceof StaticStructureElement) && !(sourceElement instanceof CustomElement)) {
                throw new RuntimeException("The source element \"" + sourceId + "\" should be a static structure or custom element");
            }
            Element destinationElement = context.getElement(destinationId);
            if (destinationElement == null) {
                throw new RuntimeException("The destination element \"" + destinationId + "\" does not exist");
            }
            if (!(destinationElement instanceof StaticStructureElement) && !(destinationElement instanceof CustomElement)) {
                throw new RuntimeException("The destination element \"" + destinationId + "\" should be a static structure or custom element");
            }
            String description = "";
            if (tokens.includes(3)) {
                description = tokens.get(3);
            }
            String technology = "";
            if (tokens.includes(4)) {
                technology = tokens.get(4);
            }
            if (sourceElement instanceof StaticStructureElement && destinationElement instanceof StaticStructureElement) {
                relationshipView = view.add((StaticStructureElement)sourceElement, description, technology, (StaticStructureElement)destinationElement);
            } else if (sourceElement instanceof StaticStructureElement && destinationElement instanceof CustomElement) {
                relationshipView = view.add((StaticStructureElement)sourceElement, description, technology, (CustomElement)destinationElement);
            } else if (sourceElement instanceof CustomElement && destinationElement instanceof StaticStructureElement) {
                relationshipView = view.add((CustomElement)sourceElement, description, technology, (StaticStructureElement)destinationElement);
            } else if (sourceElement instanceof CustomElement && destinationElement instanceof CustomElement) {
                relationshipView = view.add((CustomElement)sourceElement, description, technology, (CustomElement)destinationElement);
            }
        } else {
            String relationshipId = tokens.get(0);
            Relationship relationship = context.getRelationship(relationshipId);
            if (tokens.hasMoreThan(1)) {
                throw new RuntimeException("Too many tokens, expected: [order:] <identifier> [description]");
            }
            if (relationship == null) {
                throw new RuntimeException("The relationship \"" + relationshipId + "\" does not exist");
            }
            String description = "";
            if (tokens.includes(1)) {
                description = tokens.get(1);
            }
            relationshipView = view.add(relationship, description);
        }
        if (relationshipView != null) {
            if (!StringUtils.isNullOrEmpty((String)order)) {
                relationshipView.setOrder(order);
            }
            return relationshipView;
        }
        throw new RuntimeException("The specified relationship could not be added");
    }
}

