/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.model.Element;
import java.util.HashSet;
import java.util.Set;

class ElementGroup
extends Element {
    private Element parent;
    private final ElementGroup parentGroup;
    private final String name;
    private final Set<Element> elements = new HashSet<Element>();

    ElementGroup(String name) {
        this.name = name;
        this.parentGroup = null;
    }

    ElementGroup(String name, String groupSeparator, ElementGroup parentGroup) {
        this.name = parentGroup.getName() + groupSeparator + name;
        this.parentGroup = parentGroup;
    }

    public String getName() {
        return this.name;
    }

    public String getCanonicalName() {
        return this.name;
    }

    void setParent(Element parent) {
        this.parent = parent;
    }

    public Element getParent() {
        return this.parent;
    }

    public Set<String> getDefaultTags() {
        return null;
    }

    void addElement(Element element) {
        this.elements.add(element);
        if (this.parentGroup != null) {
            this.parentGroup.addElement(element);
        }
    }

    Set<Element> getElements() {
        return new HashSet<Element>(this.elements);
    }
}

