/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.ExpressionParser;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Relationship;
import java.util.Set;
import java.util.stream.Collectors;

final class FindRelationshipsParser
extends AbstractParser {
    private static final String GRAMMAR = "!relationships <expression>";
    private static final int EXPRESSION_INDEX = 1;

    FindRelationshipsParser() {
    }

    Set<Relationship> parse(DslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: !relationships <expression>");
        }
        String expression = tokens.get(1);
        Set<ModelItem> modelItems = new ExpressionParser().parseExpression(expression, context);
        Set<Relationship> relationships = modelItems.stream().filter(mi -> mi instanceof Relationship).map(mi -> (Relationship)mi).collect(Collectors.toSet());
        if (relationships.isEmpty()) {
            throw new RuntimeException("No relationships found for expression \"" + expression + "\"");
        }
        return relationships;
    }
}

