/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.ComponentDslContext;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.ElementGroup;
import com.structurizr.dsl.GroupableDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Component;
import com.structurizr.util.StringUtils;

class GroupParser {
    private static final String STRUCTURIZR_GROUP_SEPARATOR_PROPERTY_NAME = "structurizr.groupSeparator";
    private static final String GRAMMAR_AS_CONTEXT = "group <name> {";
    private static final String GRAMMAR_AS_PROPERTY = "group <name>";
    private static final int NAME_INDEX = 1;
    private static final int BRACE_INDEX = 2;

    GroupParser() {
    }

    ElementGroup parseContext(GroupableDslContext dslContext, Tokens tokens) {
        ElementGroup group;
        if (tokens.hasMoreThan(2)) {
            throw new RuntimeException("Too many tokens, expected: group <name> {");
        }
        if (!tokens.includes(2)) {
            throw new RuntimeException("Expected: group <name> {");
        }
        if (!"{".equalsIgnoreCase(tokens.get(2))) {
            throw new RuntimeException("Expected: group <name> {");
        }
        if (dslContext.hasGroup()) {
            String groupSeparator = ((DslContext)((Object)dslContext)).getWorkspace().getModel().getProperties().getOrDefault(STRUCTURIZR_GROUP_SEPARATOR_PROPERTY_NAME, "");
            if (StringUtils.isNullOrEmpty((String)groupSeparator)) {
                throw new RuntimeException("To use nested groups, please define a model property named structurizr.groupSeparator");
            }
            group = new ElementGroup(tokens.get(1), groupSeparator, dslContext.getGroup());
        } else {
            group = new ElementGroup(tokens.get(1));
        }
        return group;
    }

    void parseProperty(ComponentDslContext dslContext, Tokens tokens) {
        if (tokens.includes(2)) {
            throw new RuntimeException("Too many tokens, expected: group <name>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: group <name>");
        }
        Object group = tokens.get(1);
        Component component = dslContext.getComponent();
        String existingGroup = component.getGroup();
        if (!StringUtils.isNullOrEmpty((String)existingGroup)) {
            String groupSeparator = dslContext.getWorkspace().getModel().getProperties().getOrDefault(STRUCTURIZR_GROUP_SEPARATOR_PROPERTY_NAME, "");
            if (StringUtils.isNullOrEmpty((String)groupSeparator)) {
                throw new RuntimeException("To use nested groups, please define a model property named structurizr.groupSeparator");
            }
            group = existingGroup + groupSeparator + (String)group;
        }
        component.setGroup((String)group);
    }
}

