/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.ImageViewDslContext;
import com.structurizr.dsl.RemoteContent;
import com.structurizr.dsl.Tokens;
import com.structurizr.export.mermaid.MermaidDiagramExporter;
import com.structurizr.export.plantuml.StructurizrPlantUMLExporter;
import com.structurizr.importer.diagrams.kroki.KrokiImporter;
import com.structurizr.importer.diagrams.mermaid.MermaidImporter;
import com.structurizr.importer.diagrams.plantuml.PlantUMLImporter;
import com.structurizr.util.ImageUtils;
import com.structurizr.util.Url;
import com.structurizr.view.ImageView;
import com.structurizr.view.ModelView;
import com.structurizr.view.View;
import java.io.File;

final class ImageViewContentParser
extends AbstractParser {
    private static final String PLANTUML_GRAMMAR = "plantuml <file|url|viewKey>";
    private static final String MERMAID_GRAMMAR = "mermaid <file|url|viewKey>";
    private static final String KROKI_GRAMMAR = "kroki <format> <file|url>";
    private static final String IMAGE_GRAMMAR = "image <file|url>";
    private static final int PLANTUML_SOURCE_INDEX = 1;
    private static final int MERMAID_SOURCE_INDEX = 1;
    private static final int KROKI_FORMAT_INDEX = 1;
    private static final int KROKI_SOURCE_INDEX = 2;
    private static final int IMAGE_SOURCE_INDEX = 1;
    private boolean restricted = false;

    ImageViewContentParser(boolean restricted) {
        this.restricted = restricted;
    }

    void parsePlantUML(ImageViewDslContext context, File dslFile, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: plantuml <file|url|viewKey>");
        }
        ImageView view = context.getView();
        if (view != null) {
            if (tokens.size() == 2) {
                String source = tokens.get(1);
                try {
                    View viewWithKey = context.getWorkspace().getViews().getViewWithKey(source);
                    if (viewWithKey instanceof ModelView) {
                        StructurizrPlantUMLExporter exporter = new StructurizrPlantUMLExporter();
                        String plantuml = exporter.export((ModelView)viewWithKey).getDefinition();
                        new PlantUMLImporter().importDiagram(context.getView(), plantuml);
                    }
                    if (Url.isUrl((String)source)) {
                        RemoteContent content = this.readFromUrl(source);
                        new PlantUMLImporter().importDiagram(context.getView(), content.getContent());
                        context.getView().setTitle(source.substring(source.lastIndexOf("/") + 1));
                    }
                    if (!this.restricted) {
                        File file = new File(dslFile.getParentFile(), source);
                        new PlantUMLImporter().importDiagram(context.getView(), file);
                    }
                    throw new RuntimeException("PlantUML source must be specified as a URL when running in restricted mode");
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            } else {
                throw new RuntimeException("Expected: plantuml <file|url|viewKey>");
            }
        }
    }

    void parseMermaid(ImageViewDslContext context, File dslFile, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: mermaid <file|url|viewKey>");
        }
        ImageView view = context.getView();
        if (view != null) {
            if (tokens.size() == 2) {
                String source = tokens.get(1);
                try {
                    View viewWithKey = context.getWorkspace().getViews().getViewWithKey(source);
                    if (viewWithKey instanceof ModelView) {
                        MermaidDiagramExporter exporter = new MermaidDiagramExporter();
                        String mermaid = exporter.export((ModelView)viewWithKey).getDefinition();
                        new MermaidImporter().importDiagram(context.getView(), mermaid);
                    }
                    if (Url.isUrl((String)source)) {
                        RemoteContent content = this.readFromUrl(source);
                        new MermaidImporter().importDiagram(context.getView(), content.getContent());
                        context.getView().setTitle(source.substring(source.lastIndexOf("/") + 1));
                    }
                    if (!this.restricted) {
                        File file = new File(dslFile.getParentFile(), source);
                        new MermaidImporter().importDiagram(context.getView(), file);
                    }
                    throw new RuntimeException("Mermaid source must be specified as a URL when running in restricted mode");
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            } else {
                throw new RuntimeException("Expected: mermaid <file|url|viewKey>");
            }
        }
    }

    void parseKroki(ImageViewDslContext context, File dslFile, Tokens tokens) {
        if (tokens.hasMoreThan(2)) {
            throw new RuntimeException("Too many tokens, expected: kroki <format> <file|url>");
        }
        ImageView view = context.getView();
        if (view != null) {
            if (tokens.size() == 3) {
                String format = tokens.get(1);
                String source = tokens.get(2);
                try {
                    if (Url.isUrl((String)source)) {
                        RemoteContent content = this.readFromUrl(source);
                        new KrokiImporter().importDiagram(context.getView(), format, content.getContent());
                        context.getView().setTitle(source.substring(source.lastIndexOf("/") + 1));
                    }
                    if (!this.restricted) {
                        File file = new File(dslFile.getParentFile(), source);
                        new KrokiImporter().importDiagram(context.getView(), format, file);
                    }
                    throw new RuntimeException("Kroki source must be specified as a URL when running in restricted mode");
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            } else {
                throw new RuntimeException("Expected: kroki <format> <file|url>");
            }
        }
    }

    void parseImage(ImageViewDslContext context, File dslFile, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: image <file|url>");
        }
        ImageView view = context.getView();
        if (view != null) {
            if (tokens.size() == 2) {
                String source = tokens.get(1);
                try {
                    if (Url.isUrl((String)source)) {
                        context.getView().setContent(source);
                        context.getView().setTitle(source.substring(source.lastIndexOf("/") + 1));
                    }
                    if (!this.restricted) {
                        File file = new File(dslFile.getParentFile(), source);
                        context.getView().setContent(ImageUtils.getImageAsDataUri((File)file));
                        context.getView().setTitle(file.getName());
                    }
                    throw new RuntimeException("Images must be specified as a URL when running in restricted mode");
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            } else {
                throw new RuntimeException("Expected: image <file|url>");
            }
        }
    }
}

