/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractRelationshipParser;
import com.structurizr.dsl.Archetype;
import com.structurizr.dsl.ElementDslContext;
import com.structurizr.dsl.ElementsDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import java.util.LinkedHashSet;
import java.util.Set;

final class ImplicitRelationshipParser
extends AbstractRelationshipParser {
    private static final String GRAMMAR = "-> <identifier> [description] [technology] [tags]";
    private static final int DESTINATION_IDENTIFIER_INDEX = 1;
    private static final int DESCRIPTION_INDEX = 2;
    private static final int TECHNOLOGY_INDEX = 3;
    private static final int TAGS_INDEX = 4;

    ImplicitRelationshipParser() {
    }

    Relationship parse(ElementDslContext context, Tokens tokens, Archetype archetype) {
        if (tokens.hasMoreThan(4)) {
            throw new RuntimeException("Too many tokens, expected: -> <identifier> [description] [technology] [tags]");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: -> <identifier> [description] [technology] [tags]");
        }
        String destinationId = tokens.get(1);
        Element sourceElement = context.getElement();
        Element destinationElement = context.getElement(destinationId);
        if (destinationElement == null) {
            throw new RuntimeException("The destination element \"" + destinationId + "\" does not exist");
        }
        String description = archetype.getDescription();
        if (tokens.includes(2)) {
            description = tokens.get(2);
        }
        String technology = archetype.getTechnology();
        if (tokens.includes(3)) {
            technology = tokens.get(3);
        }
        String[] tags = archetype.getTags().toArray(new String[0]);
        if (tokens.includes(4)) {
            tags = tokens.get(4).split(",");
        }
        Relationship relationship = this.createRelationship(sourceElement, description, technology, tags, destinationElement);
        relationship.addProperties(archetype.getProperties());
        relationship.addPerspectives(archetype.getPerspectives());
        return relationship;
    }

    Set<Relationship> parse(ElementsDslContext context, Tokens tokens, Archetype archetype) {
        if (tokens.hasMoreThan(4)) {
            throw new RuntimeException("Too many tokens, expected: -> <identifier> [description] [technology] [tags]");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: -> <identifier> [description] [technology] [tags]");
        }
        Set<Element> sourceElements = context.getElements();
        String destinationId = tokens.get(1);
        Element destinationElement = context.getElement(destinationId);
        if (destinationElement == null) {
            throw new RuntimeException("The destination element \"" + destinationId + "\" does not exist");
        }
        String description = archetype.getDescription();
        if (tokens.includes(2)) {
            description = tokens.get(2);
        }
        String technology = archetype.getTechnology();
        if (tokens.includes(3)) {
            technology = tokens.get(3);
        }
        String[] tags = archetype.getTags().toArray(new String[0]);
        if (tokens.includes(4)) {
            tags = tokens.get(4).split(",");
        }
        LinkedHashSet<Relationship> relationships = new LinkedHashSet<Relationship>();
        for (Element sourceElement : sourceElements) {
            Relationship relationship = this.createRelationship(sourceElement, description, technology, tags, destinationElement);
            relationship.addProperties(archetype.getProperties());
            relationship.addPerspectives(archetype.getPerspectives());
            relationships.add(relationship);
        }
        return relationships;
    }
}

