/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.CreateImpliedRelationshipsUnlessAnyRelationshipExistsStrategy;
import com.structurizr.model.DefaultImpliedRelationshipsStrategy;
import com.structurizr.model.ImpliedRelationshipsStrategy;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Set;

final class ImpliedRelationshipsParser
extends AbstractParser {
    private static final String GRAMMAR = "!impliedRelationships <true|false|fqcn>";
    private static final Set<String> BUILT_IN_IMPLIED_RELATIONSHIPS_STRATEGIES = Set.of("com.structurizr.model.DefaultImpliedRelationshipsStrategy", "com.structurizr.model.CreateImpliedRelationshipsUnlessAnyRelationshipExistsStrategy", "com.structurizr.model.CreateImpliedRelationshipsUnlessSameRelationshipExistsStrategy");
    private static final int OPTION_INDEX = 1;
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    ImpliedRelationshipsParser() {
    }

    void parse(DslContext context, Tokens tokens, File dslFile, boolean restricted) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: !impliedRelationships <true|false|fqcn>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: !impliedRelationships <true|false|fqcn>");
        }
        String option = tokens.get(1);
        if (option.equalsIgnoreCase(FALSE)) {
            context.getWorkspace().getModel().setImpliedRelationshipsStrategy((ImpliedRelationshipsStrategy)new DefaultImpliedRelationshipsStrategy());
        } else if (option.equalsIgnoreCase(TRUE)) {
            context.getWorkspace().getModel().setImpliedRelationshipsStrategy((ImpliedRelationshipsStrategy)new CreateImpliedRelationshipsUnlessAnyRelationshipExistsStrategy());
        } else {
            if (restricted && !BUILT_IN_IMPLIED_RELATIONSHIPS_STRATEGIES.contains(option)) {
                throw new RuntimeException("The implied relationships strategy " + option + " is not available when the DSL parser is running in restricted mode");
            }
            try {
                Class impliedRelationshipsStrategyClass = context.loadClass(option, dslFile);
                Constructor constructor = impliedRelationshipsStrategyClass.getDeclaredConstructor(new Class[0]);
                ImpliedRelationshipsStrategy impliedRelationshipsStrategy = (ImpliedRelationshipsStrategy)constructor.newInstance(new Object[0]);
                context.getWorkspace().getModel().setImpliedRelationshipsStrategy(impliedRelationshipsStrategy);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Error loading implied relationships strategy: " + option + " was not found");
            }
            catch (Exception e) {
                throw new RuntimeException("Error loading implied relationships strategy: " + e.getMessage());
            }
        }
    }
}

