/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.Archetype;
import com.structurizr.dsl.DeploymentNodeDslContext;
import com.structurizr.dsl.InfrastructureNodeDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;

final class InfrastructureNodeParser
extends AbstractParser {
    private static final String GRAMMAR = "infrastructureNode <name> [description] [technology] [tags]";
    private static final int NAME_INDEX = 1;
    private static final int DESCRIPTION_INDEX = 2;
    private static final int TECHNOLOGY_INDEX = 3;
    private static final int TAGS_INDEX = 4;

    InfrastructureNodeParser() {
    }

    InfrastructureNode parse(DeploymentNodeDslContext context, Tokens tokens, Archetype archetype) {
        if (tokens.hasMoreThan(4)) {
            throw new RuntimeException("Too many tokens, expected: infrastructureNode <name> [description] [technology] [tags]");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: infrastructureNode <name> [description] [technology] [tags]");
        }
        DeploymentNode deploymentNode = context.getDeploymentNode();
        String name = tokens.get(1);
        String description = archetype.getDescription();
        if (tokens.includes(2)) {
            description = tokens.get(2);
        }
        String technology = archetype.getTechnology();
        if (tokens.includes(3)) {
            technology = tokens.get(3);
        }
        InfrastructureNode infrastructureNode = deploymentNode.addInfrastructureNode(name, description, technology);
        String[] tags = archetype.getTags().toArray(new String[0]);
        if (tokens.includes(4)) {
            tags = tokens.get(4).split(",");
        }
        infrastructureNode.addTags(tags);
        infrastructureNode.addProperties(archetype.getProperties());
        infrastructureNode.addPerspectives(archetype.getPerspectives());
        if (context.hasGroup()) {
            infrastructureNode.setGroup(context.getGroup().getName());
            context.getGroup().addElement((Element)infrastructureNode);
        }
        return infrastructureNode;
    }

    void parseTechnology(InfrastructureNodeDslContext context, Tokens tokens) {
        int index = 1;
        if (tokens.hasMoreThan(index)) {
            throw new RuntimeException("Too many tokens, expected: technology <technology>");
        }
        if (!tokens.includes(index)) {
            throw new RuntimeException("Expected: technology <technology>");
        }
        String technology = tokens.get(index);
        context.getInfrastructureNode().setTechnology(technology);
    }
}

