/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.NameValuePair;
import com.structurizr.dsl.NameValueType;
import com.structurizr.dsl.Tokens;

final class NameValueParser
extends AbstractParser {
    private static final String GRAMMAR = "%s <name> <value>";
    private static final int KEYWORD_INDEX = 0;
    private static final int NAME_INDEX = 1;
    private static final int VALUE_INDEX = 2;
    private static final String NAME_REGEX = "[a-zA-Z0-9-_.]+";

    NameValueParser() {
    }

    NameValuePair parseConstant(Tokens tokens) {
        NameValuePair nvp = this.parse(tokens);
        nvp.setType(NameValueType.Constant);
        return nvp;
    }

    NameValuePair parseVariable(Tokens tokens) {
        NameValuePair nvp = this.parse(tokens);
        nvp.setType(NameValueType.Variable);
        return nvp;
    }

    private NameValuePair parse(Tokens tokens) {
        if (tokens.hasMoreThan(2)) {
            throw new RuntimeException("Too many tokens, expected: " + String.format(GRAMMAR, tokens.get(0)));
        }
        if (!tokens.includes(2)) {
            throw new RuntimeException("Expected: " + String.format(GRAMMAR, tokens.get(0)));
        }
        String name = tokens.get(1);
        String value = tokens.get(2);
        if (!name.matches(NAME_REGEX)) {
            throw new RuntimeException("Constant/variable names must only contain the following characters: a-zA-Z0-9-_.");
        }
        return new NameValuePair(name, value);
    }
}

