/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.ExternalScriptDslContext;
import com.structurizr.dsl.InlineScriptDslContext;
import com.structurizr.dsl.Tokens;

final class ScriptParser
extends AbstractParser {
    private static final String EXTERNAL_GRAMMAR = "!script <filename>";
    private static final String INLINE_GRAMMAR = "!script <language>";
    private static final int FILENAME_INDEX = 1;
    private static final int LANGUAGE_INDEX = 1;
    private static final int PARAMETER_NAME_INDEX = 0;
    private static final int PARAMETER_VALUE_INDEX = 1;

    ScriptParser() {
    }

    boolean isInlineScript(Tokens tokens) {
        return "{".equalsIgnoreCase(tokens.get(tokens.size() - 1)) && tokens.includes(1) && InlineScriptDslContext.SUPPORTED_LANGUAGES.containsKey(tokens.get(1).toLowerCase());
    }

    String parseExternal(Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: !script <filename>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: !script <filename>");
        }
        return tokens.get(1);
    }

    void parseParameter(ExternalScriptDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: <name> <value>");
        }
        if (tokens.size() != 2) {
            throw new RuntimeException("Expected: <name> <value>");
        }
        String name = tokens.get(0);
        String value = tokens.get(1);
        context.addParameter(name, value);
    }

    String parseInline(Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: !script <language>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: !script <language>");
        }
        return tokens.get(1);
    }
}

