/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DeploymentGroup;
import com.structurizr.dsl.DeploymentNodeDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import java.util.HashSet;

final class SoftwareSystemInstanceParser
extends AbstractParser {
    private static final String GRAMMAR = "softwareSystemInstance <identifier> [deploymentGroups] [tags]";
    private static final int IDENTIFIER_INDEX = 1;
    private static final int DEPLOYMENT_GROUPS_TOKEN = 2;
    private static final int TAGS_INDEX = 3;

    SoftwareSystemInstanceParser() {
    }

    SoftwareSystemInstance parse(DeploymentNodeDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(3)) {
            throw new RuntimeException("Too many tokens, expected: softwareSystemInstance <identifier> [deploymentGroups] [tags]");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: softwareSystemInstance <identifier> [deploymentGroups] [tags]");
        }
        String softwareSystemIdentifier = tokens.get(1);
        Element element = context.getElement(softwareSystemIdentifier, SoftwareSystem.class);
        if (element == null) {
            throw new RuntimeException("The software system \"" + softwareSystemIdentifier + "\" does not exist");
        }
        DeploymentNode deploymentNode = context.getDeploymentNode();
        HashSet<String> deploymentGroups = new HashSet<String>();
        if (tokens.includes(2)) {
            String[] deploymentGroupReferences;
            String token = tokens.get(2);
            for (String deploymentGroupReference : deploymentGroupReferences = token.split(",")) {
                Element e = context.getElement(deploymentGroupReference);
                if (!(e instanceof DeploymentGroup)) continue;
                deploymentGroups.add(e.getName());
            }
        }
        SoftwareSystemInstance softwareSystemInstance = deploymentNode.add((SoftwareSystem)element, deploymentGroups.toArray(new String[0]));
        if (tokens.includes(3)) {
            String tags = tokens.get(3);
            softwareSystemInstance.addTags(tags.split(","));
        }
        if (context.hasGroup()) {
            softwareSystemInstance.setGroup(context.getGroup().getName());
            context.getGroup().addElement((Element)softwareSystemInstance);
        }
        return softwareSystemInstance;
    }
}

