/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.Archetype;
import com.structurizr.dsl.ModelDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Element;
import com.structurizr.model.SoftwareSystem;

final class SoftwareSystemParser
extends AbstractParser {
    private static final String GRAMMAR = "softwareSystem <name> [description] [tags]";
    private static final int NAME_INDEX = 1;
    private static final int DESCRIPTION_INDEX = 2;
    private static final int TAGS_INDEX = 3;

    SoftwareSystemParser() {
    }

    SoftwareSystem parse(ModelDslContext context, Tokens tokens, Archetype archetype) {
        if (tokens.hasMoreThan(3)) {
            throw new RuntimeException("Too many tokens, expected: softwareSystem <name> [description] [tags]");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: softwareSystem <name> [description] [tags]");
        }
        SoftwareSystem softwareSystem = null;
        String name = tokens.get(1);
        if (context.isExtendingWorkspace()) {
            softwareSystem = context.getWorkspace().getModel().getSoftwareSystemWithName(name);
        }
        if (softwareSystem == null) {
            softwareSystem = context.getWorkspace().getModel().addSoftwareSystem(name);
        }
        String description = archetype.getDescription();
        if (tokens.includes(2)) {
            description = tokens.get(2);
        }
        softwareSystem.setDescription(description);
        String[] tags = archetype.getTags().toArray(new String[0]);
        if (tokens.includes(3)) {
            tags = tokens.get(3).split(",");
        }
        softwareSystem.addTags(tags);
        softwareSystem.addProperties(archetype.getProperties());
        softwareSystem.addPerspectives(archetype.getPerspectives());
        if (context.hasGroup()) {
            softwareSystem.setGroup(context.getGroup().getName());
            context.getGroup().addElement((Element)softwareSystem);
        }
        return softwareSystem;
    }
}

