/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.PerspectivesHolder;
import com.structurizr.PropertyHolder;
import com.structurizr.Workspace;
import com.structurizr.dsl.Archetype;
import com.structurizr.dsl.ArchetypeDslContext;
import com.structurizr.dsl.ArchetypeParser;
import com.structurizr.dsl.ArchetypesDslContext;
import com.structurizr.dsl.AutoLayoutParser;
import com.structurizr.dsl.BrandingDslContext;
import com.structurizr.dsl.BrandingParser;
import com.structurizr.dsl.CommentDslContext;
import com.structurizr.dsl.ComponentArchetypeDslContext;
import com.structurizr.dsl.ComponentDslContext;
import com.structurizr.dsl.ComponentFinderDslContext;
import com.structurizr.dsl.ComponentFinderParser;
import com.structurizr.dsl.ComponentFinderStrategyDslContext;
import com.structurizr.dsl.ComponentFinderStrategyForEachDslContext;
import com.structurizr.dsl.ComponentFinderStrategyParser;
import com.structurizr.dsl.ComponentParser;
import com.structurizr.dsl.ComponentViewDslContext;
import com.structurizr.dsl.ComponentViewParser;
import com.structurizr.dsl.ConfigurationDslContext;
import com.structurizr.dsl.ConfigurationParser;
import com.structurizr.dsl.ContainerArchetypeDslContext;
import com.structurizr.dsl.ContainerDslContext;
import com.structurizr.dsl.ContainerInstanceDslContext;
import com.structurizr.dsl.ContainerInstanceParser;
import com.structurizr.dsl.ContainerParser;
import com.structurizr.dsl.ContainerViewDslContext;
import com.structurizr.dsl.ContainerViewParser;
import com.structurizr.dsl.CustomElementDslContext;
import com.structurizr.dsl.CustomElementParser;
import com.structurizr.dsl.CustomViewAnimationDslContext;
import com.structurizr.dsl.CustomViewAnimationStepParser;
import com.structurizr.dsl.CustomViewContentParser;
import com.structurizr.dsl.CustomViewDslContext;
import com.structurizr.dsl.CustomViewParser;
import com.structurizr.dsl.DecisionsParser;
import com.structurizr.dsl.DefaultViewParser;
import com.structurizr.dsl.DeploymentEnvironment;
import com.structurizr.dsl.DeploymentEnvironmentDslContext;
import com.structurizr.dsl.DeploymentEnvironmentParser;
import com.structurizr.dsl.DeploymentGroup;
import com.structurizr.dsl.DeploymentGroupParser;
import com.structurizr.dsl.DeploymentNodeArchetypeDslContext;
import com.structurizr.dsl.DeploymentNodeDslContext;
import com.structurizr.dsl.DeploymentNodeParser;
import com.structurizr.dsl.DeploymentViewAnimationDslContext;
import com.structurizr.dsl.DeploymentViewAnimationStepParser;
import com.structurizr.dsl.DeploymentViewContentParser;
import com.structurizr.dsl.DeploymentViewDslContext;
import com.structurizr.dsl.DeploymentViewParser;
import com.structurizr.dsl.DocsParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.DslLine;
import com.structurizr.dsl.DslParserContext;
import com.structurizr.dsl.DslUtils;
import com.structurizr.dsl.DynamicViewContentParser;
import com.structurizr.dsl.DynamicViewDslContext;
import com.structurizr.dsl.DynamicViewParallelSequenceDslContext;
import com.structurizr.dsl.DynamicViewParser;
import com.structurizr.dsl.DynamicViewRelationshipContext;
import com.structurizr.dsl.DynamicViewRelationshipParser;
import com.structurizr.dsl.ElementDslContext;
import com.structurizr.dsl.ElementGroup;
import com.structurizr.dsl.ElementStyleDslContext;
import com.structurizr.dsl.ElementStyleParser;
import com.structurizr.dsl.ElementsDslContext;
import com.structurizr.dsl.ElementsParser;
import com.structurizr.dsl.ExplicitRelationshipParser;
import com.structurizr.dsl.ExternalScriptDslContext;
import com.structurizr.dsl.Features;
import com.structurizr.dsl.FilteredViewDslContext;
import com.structurizr.dsl.FilteredViewParser;
import com.structurizr.dsl.FindElementParser;
import com.structurizr.dsl.FindElementsParser;
import com.structurizr.dsl.FindRelationshipParser;
import com.structurizr.dsl.FindRelationshipsParser;
import com.structurizr.dsl.GroupParser;
import com.structurizr.dsl.GroupableDslContext;
import com.structurizr.dsl.HealthCheckParser;
import com.structurizr.dsl.IdentifierScope;
import com.structurizr.dsl.IdentifierScopeParser;
import com.structurizr.dsl.IdentifiersRegister;
import com.structurizr.dsl.ImageViewContentParser;
import com.structurizr.dsl.ImageViewDslContext;
import com.structurizr.dsl.ImageViewParser;
import com.structurizr.dsl.ImplicitRelationshipParser;
import com.structurizr.dsl.ImpliedRelationshipsParser;
import com.structurizr.dsl.IncludeParser;
import com.structurizr.dsl.IncludedDslContext;
import com.structurizr.dsl.IncludedFile;
import com.structurizr.dsl.InfrastructureNodeArchetypeDslContext;
import com.structurizr.dsl.InfrastructureNodeDslContext;
import com.structurizr.dsl.InfrastructureNodeParser;
import com.structurizr.dsl.InlineScriptDslContext;
import com.structurizr.dsl.ModelDslContext;
import com.structurizr.dsl.ModelItemDslContext;
import com.structurizr.dsl.ModelItemParser;
import com.structurizr.dsl.ModelItemsDslContext;
import com.structurizr.dsl.ModelItemsParser;
import com.structurizr.dsl.ModelViewDslContext;
import com.structurizr.dsl.NameValuePair;
import com.structurizr.dsl.NameValueParser;
import com.structurizr.dsl.NameValueType;
import com.structurizr.dsl.PersonArchetypeDslContext;
import com.structurizr.dsl.PersonDslContext;
import com.structurizr.dsl.PersonParser;
import com.structurizr.dsl.PerspectiveParser;
import com.structurizr.dsl.PerspectivesDslContext;
import com.structurizr.dsl.PluginDslContext;
import com.structurizr.dsl.PluginParser;
import com.structurizr.dsl.PropertiesDslContext;
import com.structurizr.dsl.PropertyParser;
import com.structurizr.dsl.RelationshipArchetypeDslContext;
import com.structurizr.dsl.RelationshipDslContext;
import com.structurizr.dsl.RelationshipStyleDslContext;
import com.structurizr.dsl.RelationshipStyleParser;
import com.structurizr.dsl.RelationshipsDslContext;
import com.structurizr.dsl.ScriptParser;
import com.structurizr.dsl.SoftwareSystemArchetypeDslContext;
import com.structurizr.dsl.SoftwareSystemDslContext;
import com.structurizr.dsl.SoftwareSystemInstanceDslContext;
import com.structurizr.dsl.SoftwareSystemInstanceParser;
import com.structurizr.dsl.SoftwareSystemParser;
import com.structurizr.dsl.StaticStructureElementInstanceDslContext;
import com.structurizr.dsl.StaticViewAnimationDslContext;
import com.structurizr.dsl.StaticViewAnimationStepParser;
import com.structurizr.dsl.StaticViewContentParser;
import com.structurizr.dsl.StaticViewDslContext;
import com.structurizr.dsl.StructurizrDslParserException;
import com.structurizr.dsl.StructurizrDslTokens;
import com.structurizr.dsl.StylesDslContext;
import com.structurizr.dsl.SystemContextViewDslContext;
import com.structurizr.dsl.SystemContextViewParser;
import com.structurizr.dsl.SystemLandscapeViewDslContext;
import com.structurizr.dsl.SystemLandscapeViewParser;
import com.structurizr.dsl.TerminologyDslContext;
import com.structurizr.dsl.TerminologyParser;
import com.structurizr.dsl.ThemeParser;
import com.structurizr.dsl.Tokenizer;
import com.structurizr.dsl.Tokens;
import com.structurizr.dsl.UserRoleParser;
import com.structurizr.dsl.UsersDslContext;
import com.structurizr.dsl.ViewDslContext;
import com.structurizr.dsl.ViewParser;
import com.structurizr.dsl.ViewsDslContext;
import com.structurizr.dsl.WorkspaceDslContext;
import com.structurizr.dsl.WorkspaceParser;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.CustomElement;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.FilteredView;
import com.structurizr.view.ImageView;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.SystemContextView;
import com.structurizr.view.SystemLandscapeView;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StructurizrDslParser
extends StructurizrDslTokens {
    private static final Log log = LogFactory.getLog(StructurizrDslParser.class);
    private static final String BOM = "\ufeff";
    private static final Pattern EMPTY_LINE_PATTERN = Pattern.compile("^\\s*");
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^\\s*?(//|#).*$");
    private static final String MULTI_LINE_COMMENT_START_TOKEN = "/*";
    private static final String MULTI_LINE_COMMENT_END_TOKEN = "*/";
    private static final String MULTI_LINE_SEPARATOR = "\\";
    private static final String TEXT_BLOCK_MARKER = "\"\"\"";
    private static final Pattern STRING_SUBSTITUTION_PATTERN = Pattern.compile("(\\$\\{[a-zA-Z0-9-_.]+?})");
    private static final String STRUCTURIZR_DSL_IDENTIFIER_PROPERTY_NAME = "structurizr.dsl.identifier";
    private Charset characterEncoding = StandardCharsets.UTF_8;
    private IdentifierScope identifierScope = IdentifierScope.Flat;
    private final Stack<DslContext> contextStack;
    private final Set<String> parsedTokens = new HashSet<String>();
    private final IdentifiersRegister identifiersRegister;
    private final Map<String, NameValuePair> constantsAndVariables;
    private final Features features = new Features();
    private final Map<String, Map<String, Archetype>> archetypes = Map.of("group", new HashMap(), "person", new HashMap(), "softwareSystem", new HashMap(), "container", new HashMap(), "component", new HashMap(), "deploymentNode", new HashMap(), "infrastructureNode", new HashMap(), "->", new HashMap());
    private final List<String> dslSourceLines = new ArrayList<String>();
    private Workspace workspace;
    private boolean extendingWorkspace = false;
    private boolean restricted = false;

    public StructurizrDslParser() {
        this.contextStack = new Stack();
        this.identifiersRegister = new IdentifiersRegister();
        this.constantsAndVariables = new HashMap<String, NameValuePair>();
    }

    public void setCharacterEncoding(Charset characterEncoding) {
        if (characterEncoding == null) {
            throw new IllegalArgumentException("A character encoding must be specified");
        }
        this.characterEncoding = characterEncoding;
    }

    IdentifierScope getIdentifierScope() {
        return this.identifierScope;
    }

    void setIdentifierScope(IdentifierScope identifierScope) {
        if (identifierScope == null) {
            identifierScope = IdentifierScope.Flat;
        }
        this.identifierScope = identifierScope;
        this.identifiersRegister.setIdentifierScope(identifierScope);
    }

    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    public Workspace getWorkspace() {
        String value;
        if (this.workspace != null && ((value = (String)this.workspace.getProperties().get("structurizr.dsl.source")) == null || value.equalsIgnoreCase("true"))) {
            DslUtils.setDsl(this.workspace, this.getParsedDsl());
        }
        return this.workspace;
    }

    private String getParsedDsl() {
        return String.join((CharSequence)System.lineSeparator(), this.dslSourceLines);
    }

    void parse(DslParserContext context, File path) throws StructurizrDslParserException {
        this.parse(path);
        context.copyFrom(this.identifiersRegister);
    }

    public void parse(File dslFile) throws StructurizrDslParserException {
        if (dslFile == null) {
            throw new StructurizrDslParserException("A file must be specified");
        }
        if (!dslFile.exists()) {
            throw new StructurizrDslParserException("The file at " + dslFile.getAbsolutePath() + " does not exist");
        }
        try {
            this.parse(Files.readAllLines(dslFile.toPath(), this.characterEncoding), dslFile, false, true);
        }
        catch (IOException e) {
            throw new StructurizrDslParserException(e.getMessage());
        }
    }

    void parse(DslParserContext context, String dsl) throws StructurizrDslParserException {
        this.parse(dsl);
        context.copyFrom(this.identifiersRegister);
    }

    public void parse(String dsl) throws StructurizrDslParserException {
        this.parse(dsl, new File("."));
    }

    public void parse(String dsl, File dslFile) throws StructurizrDslParserException {
        if (StringUtils.isNullOrEmpty((String)dsl)) {
            throw new StructurizrDslParserException("A DSL fragment must be specified");
        }
        List<String> lines = Arrays.asList(dsl.split("\\r?\\n"));
        this.parse(lines, dslFile, false, true);
    }

    void parse(List<String> lines, DslContext dslContext) throws StructurizrDslParserException {
        this.startContext(dslContext);
        this.parse(lines, null, true, false);
        this.endContext();
    }

    void parse(List<String> lines, File dslFile, boolean fragment, boolean includeInDslSourceLines) throws StructurizrDslParserException {
        List<DslLine> dslLines = this.preProcessLines(lines);
        for (DslLine dslLine : dslLines) {
            String line;
            String lineForDslSource = line = dslLine.getSource();
            if (line.startsWith(BOM)) {
                line = line.substring(1);
            }
            try {
                if (!EMPTY_LINE_PATTERN.matcher(line).matches() && !COMMENT_PATTERN.matcher(line).matches()) {
                    if (this.inContext(InlineScriptDslContext.class)) {
                        if ("}".equals(line.trim())) {
                            this.endContext();
                        } else {
                            this.getContext(InlineScriptDslContext.class).addLine(line);
                        }
                    } else {
                        List<String> listOfTokens = new Tokenizer().tokenize(line);
                        listOfTokens = listOfTokens.stream().map(this::substituteStrings).collect(Collectors.toList());
                        Tokens tokens = new Tokens(listOfTokens);
                        String identifier = null;
                        if (tokens.size() >= 3 && "=".equals(tokens.get(1))) {
                            identifier = tokens.get(0);
                            this.identifiersRegister.validateIdentifierName(identifier);
                            tokens = new Tokens(listOfTokens.subList(2, listOfTokens.size()));
                        }
                        String firstToken = tokens.get(0);
                        if (!line.trim().startsWith(MULTI_LINE_COMMENT_START_TOKEN) || !line.trim().endsWith(MULTI_LINE_COMMENT_END_TOKEN)) {
                            if (firstToken.startsWith(MULTI_LINE_COMMENT_START_TOKEN)) {
                                this.startContext(new CommentDslContext());
                            } else if (this.inContext(CommentDslContext.class) && line.trim().endsWith(MULTI_LINE_COMMENT_END_TOKEN)) {
                                this.endContext();
                            } else if (!this.inContext(CommentDslContext.class)) {
                                if ("}".equals(tokens.get(0))) {
                                    this.endContext();
                                } else if ("!include".equalsIgnoreCase(firstToken)) {
                                    if (!this.restricted || tokens.get(1).startsWith("https://") || tokens.get(1).startsWith("http://")) {
                                        String leadingSpace = line.substring(0, line.indexOf("!include"));
                                        IncludedDslContext context = new IncludedDslContext(dslFile);
                                        new IncludeParser().parse(context, tokens);
                                        for (IncludedFile includedFile : context.getFiles()) {
                                            ArrayList<String> paddedLines = new ArrayList<String>();
                                            for (String unpaddedLine : includedFile.getLines()) {
                                                if (unpaddedLine.startsWith(BOM)) {
                                                    unpaddedLine = unpaddedLine.substring(1);
                                                }
                                                paddedLines.add(leadingSpace + unpaddedLine);
                                            }
                                            this.parse(paddedLines, includedFile.getFile(), true, true);
                                        }
                                    } else {
                                        this.throwRestrictedModeException(firstToken + " <file>");
                                    }
                                    lineForDslSource = null;
                                } else if ("!plugin".equalsIgnoreCase(firstToken)) {
                                    if (!this.restricted) {
                                        String fullyQualifiedClassName = new PluginParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                        this.startContext(new PluginDslContext(fullyQualifiedClassName, dslFile, this));
                                        if (!this.shouldStartContext(tokens)) {
                                            this.endContext();
                                        }
                                    } else {
                                        this.throwRestrictedModeException(firstToken);
                                    }
                                } else if (this.inContext(PluginDslContext.class)) {
                                    new PluginParser().parseParameter(this.getContext(PluginDslContext.class), tokens);
                                } else if ("!script".equalsIgnoreCase(firstToken)) {
                                    if (!this.restricted) {
                                        ScriptParser scriptParser = new ScriptParser();
                                        if (scriptParser.isInlineScript(tokens)) {
                                            String language = scriptParser.parseInline(tokens.withoutContextStartToken());
                                            this.startContext(new InlineScriptDslContext(this.getContext(), dslFile, this, language));
                                        } else {
                                            String filename = scriptParser.parseExternal(tokens.withoutContextStartToken());
                                            this.startContext(new ExternalScriptDslContext(this.getContext(), dslFile, this, filename));
                                            if (!this.shouldStartContext(tokens)) {
                                                this.endContext();
                                            }
                                        }
                                    } else {
                                        this.throwRestrictedModeException(firstToken);
                                    }
                                } else if (this.inContext(ExternalScriptDslContext.class)) {
                                    new ScriptParser().parseParameter(this.getContext(ExternalScriptDslContext.class), tokens);
                                } else if (tokens.size() > 2 && this.isRelationshipKeywordOrArchetype(tokens.get(1)) && (this.inContext(ModelDslContext.class) || this.inContext(DeploymentEnvironmentDslContext.class) || this.inContext(ElementDslContext.class))) {
                                    archetype = this.getArchetype("->", tokens.get(1));
                                    relationship = new ExplicitRelationshipParser().parse(this.getContext(), tokens.withoutContextStartToken(), archetype);
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new RelationshipDslContext(relationship));
                                    }
                                    this.registerIdentifier(identifier, relationship);
                                } else if (tokens.size() >= 2 && this.isRelationshipKeywordOrArchetype(tokens.get(0)) && this.inContext(ElementDslContext.class)) {
                                    archetype = this.getArchetype("->", tokens.get(1));
                                    relationship = new ImplicitRelationshipParser().parse(this.getContext(ElementDslContext.class), tokens.withoutContextStartToken(), archetype);
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new RelationshipDslContext(relationship));
                                    }
                                    this.registerIdentifier(identifier, relationship);
                                } else if (tokens.size() > 2 && this.isRelationshipKeywordOrArchetype(tokens.get(1)) && this.inContext(ElementsDslContext.class)) {
                                    archetype = this.getArchetype("->", tokens.get(1));
                                    relationships = new ExplicitRelationshipParser().parse(this.getContext(ElementsDslContext.class), tokens.withoutContextStartToken(), archetype);
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new RelationshipsDslContext(this.getContext(), relationships));
                                    }
                                } else if (tokens.size() >= 2 && this.isRelationshipKeywordOrArchetype(tokens.get(0)) && this.inContext(ElementsDslContext.class)) {
                                    archetype = this.getArchetype("->", tokens.get(1));
                                    relationships = new ImplicitRelationshipParser().parse(this.getContext(ElementsDslContext.class), tokens.withoutContextStartToken(), archetype);
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new RelationshipsDslContext(this.getContext(), relationships));
                                    }
                                } else if (("!element".equalsIgnoreCase(firstToken) || "!relationship".equalsIgnoreCase(firstToken) || "!ref".equalsIgnoreCase(firstToken) || "!extend".equalsIgnoreCase(firstToken)) && (this.inContext(ModelItemDslContext.class) || this.inContext(ModelDslContext.class))) {
                                    Element modelItem = null;
                                    if ("!ref".equalsIgnoreCase(firstToken)) {
                                        throw new RuntimeException("!ref was previously deprecated, and has now been removed - please use !element or !relationship instead");
                                    }
                                    if ("!extend".equalsIgnoreCase(firstToken)) {
                                        throw new RuntimeException("!extend was previously deprecated, and has now been removed - please use !element or !relationship instead");
                                    }
                                    if ("!element".equalsIgnoreCase(firstToken)) {
                                        modelItem = new FindElementParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                    } else if ("!relationship".equalsIgnoreCase(firstToken)) {
                                        modelItem = new FindRelationshipParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                    }
                                    if (this.shouldStartContext(tokens)) {
                                        if (modelItem instanceof Person) {
                                            this.startContext(new PersonDslContext((Person)modelItem));
                                        } else if (modelItem instanceof SoftwareSystem) {
                                            this.startContext(new SoftwareSystemDslContext((SoftwareSystem)modelItem));
                                        } else if (modelItem instanceof Container) {
                                            this.startContext(new ContainerDslContext((Container)modelItem));
                                        } else if (modelItem instanceof Component) {
                                            this.startContext(new ComponentDslContext((Component)modelItem));
                                        } else if (modelItem instanceof DeploymentEnvironment) {
                                            this.startContext(new DeploymentEnvironmentDslContext(((DeploymentEnvironment)modelItem).getName()));
                                        } else if (modelItem instanceof DeploymentNode) {
                                            this.startContext(new DeploymentNodeDslContext((DeploymentNode)modelItem));
                                        } else if (modelItem instanceof InfrastructureNode) {
                                            this.startContext(new InfrastructureNodeDslContext((InfrastructureNode)modelItem));
                                        } else if (modelItem instanceof SoftwareSystemInstance) {
                                            this.startContext(new SoftwareSystemInstanceDslContext((SoftwareSystemInstance)modelItem));
                                        } else if (modelItem instanceof ContainerInstance) {
                                            this.startContext(new ContainerInstanceDslContext((ContainerInstance)modelItem));
                                        } else if (modelItem instanceof Relationship) {
                                            this.startContext(new RelationshipDslContext((Relationship)modelItem));
                                        }
                                    }
                                    if (!StringUtils.isNullOrEmpty((String)identifier)) {
                                        if (modelItem instanceof Element) {
                                            this.registerIdentifier(identifier, modelItem);
                                        } else if (modelItem instanceof Relationship) {
                                            this.registerIdentifier(identifier, (Relationship)modelItem);
                                        }
                                    }
                                } else if ("!elements".equalsIgnoreCase(firstToken) && (this.inContext(ModelDslContext.class) || this.inContext(DeploymentEnvironmentDslContext.class) || this.inContext(ElementDslContext.class))) {
                                    Set<Element> elements = new FindElementsParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new ElementsDslContext(this.getContext(), elements));
                                    }
                                } else if ("!relationships".equalsIgnoreCase(firstToken) && (this.inContext(ModelDslContext.class) || this.inContext(DeploymentEnvironmentDslContext.class) || this.inContext(ElementDslContext.class))) {
                                    Set<Relationship> relationships = new FindRelationshipsParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new RelationshipsDslContext(this.getContext(), relationships));
                                    }
                                } else if ("element".equalsIgnoreCase(firstToken) && this.inContext(ModelDslContext.class)) {
                                    CustomElement customElement = new CustomElementParser().parse(this.getContext(ModelDslContext.class), tokens.withoutContextStartToken());
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new CustomElementDslContext(customElement));
                                    }
                                    this.registerIdentifier(identifier, (Element)customElement);
                                } else if (this.isElementKeywordOrArchetype(firstToken, "person") && this.inContext(ModelDslContext.class)) {
                                    archetype = this.getArchetype("person", firstToken);
                                    Person person = new PersonParser().parse(this.getContext(ModelDslContext.class), tokens.withoutContextStartToken(), archetype);
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new PersonDslContext(person));
                                    }
                                    this.registerIdentifier(identifier, (Element)person);
                                } else if (this.isElementKeywordOrArchetype(firstToken, "softwareSystem") && this.inContext(ModelDslContext.class)) {
                                    archetype = this.getArchetype("softwareSystem", firstToken);
                                    softwareSystem = new SoftwareSystemParser().parse(this.getContext(ModelDslContext.class), tokens.withoutContextStartToken(), archetype);
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new SoftwareSystemDslContext(softwareSystem));
                                    }
                                    this.registerIdentifier(identifier, (Element)softwareSystem);
                                } else if (this.isElementKeywordOrArchetype(firstToken, "container") && this.inContext(SoftwareSystemDslContext.class)) {
                                    archetype = this.getArchetype("container", firstToken);
                                    container = new ContainerParser().parse(this.getContext(SoftwareSystemDslContext.class), tokens.withoutContextStartToken(), archetype);
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new ContainerDslContext(container));
                                    }
                                    this.registerIdentifier(identifier, (Element)container);
                                } else if (this.isElementKeywordOrArchetype(firstToken, "component") && this.inContext(ContainerDslContext.class)) {
                                    archetype = this.getArchetype("component", firstToken);
                                    Component component = new ComponentParser().parse(this.getContext(ContainerDslContext.class), tokens.withoutContextStartToken(), archetype);
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new ComponentDslContext(component));
                                    }
                                    this.registerIdentifier(identifier, (Element)component);
                                } else if ("!components".equalsIgnoreCase(firstToken) && this.inContext(ContainerDslContext.class)) {
                                    if (!this.restricted) {
                                        if (this.shouldStartContext(tokens)) {
                                            this.startContext(new ComponentFinderDslContext(this, this.getContext(ContainerDslContext.class)));
                                        }
                                    } else {
                                        this.throwRestrictedModeException(firstToken);
                                    }
                                } else if ("classes".equalsIgnoreCase(firstToken) && this.inContext(ComponentFinderDslContext.class)) {
                                    new ComponentFinderParser().parseClasses(this.getContext(ComponentFinderDslContext.class), tokens);
                                } else if ("source".equalsIgnoreCase(firstToken) && this.inContext(ComponentFinderDslContext.class)) {
                                    new ComponentFinderParser().parseSource(this.getContext(ComponentFinderDslContext.class), tokens);
                                } else if ("filter".equalsIgnoreCase(firstToken) && this.inContext(ComponentFinderDslContext.class)) {
                                    new ComponentFinderParser().parseFilter(this.getContext(ComponentFinderDslContext.class), tokens);
                                } else if ("strategy".equalsIgnoreCase(firstToken) && this.inContext(ComponentFinderDslContext.class)) {
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new ComponentFinderStrategyDslContext(this.getContext(ComponentFinderDslContext.class)));
                                    }
                                } else if ("technology".equalsIgnoreCase(firstToken) && this.inContext(ComponentFinderStrategyDslContext.class)) {
                                    new ComponentFinderStrategyParser().parseTechnology(this.getContext(ComponentFinderStrategyDslContext.class), tokens);
                                } else if ("matcher".equalsIgnoreCase(firstToken) && this.inContext(ComponentFinderStrategyDslContext.class)) {
                                    new ComponentFinderStrategyParser().parseMatcher(this.getContext(ComponentFinderStrategyDslContext.class), tokens, dslFile);
                                } else if ("filter".equalsIgnoreCase(firstToken) && this.inContext(ComponentFinderStrategyDslContext.class)) {
                                    new ComponentFinderStrategyParser().parseFilter(this.getContext(ComponentFinderStrategyDslContext.class), tokens, dslFile);
                                } else if ("supportingTypes".equalsIgnoreCase(firstToken) && this.inContext(ComponentFinderStrategyDslContext.class)) {
                                    new ComponentFinderStrategyParser().parseSupportingTypes(this.getContext(ComponentFinderStrategyDslContext.class), tokens, dslFile);
                                } else if ("name".equalsIgnoreCase(firstToken) && this.inContext(ComponentFinderStrategyDslContext.class)) {
                                    new ComponentFinderStrategyParser().parseName(this.getContext(ComponentFinderStrategyDslContext.class), tokens, dslFile);
                                } else if ("description".equalsIgnoreCase(firstToken) && this.inContext(ComponentFinderStrategyDslContext.class)) {
                                    new ComponentFinderStrategyParser().parseDescription(this.getContext(ComponentFinderStrategyDslContext.class), tokens, dslFile);
                                } else if ("url".equalsIgnoreCase(firstToken) && this.inContext(ComponentFinderStrategyDslContext.class)) {
                                    new ComponentFinderStrategyParser().parseUrl(this.getContext(ComponentFinderStrategyDslContext.class), tokens, dslFile);
                                } else if ("forEach".equalsIgnoreCase(firstToken) && this.inContext(ComponentFinderStrategyDslContext.class)) {
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new ComponentFinderStrategyForEachDslContext(this.getContext(ComponentFinderStrategyDslContext.class), this));
                                    }
                                } else if (this.inContext(ComponentFinderStrategyForEachDslContext.class)) {
                                    this.getContext(ComponentFinderStrategyForEachDslContext.class).addLine(line);
                                } else {
                                    if ("enterprise".equalsIgnoreCase(firstToken) && this.inContext(ModelDslContext.class)) {
                                        throw new RuntimeException("The enterprise keyword was previously deprecated, and has now been removed - please use group instead (https://docs.structurizr.com/dsl/language#group)");
                                    }
                                    if (this.isElementKeywordOrArchetype(firstToken, "group") && this.inContext(ModelDslContext.class)) {
                                        group = new GroupParser().parseContext(this.getContext(ModelDslContext.class), tokens);
                                        this.startContext(new ModelDslContext((ElementGroup)((Object)group)));
                                        this.registerIdentifier(identifier, (Element)group);
                                    } else if (this.isElementKeywordOrArchetype(firstToken, "group") && this.inContext(SoftwareSystemDslContext.class)) {
                                        group = new GroupParser().parseContext(this.getContext(SoftwareSystemDslContext.class), tokens);
                                        softwareSystem = this.getContext(SoftwareSystemDslContext.class).getSoftwareSystem();
                                        group.setParent((Element)softwareSystem);
                                        this.startContext(new SoftwareSystemDslContext(softwareSystem, (ElementGroup)((Object)group)));
                                        this.registerIdentifier(identifier, (Element)group);
                                    } else if (this.isElementKeywordOrArchetype(firstToken, "group") && this.inContext(ContainerDslContext.class)) {
                                        group = new GroupParser().parseContext(this.getContext(ContainerDslContext.class), tokens);
                                        container = this.getContext(ContainerDslContext.class).getContainer();
                                        group.setParent((Element)container);
                                        this.startContext(new ContainerDslContext(container, (ElementGroup)((Object)group)));
                                        this.registerIdentifier(identifier, (Element)group);
                                    } else if (this.isElementKeywordOrArchetype(firstToken, "group") && this.inContext(DeploymentEnvironmentDslContext.class)) {
                                        group = new GroupParser().parseContext(this.getContext(DeploymentEnvironmentDslContext.class), tokens);
                                        String environment = this.getContext(DeploymentEnvironmentDslContext.class).getEnvironment();
                                        this.startContext(new DeploymentEnvironmentDslContext(environment, (ElementGroup)((Object)group)));
                                        this.registerIdentifier(identifier, (Element)group);
                                    } else if (this.isElementKeywordOrArchetype(firstToken, "group") && this.inContext(DeploymentNodeDslContext.class)) {
                                        group = new GroupParser().parseContext(this.getContext(DeploymentNodeDslContext.class), tokens);
                                        deploymentNode = this.getContext(DeploymentNodeDslContext.class).getDeploymentNode();
                                        this.startContext(new DeploymentNodeDslContext(deploymentNode, (ElementGroup)((Object)group)));
                                        this.registerIdentifier(identifier, (Element)group);
                                    } else if (("tags".equalsIgnoreCase(firstToken) || "tag".equalsIgnoreCase(firstToken)) && this.inContext(ModelItemDslContext.class) && !this.isGroup(this.getContext())) {
                                        new ModelItemParser().parseTags(this.getContext(ModelItemDslContext.class), tokens);
                                    } else if (("tags".equalsIgnoreCase(firstToken) || "tag".equalsIgnoreCase(firstToken)) && this.inContext(ModelItemsDslContext.class)) {
                                        new ModelItemsParser().parseTags(this.getContext(ModelItemsDslContext.class), tokens);
                                    } else if ("description".equalsIgnoreCase(firstToken) && this.inContext(ElementDslContext.class) && !this.isGroup(this.getContext())) {
                                        new ModelItemParser().parseDescription(this.getContext(ElementDslContext.class), tokens);
                                    } else if ("description".equalsIgnoreCase(firstToken) && this.inContext(ElementsDslContext.class)) {
                                        new ElementsParser().parseDescription(this.getContext(ElementsDslContext.class), tokens);
                                    } else if ("technology".equalsIgnoreCase(firstToken) && this.inContext(ContainerDslContext.class) && !this.getContext(ContainerDslContext.class).hasGroup()) {
                                        new ContainerParser().parseTechnology(this.getContext(ContainerDslContext.class), tokens);
                                    } else if ("technology".equalsIgnoreCase(firstToken) && this.inContext(ComponentDslContext.class) && !this.getContext(ComponentDslContext.class).hasGroup()) {
                                        new ComponentParser().parseTechnology(this.getContext(ComponentDslContext.class), tokens);
                                    } else if ("technology".equalsIgnoreCase(firstToken) && this.inContext(DeploymentNodeDslContext.class)) {
                                        new DeploymentNodeParser().parseTechnology(this.getContext(DeploymentNodeDslContext.class), tokens);
                                    } else if ("technology".equalsIgnoreCase(firstToken) && this.inContext(InfrastructureNodeDslContext.class)) {
                                        new InfrastructureNodeParser().parseTechnology(this.getContext(InfrastructureNodeDslContext.class), tokens);
                                    } else if ("technology".equalsIgnoreCase(firstToken) && this.inContext(ElementsDslContext.class)) {
                                        new ElementsParser().parseTechnology(this.getContext(ElementsDslContext.class), tokens);
                                    } else if ("instances".equalsIgnoreCase(firstToken) && this.inContext(DeploymentNodeDslContext.class)) {
                                        new DeploymentNodeParser().parseInstances(this.getContext(DeploymentNodeDslContext.class), tokens);
                                    } else if ("url".equalsIgnoreCase(firstToken) && this.inContext(ModelItemDslContext.class) && !this.isGroup(this.getContext())) {
                                        new ModelItemParser().parseUrl(this.getContext(ModelItemDslContext.class), tokens);
                                    } else if ("url".equalsIgnoreCase(firstToken) && this.inContext(ModelItemsDslContext.class)) {
                                        new ModelItemsParser().parseUrl(this.getContext(ModelItemsDslContext.class), tokens);
                                    } else if ("properties".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                        this.startContext(new PropertiesDslContext((PropertyHolder)this.workspace));
                                    } else if ("properties".equalsIgnoreCase(firstToken) && this.inContext(ModelDslContext.class)) {
                                        this.startContext(new PropertiesDslContext((PropertyHolder)this.workspace.getModel()));
                                    } else if ("properties".equalsIgnoreCase(firstToken) && this.inContext(ConfigurationDslContext.class)) {
                                        this.startContext(new PropertiesDslContext((PropertyHolder)this.getContext(ConfigurationDslContext.class).getWorkspace()));
                                    } else if ("properties".equalsIgnoreCase(firstToken) && this.inContext(ModelItemDslContext.class) && !this.isGroup(this.getContext())) {
                                        this.startContext(new PropertiesDslContext((PropertyHolder)this.getContext(ModelItemDslContext.class).getModelItem()));
                                    } else if ("properties".equalsIgnoreCase(firstToken) && this.inContext(ModelItemsDslContext.class)) {
                                        this.startContext(new PropertiesDslContext(this.getContext(ModelItemsDslContext.class).getModelItems().stream().map(mi -> mi).toList()));
                                    } else if ("properties".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                        this.startContext(new PropertiesDslContext((PropertyHolder)this.workspace.getViews().getConfiguration()));
                                    } else if ("properties".equalsIgnoreCase(firstToken) && this.inContext(ViewDslContext.class)) {
                                        this.startContext(new PropertiesDslContext((PropertyHolder)this.getContext(ViewDslContext.class).getView()));
                                    } else if ("properties".equalsIgnoreCase(firstToken) && this.inContext(DynamicViewRelationshipContext.class)) {
                                        this.startContext(new PropertiesDslContext((PropertyHolder)this.getContext(DynamicViewRelationshipContext.class).getRelationshipView()));
                                    } else if ("properties".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                        this.startContext(new PropertiesDslContext((PropertyHolder)this.getContext(ElementStyleDslContext.class).getStyle()));
                                    } else if ("properties".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                        this.startContext(new PropertiesDslContext((PropertyHolder)this.getContext(RelationshipStyleDslContext.class).getStyle()));
                                    } else if (this.inContext(PropertiesDslContext.class)) {
                                        new PropertyParser().parse(this.getContext(PropertiesDslContext.class), tokens);
                                    } else if ("perspectives".equalsIgnoreCase(firstToken) && this.inContext(ModelItemDslContext.class) && !this.isGroup(this.getContext())) {
                                        this.startContext(new PerspectivesDslContext((PerspectivesHolder)this.getContext(ModelItemDslContext.class).getModelItem()));
                                    } else if ("perspectives".equalsIgnoreCase(firstToken) && this.inContext(ModelItemsDslContext.class)) {
                                        this.startContext(new PerspectivesDslContext(this.getContext(ModelItemsDslContext.class).getModelItems()));
                                    } else if (this.inContext(PerspectivesDslContext.class)) {
                                        new PerspectiveParser().parse(this.getContext(PerspectivesDslContext.class), tokens);
                                    } else if ("group".equalsIgnoreCase(firstToken) && this.inContext(ComponentDslContext.class)) {
                                        new GroupParser().parseProperty(this.getContext(ComponentDslContext.class), tokens);
                                    } else if ("workspace".equalsIgnoreCase(firstToken) && this.contextStack.empty()) {
                                        if (this.parsedTokens.contains("workspace")) {
                                            throw new RuntimeException("Multiple workspaces are not permitted in a DSL definition");
                                        }
                                        DslParserContext dslParserContext = new DslParserContext(this, dslFile, this.restricted);
                                        dslParserContext.setIdentifierRegister(this.identifiersRegister);
                                        this.workspace = new WorkspaceParser().parse(dslParserContext, tokens.withoutContextStartToken());
                                        this.extendingWorkspace = !this.workspace.getModel().isEmpty();
                                        this.startContext(new WorkspaceDslContext());
                                        this.parsedTokens.add("workspace");
                                    } else if ("!impliedRelationships".equalsIgnoreCase(firstToken) || "!impliedRelationships".substring(1).equalsIgnoreCase(firstToken)) {
                                        new ImpliedRelationshipsParser().parse(this.getContext(), tokens, dslFile, this.restricted);
                                    } else if ("name".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                        new WorkspaceParser().parseName(this.getContext(), tokens);
                                    } else if ("description".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                        new WorkspaceParser().parseDescription(this.getContext(), tokens);
                                    } else if ("model".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                        if (this.parsedTokens.contains("model")) {
                                            throw new RuntimeException("Multiple models are not permitted in a DSL definition");
                                        }
                                        this.startContext(new ModelDslContext());
                                        this.parsedTokens.add("model");
                                    } else if ("archetypes".equalsIgnoreCase(firstToken) && this.inContext(ModelDslContext.class)) {
                                        this.startContext(new ArchetypesDslContext());
                                    } else if (this.isElementKeywordOrArchetype(firstToken, "group") && this.inContext(ArchetypesDslContext.class)) {
                                        archetype = new Archetype(identifier, "group");
                                        this.extendArchetype(archetype, firstToken);
                                        this.addArchetype(archetype);
                                    } else if (this.isElementKeywordOrArchetype(firstToken, "person") && this.inContext(ArchetypesDslContext.class)) {
                                        archetype = new Archetype(identifier, "person");
                                        this.extendArchetype(archetype, firstToken);
                                        this.addArchetype(archetype);
                                        if (this.shouldStartContext(tokens)) {
                                            this.startContext(new PersonArchetypeDslContext(archetype));
                                        }
                                    } else if (this.isElementKeywordOrArchetype(firstToken, "softwareSystem") && this.inContext(ArchetypesDslContext.class)) {
                                        archetype = new Archetype(identifier, "softwareSystem");
                                        this.extendArchetype(archetype, firstToken);
                                        this.addArchetype(archetype);
                                        if (this.shouldStartContext(tokens)) {
                                            this.startContext(new SoftwareSystemArchetypeDslContext(archetype));
                                        }
                                    } else if (this.isElementKeywordOrArchetype(firstToken, "container") && this.inContext(ArchetypesDslContext.class)) {
                                        archetype = new Archetype(identifier, "container");
                                        this.extendArchetype(archetype, firstToken);
                                        this.addArchetype(archetype);
                                        if (this.shouldStartContext(tokens)) {
                                            this.startContext(new ContainerArchetypeDslContext(archetype));
                                        }
                                    } else if (this.isElementKeywordOrArchetype(firstToken, "component") && this.inContext(ArchetypesDslContext.class)) {
                                        archetype = new Archetype(identifier, "component");
                                        this.extendArchetype(archetype, firstToken);
                                        this.addArchetype(archetype);
                                        if (this.shouldStartContext(tokens)) {
                                            this.startContext(new ComponentArchetypeDslContext(archetype));
                                        }
                                    } else if (this.isElementKeywordOrArchetype(firstToken, "deploymentNode") && this.inContext(ArchetypesDslContext.class)) {
                                        archetype = new Archetype(identifier, "deploymentNode");
                                        this.extendArchetype(archetype, firstToken);
                                        this.addArchetype(archetype);
                                        if (this.shouldStartContext(tokens)) {
                                            this.startContext(new DeploymentNodeArchetypeDslContext(archetype));
                                        }
                                    } else if (this.isElementKeywordOrArchetype(firstToken, "infrastructureNode") && this.inContext(ArchetypesDslContext.class)) {
                                        archetype = new Archetype(identifier, "infrastructureNode");
                                        this.extendArchetype(archetype, firstToken);
                                        this.addArchetype(archetype);
                                        if (this.shouldStartContext(tokens)) {
                                            this.startContext(new InfrastructureNodeArchetypeDslContext(archetype));
                                        }
                                    } else if (this.isRelationshipKeywordOrArchetype(firstToken) && this.inContext(ArchetypesDslContext.class)) {
                                        archetype = new Archetype(identifier, "->");
                                        this.extendArchetype(archetype, firstToken);
                                        this.addArchetype(archetype);
                                        if (this.shouldStartContext(tokens)) {
                                            this.startContext(new RelationshipArchetypeDslContext(archetype));
                                        }
                                    } else if ("description".equalsIgnoreCase(firstToken) && this.inContext(ArchetypeDslContext.class)) {
                                        new ArchetypeParser().parseDescription(this.getContext(ArchetypeDslContext.class), tokens);
                                    } else if ("technology".equalsIgnoreCase(firstToken) && (this.inContext(ContainerArchetypeDslContext.class) || this.inContext(ComponentArchetypeDslContext.class) || this.inContext(DeploymentNodeArchetypeDslContext.class) || this.inContext(InfrastructureNodeArchetypeDslContext.class) || this.inContext(RelationshipArchetypeDslContext.class))) {
                                        new ArchetypeParser().parseTechnology(this.getContext(ArchetypeDslContext.class), tokens);
                                    } else if ("tag".equalsIgnoreCase(firstToken) && this.inContext(ArchetypeDslContext.class)) {
                                        new ArchetypeParser().parseTag(this.getContext(ArchetypeDslContext.class), tokens);
                                    } else if ("tags".equalsIgnoreCase(firstToken) && this.inContext(ArchetypeDslContext.class)) {
                                        new ArchetypeParser().parseTags(this.getContext(ArchetypeDslContext.class), tokens);
                                    } else if ("properties".equalsIgnoreCase(firstToken) && this.inContext(ArchetypeDslContext.class)) {
                                        archetype = this.getContext(ArchetypeDslContext.class).getArchetype();
                                        this.startContext(new PropertiesDslContext(archetype));
                                    } else if ("perspectives".equalsIgnoreCase(firstToken) && this.inContext(ArchetypeDslContext.class)) {
                                        archetype = this.getContext(ArchetypeDslContext.class).getArchetype();
                                        this.startContext(new PerspectivesDslContext(archetype));
                                    } else if ("views".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                        if (this.parsedTokens.contains("views")) {
                                            throw new RuntimeException("Multiple view sets are not permitted in a DSL definition");
                                        }
                                        this.startContext(new ViewsDslContext());
                                        this.parsedTokens.add("views");
                                    } else if ("branding".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                        this.startContext(new BrandingDslContext(dslFile));
                                    } else if ("logo".equalsIgnoreCase(firstToken) && this.inContext(BrandingDslContext.class)) {
                                        new BrandingParser().parseLogo(this.getContext(BrandingDslContext.class), tokens, this.restricted);
                                    } else if ("font".equalsIgnoreCase(firstToken) && this.inContext(BrandingDslContext.class)) {
                                        new BrandingParser().parseFont(this.getContext(BrandingDslContext.class), tokens);
                                    } else if ("styles".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                        this.startContext(new StylesDslContext());
                                    } else if ("element".equalsIgnoreCase(firstToken) && this.inContext(StylesDslContext.class)) {
                                        ElementStyle elementStyle = new ElementStyleParser().parseElementStyle(this.getContext(), tokens.withoutContextStartToken());
                                        this.startContext(new ElementStyleDslContext(elementStyle, dslFile));
                                    } else if ("background".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                        new ElementStyleParser().parseBackground(this.getContext(ElementStyleDslContext.class), tokens);
                                    } else if (("colour".equalsIgnoreCase(firstToken) || "color".equalsIgnoreCase(firstToken)) && this.inContext(ElementStyleDslContext.class)) {
                                        new ElementStyleParser().parseColour(this.getContext(ElementStyleDslContext.class), tokens);
                                    } else if ("stroke".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                        new ElementStyleParser().parseStroke(this.getContext(ElementStyleDslContext.class), tokens);
                                    } else if ("strokeWidth".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                        new ElementStyleParser().parseStrokeWidth(this.getContext(ElementStyleDslContext.class), tokens);
                                    } else if ("shape".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                        new ElementStyleParser().parseShape(this.getContext(ElementStyleDslContext.class), tokens);
                                    } else if ("border".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                        new ElementStyleParser().parseBorder(this.getContext(ElementStyleDslContext.class), tokens);
                                    } else if ("opacity".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                        new ElementStyleParser().parseOpacity(this.getContext(ElementStyleDslContext.class), tokens);
                                    } else if ("width".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                        new ElementStyleParser().parseWidth(this.getContext(ElementStyleDslContext.class), tokens);
                                    } else if ("height".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                        new ElementStyleParser().parseHeight(this.getContext(ElementStyleDslContext.class), tokens);
                                    } else if ("fontSize".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                        new ElementStyleParser().parseFontSize(this.getContext(ElementStyleDslContext.class), tokens);
                                    } else if ("metadata".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                        new ElementStyleParser().parseMetadata(this.getContext(ElementStyleDslContext.class), tokens);
                                    } else if ("description".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                        new ElementStyleParser().parseDescription(this.getContext(ElementStyleDslContext.class), tokens);
                                    } else if ("icon".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                        new ElementStyleParser().parseIcon(this.getContext(ElementStyleDslContext.class), tokens, this.restricted);
                                    } else if ("relationship".equalsIgnoreCase(firstToken) && this.inContext(StylesDslContext.class)) {
                                        RelationshipStyle relationshipStyle = new RelationshipStyleParser().parseRelationshipStyle(this.getContext(), tokens.withoutContextStartToken());
                                        this.startContext(new RelationshipStyleDslContext(relationshipStyle));
                                    } else if ("thickness".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                        new RelationshipStyleParser().parseThickness(this.getContext(RelationshipStyleDslContext.class), tokens);
                                    } else if (("colour".equalsIgnoreCase(firstToken) || "color".equalsIgnoreCase(firstToken)) && this.inContext(RelationshipStyleDslContext.class)) {
                                        new RelationshipStyleParser().parseColour(this.getContext(RelationshipStyleDslContext.class), tokens);
                                    } else if ("dashed".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                        new RelationshipStyleParser().parseDashed(this.getContext(RelationshipStyleDslContext.class), tokens);
                                    } else if ("opacity".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                        new RelationshipStyleParser().parseOpacity(this.getContext(RelationshipStyleDslContext.class), tokens);
                                    } else if ("width".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                        new RelationshipStyleParser().parseWidth(this.getContext(RelationshipStyleDslContext.class), tokens);
                                    } else if ("fontSize".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                        new RelationshipStyleParser().parseFontSize(this.getContext(RelationshipStyleDslContext.class), tokens);
                                    } else if ("position".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                        new RelationshipStyleParser().parsePosition(this.getContext(RelationshipStyleDslContext.class), tokens);
                                    } else if ("style".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                        new RelationshipStyleParser().parseLineStyle(this.getContext(RelationshipStyleDslContext.class), tokens);
                                    } else if ("routing".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                        new RelationshipStyleParser().parseRouting(this.getContext(RelationshipStyleDslContext.class), tokens);
                                    } else if ("deploymentEnvironment".equalsIgnoreCase(firstToken) && this.inContext(ModelDslContext.class)) {
                                        String environment = new DeploymentEnvironmentParser().parse(tokens.withoutContextStartToken());
                                        if (this.shouldStartContext(tokens)) {
                                            this.startContext(new DeploymentEnvironmentDslContext(environment));
                                        }
                                        this.registerIdentifier(identifier, new DeploymentEnvironment(environment));
                                    } else if ("deploymentGroup".equalsIgnoreCase(firstToken) && this.inContext(DeploymentEnvironmentDslContext.class)) {
                                        group = new DeploymentGroupParser().parse(tokens.withoutContextStartToken());
                                        this.registerIdentifier(identifier, new DeploymentGroup((String)group));
                                    } else if (this.isElementKeywordOrArchetype(firstToken, "deploymentNode") && this.inContext(DeploymentEnvironmentDslContext.class)) {
                                        archetype = this.getArchetype("deploymentNode", firstToken);
                                        deploymentNode = new DeploymentNodeParser().parse(this.getContext(DeploymentEnvironmentDslContext.class), tokens.withoutContextStartToken(), archetype);
                                        if (this.shouldStartContext(tokens)) {
                                            this.startContext(new DeploymentNodeDslContext(deploymentNode));
                                        }
                                        this.registerIdentifier(identifier, (Element)deploymentNode);
                                    } else if (this.isElementKeywordOrArchetype(firstToken, "deploymentNode") && this.inContext(DeploymentNodeDslContext.class)) {
                                        archetype = this.getArchetype("deploymentNode", firstToken);
                                        deploymentNode = new DeploymentNodeParser().parse(this.getContext(DeploymentNodeDslContext.class), tokens.withoutContextStartToken(), archetype);
                                        if (this.shouldStartContext(tokens)) {
                                            this.startContext(new DeploymentNodeDslContext(deploymentNode));
                                        }
                                        this.registerIdentifier(identifier, (Element)deploymentNode);
                                    } else if (this.isElementKeywordOrArchetype(firstToken, "infrastructureNode") && this.inContext(DeploymentNodeDslContext.class)) {
                                        archetype = this.getArchetype("infrastructureNode", firstToken);
                                        InfrastructureNode infrastructureNode = new InfrastructureNodeParser().parse(this.getContext(DeploymentNodeDslContext.class), tokens.withoutContextStartToken(), archetype);
                                        if (this.shouldStartContext(tokens)) {
                                            this.startContext(new InfrastructureNodeDslContext(infrastructureNode));
                                        }
                                        this.registerIdentifier(identifier, (Element)infrastructureNode);
                                    } else if ("softwareSystemInstance".equalsIgnoreCase(firstToken) && this.inContext(DeploymentNodeDslContext.class)) {
                                        SoftwareSystemInstance softwareSystemInstance = new SoftwareSystemInstanceParser().parse(this.getContext(DeploymentNodeDslContext.class), tokens.withoutContextStartToken());
                                        if (this.shouldStartContext(tokens)) {
                                            this.startContext(new SoftwareSystemInstanceDslContext(softwareSystemInstance));
                                        }
                                        this.registerIdentifier(identifier, (Element)softwareSystemInstance);
                                    } else if ("containerInstance".equalsIgnoreCase(firstToken) && this.inContext(DeploymentNodeDslContext.class)) {
                                        ContainerInstance containerInstance = new ContainerInstanceParser().parse(this.getContext(DeploymentNodeDslContext.class), tokens.withoutContextStartToken());
                                        if (this.shouldStartContext(tokens)) {
                                            this.startContext(new ContainerInstanceDslContext(containerInstance));
                                        }
                                        this.registerIdentifier(identifier, (Element)containerInstance);
                                    } else if ("healthCheck".equalsIgnoreCase(firstToken) && this.inContext(StaticStructureElementInstanceDslContext.class)) {
                                        new HealthCheckParser().parse(this.getContext(StaticStructureElementInstanceDslContext.class), tokens.withoutContextStartToken());
                                    } else if ("custom".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                        view = new CustomViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                        this.startContext(new CustomViewDslContext(view));
                                    } else if ("systemLandscape".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                        view = new SystemLandscapeViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                        this.startContext(new SystemLandscapeViewDslContext((SystemLandscapeView)view));
                                    } else if ("systemContext".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                        view = new SystemContextViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                        this.startContext(new SystemContextViewDslContext((SystemContextView)view));
                                    } else if ("container".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                        view = new ContainerViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                        this.startContext(new ContainerViewDslContext((ContainerView)view));
                                    } else if ("component".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                        view = new ComponentViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                        this.startContext(new ComponentViewDslContext((ComponentView)view));
                                    } else if ("dynamic".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                        view = new DynamicViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                        this.startContext(new DynamicViewDslContext((DynamicView)view));
                                    } else if ("deployment".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                        view = new DeploymentViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                        this.startContext(new DeploymentViewDslContext((DeploymentView)view));
                                    } else if ("filtered".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                        view = new FilteredViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                        if (this.shouldStartContext(tokens)) {
                                            this.startContext(new FilteredViewDslContext((FilteredView)view));
                                        }
                                    } else if ("image".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                        view = new ImageViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                        this.startContext(new ImageViewDslContext((ImageView)view));
                                    } else if ("{".equalsIgnoreCase(firstToken) && this.inContext(DynamicViewDslContext.class)) {
                                        this.startContext(new DynamicViewParallelSequenceDslContext(this.getContext(DynamicViewDslContext.class)));
                                    } else if ("include".equalsIgnoreCase(firstToken) && this.inContext(CustomViewDslContext.class)) {
                                        new CustomViewContentParser().parseInclude(this.getContext(CustomViewDslContext.class), tokens);
                                    } else if ("exclude".equalsIgnoreCase(firstToken) && this.inContext(CustomViewDslContext.class)) {
                                        new CustomViewContentParser().parseExclude(this.getContext(CustomViewDslContext.class), tokens);
                                    } else if ("animationStep".equalsIgnoreCase(firstToken) && this.inContext(CustomViewDslContext.class)) {
                                        new CustomViewAnimationStepParser().parse(this.getContext(CustomViewDslContext.class), tokens);
                                    } else if ("animation".equalsIgnoreCase(firstToken) && this.inContext(CustomViewDslContext.class)) {
                                        this.startContext(new CustomViewAnimationDslContext(this.getContext(CustomViewDslContext.class).getCustomView()));
                                    } else if (this.inContext(CustomViewAnimationDslContext.class)) {
                                        new CustomViewAnimationStepParser().parse(this.getContext(CustomViewAnimationDslContext.class), tokens);
                                    } else if ("include".equalsIgnoreCase(firstToken) && this.inContext(StaticViewDslContext.class)) {
                                        new StaticViewContentParser().parseInclude(this.getContext(StaticViewDslContext.class), tokens);
                                    } else if ("exclude".equalsIgnoreCase(firstToken) && this.inContext(StaticViewDslContext.class)) {
                                        new StaticViewContentParser().parseExclude(this.getContext(StaticViewDslContext.class), tokens);
                                    } else if ("animationStep".equalsIgnoreCase(firstToken) && this.inContext(StaticViewDslContext.class)) {
                                        new StaticViewAnimationStepParser().parse(this.getContext(StaticViewDslContext.class), tokens);
                                    } else if ("animation".equalsIgnoreCase(firstToken) && this.inContext(StaticViewDslContext.class)) {
                                        this.startContext(new StaticViewAnimationDslContext(this.getContext(StaticViewDslContext.class).getView()));
                                    } else if (this.inContext(StaticViewAnimationDslContext.class)) {
                                        new StaticViewAnimationStepParser().parse(this.getContext(StaticViewAnimationDslContext.class), tokens);
                                    } else if ("include".equalsIgnoreCase(firstToken) && this.inContext(DeploymentViewDslContext.class)) {
                                        new DeploymentViewContentParser().parseInclude(this.getContext(DeploymentViewDslContext.class), tokens);
                                    } else if ("exclude".equalsIgnoreCase(firstToken) && this.inContext(DeploymentViewDslContext.class)) {
                                        new DeploymentViewContentParser().parseExclude(this.getContext(DeploymentViewDslContext.class), tokens);
                                    } else if ("animationStep".equalsIgnoreCase(firstToken) && this.inContext(DeploymentViewDslContext.class)) {
                                        new DeploymentViewAnimationStepParser().parse(this.getContext(DeploymentViewDslContext.class), tokens);
                                    } else if ("animation".equalsIgnoreCase(firstToken) && this.inContext(DeploymentViewDslContext.class)) {
                                        this.startContext(new DeploymentViewAnimationDslContext(this.getContext(DeploymentViewDslContext.class).getView()));
                                    } else if (this.inContext(DeploymentViewAnimationDslContext.class)) {
                                        new DeploymentViewAnimationStepParser().parse(this.getContext(DeploymentViewAnimationDslContext.class), tokens);
                                    } else if ("autolayout".equalsIgnoreCase(firstToken) && this.inContext(ViewDslContext.class)) {
                                        new AutoLayoutParser().parse(this.getContext(ModelViewDslContext.class), tokens);
                                    } else if ("default".equalsIgnoreCase(firstToken) && this.inContext(ViewDslContext.class)) {
                                        new DefaultViewParser().parse(this.getContext(ViewDslContext.class));
                                    } else if ("title".equalsIgnoreCase(firstToken) && this.inContext(ViewDslContext.class)) {
                                        new ViewParser().parseTitle(this.getContext(ViewDslContext.class), tokens);
                                    } else if ("description".equalsIgnoreCase(firstToken) && this.inContext(ViewDslContext.class)) {
                                        new ViewParser().parseDescription(this.getContext(ViewDslContext.class), tokens);
                                    } else if ("plantuml".equalsIgnoreCase(firstToken) && this.inContext(ImageViewDslContext.class)) {
                                        new ImageViewContentParser(this.restricted).parsePlantUML(this.getContext(ImageViewDslContext.class), dslFile, tokens);
                                    } else if ("mermaid".equalsIgnoreCase(firstToken) && this.inContext(ImageViewDslContext.class)) {
                                        new ImageViewContentParser(this.restricted).parseMermaid(this.getContext(ImageViewDslContext.class), dslFile, tokens);
                                    } else if ("kroki".equalsIgnoreCase(firstToken) && this.inContext(ImageViewDslContext.class)) {
                                        new ImageViewContentParser(this.restricted).parseKroki(this.getContext(ImageViewDslContext.class), dslFile, tokens);
                                    } else if ("image".equalsIgnoreCase(firstToken) && this.inContext(ImageViewDslContext.class)) {
                                        new ImageViewContentParser(this.restricted).parseImage(this.getContext(ImageViewDslContext.class), dslFile, tokens);
                                    } else if (this.inContext(DynamicViewDslContext.class)) {
                                        RelationshipView relationshipView = new DynamicViewContentParser().parseRelationship(this.getContext(DynamicViewDslContext.class), tokens);
                                        if (this.inContext(DynamicViewParallelSequenceDslContext.class)) {
                                            this.getContext(DynamicViewParallelSequenceDslContext.class).hasRelationships(true);
                                        }
                                        if (this.shouldStartContext(tokens)) {
                                            this.startContext(new DynamicViewRelationshipContext(relationshipView));
                                        }
                                    } else if ("url".equalsIgnoreCase(firstToken) && this.inContext(DynamicViewRelationshipContext.class)) {
                                        new DynamicViewRelationshipParser().parseUrl(this.getContext(DynamicViewRelationshipContext.class), tokens.withoutContextStartToken());
                                    } else if ("theme".equalsIgnoreCase(firstToken) && (this.inContext(ViewsDslContext.class) || this.inContext(StylesDslContext.class))) {
                                        new ThemeParser().parseTheme(this.getContext(), dslFile, tokens);
                                    } else if ("themes".equalsIgnoreCase(firstToken) && (this.inContext(ViewsDslContext.class) || this.inContext(StylesDslContext.class))) {
                                        new ThemeParser().parseThemes(this.getContext(), dslFile, tokens);
                                    } else if ("terminology".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                        this.startContext(new TerminologyDslContext());
                                    } else if ("person".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                        new TerminologyParser().parsePerson(this.getContext(), tokens);
                                    } else if ("softwareSystem".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                        new TerminologyParser().parseSoftwareSystem(this.getContext(), tokens);
                                    } else if ("container".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                        new TerminologyParser().parseContainer(this.getContext(), tokens);
                                    } else if ("component".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                        new TerminologyParser().parseComponent(this.getContext(), tokens);
                                    } else if ("deploymentNode".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                        new TerminologyParser().parseDeploymentNode(this.getContext(), tokens);
                                    } else if ("infrastructureNode".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                        new TerminologyParser().parseInfrastructureNode(this.getContext(), tokens);
                                    } else if ("relationship".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                        new TerminologyParser().parseRelationship(this.getContext(), tokens);
                                    } else if ("configuration".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                        this.startContext(new ConfigurationDslContext());
                                    } else if ("scope".equalsIgnoreCase(firstToken) && this.inContext(ConfigurationDslContext.class)) {
                                        new ConfigurationParser().parseScope(this.getContext(), tokens);
                                    } else if ("visibility".equalsIgnoreCase(firstToken) && this.inContext(ConfigurationDslContext.class)) {
                                        new ConfigurationParser().parseVisibility(this.getContext(), tokens);
                                    } else if ("users".equalsIgnoreCase(firstToken) && this.inContext(ConfigurationDslContext.class)) {
                                        this.startContext(new UsersDslContext());
                                    } else if (this.inContext(UsersDslContext.class)) {
                                        new UserRoleParser().parse(this.getContext(), tokens);
                                    } else if ("!docs".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                        if (!this.restricted) {
                                            new DocsParser().parse(this.getContext(WorkspaceDslContext.class), dslFile, tokens);
                                        } else {
                                            this.throwRestrictedModeException(firstToken);
                                        }
                                    } else if ("!docs".equalsIgnoreCase(firstToken) && this.inContext(SoftwareSystemDslContext.class)) {
                                        if (!this.restricted) {
                                            new DocsParser().parse(this.getContext(SoftwareSystemDslContext.class), dslFile, tokens);
                                        } else {
                                            this.throwRestrictedModeException(firstToken);
                                        }
                                    } else if ("!docs".equalsIgnoreCase(firstToken) && this.inContext(ContainerDslContext.class)) {
                                        if (!this.restricted) {
                                            new DocsParser().parse(this.getContext(ContainerDslContext.class), dslFile, tokens);
                                        } else {
                                            this.throwRestrictedModeException(firstToken);
                                        }
                                    } else if ("!docs".equalsIgnoreCase(firstToken) && this.inContext(ComponentDslContext.class)) {
                                        if (!this.restricted) {
                                            new DocsParser().parse(this.getContext(ComponentDslContext.class), dslFile, tokens);
                                        } else {
                                            this.throwRestrictedModeException(firstToken);
                                        }
                                    } else if (("!adrs".equalsIgnoreCase(firstToken) || "!decisions".equalsIgnoreCase(firstToken)) && this.inContext(WorkspaceDslContext.class)) {
                                        if (!this.restricted) {
                                            new DecisionsParser().parse(this.getContext(WorkspaceDslContext.class), dslFile, tokens);
                                        } else {
                                            this.throwRestrictedModeException(firstToken);
                                        }
                                    } else if (("!adrs".equalsIgnoreCase(firstToken) || "!decisions".equalsIgnoreCase(firstToken)) && this.inContext(SoftwareSystemDslContext.class)) {
                                        if (!this.restricted) {
                                            new DecisionsParser().parse(this.getContext(SoftwareSystemDslContext.class), dslFile, tokens);
                                        } else {
                                            this.throwRestrictedModeException(firstToken);
                                        }
                                    } else if (("!adrs".equalsIgnoreCase(firstToken) || "!decisions".equalsIgnoreCase(firstToken)) && this.inContext(ContainerDslContext.class)) {
                                        if (!this.restricted) {
                                            new DecisionsParser().parse(this.getContext(ContainerDslContext.class), dslFile, tokens);
                                        } else {
                                            this.throwRestrictedModeException(firstToken);
                                        }
                                    } else if (("!adrs".equalsIgnoreCase(firstToken) || "!decisions".equalsIgnoreCase(firstToken)) && this.inContext(ComponentDslContext.class)) {
                                        if (!this.restricted) {
                                            new DecisionsParser().parse(this.getContext(ComponentDslContext.class), dslFile, tokens);
                                        } else {
                                            this.throwRestrictedModeException(firstToken);
                                        }
                                    } else {
                                        if ("!constant".equalsIgnoreCase(firstToken)) {
                                            throw new RuntimeException("!constant was previously deprecated, and has now been removed - please use !const or !var instead");
                                        }
                                        if ("!const".equalsIgnoreCase(firstToken)) {
                                            nameValuePair = new NameValueParser().parseConstant(tokens);
                                            try {
                                                this.addConstant(nameValuePair);
                                            }
                                            catch (IllegalArgumentException e) {
                                                throw new StructurizrDslParserException(e.getMessage());
                                            }
                                        } else if ("!var".equalsIgnoreCase(firstToken)) {
                                            nameValuePair = new NameValueParser().parseVariable(tokens);
                                            if (this.constantsAndVariables.containsKey(nameValuePair.getName()) && this.constantsAndVariables.get(nameValuePair.getName()).getType() == NameValueType.Constant) {
                                                throw new StructurizrDslParserException("A constant \"" + nameValuePair.getName() + "\" already exists");
                                            }
                                            this.constantsAndVariables.put(nameValuePair.getName(), nameValuePair);
                                        } else if ("!identifiers".equalsIgnoreCase(firstToken) && (this.inContext(WorkspaceDslContext.class) || this.inContext(ModelDslContext.class))) {
                                            this.setIdentifierScope(new IdentifierScopeParser().parse(this.getContext(), tokens));
                                        } else {
                                            String[] expectedTokens = this.getContext() == null ? (this.getWorkspace() == null ? new String[]{"workspace"} : new String[]{}) : this.getContext().getPermittedTokens();
                                            if (expectedTokens.length > 0) {
                                                StringBuilder buf = new StringBuilder();
                                                for (String expectedToken : expectedTokens) {
                                                    buf.append(expectedToken);
                                                    buf.append(", ");
                                                }
                                                throw new StructurizrDslParserException("Unexpected tokens (expected: " + buf.substring(0, buf.length() - 2) + ")");
                                            }
                                            throw new StructurizrDslParserException("Unexpected tokens");
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (!includeInDslSourceLines || lineForDslSource == null) continue;
                this.dslSourceLines.add(lineForDslSource);
            }
            catch (Exception e) {
                if (e.getMessage() != null) {
                    throw new StructurizrDslParserException(e.getMessage(), dslFile, dslLine.getLineNumber(), line);
                }
                throw new StructurizrDslParserException(e.getClass().getSimpleName(), dslFile, dslLine.getLineNumber(), line);
            }
        }
        if (!fragment && !this.contextStack.empty()) {
            throw new StructurizrDslParserException("Unexpected end of DSL content - are one or more closing curly braces missing?");
        }
    }

    private List<DslLine> preProcessLines(List<String> lines) {
        ArrayList<DslLine> dslLines = new ArrayList<DslLine>();
        int lineNumber = 1;
        StringBuilder buf = new StringBuilder();
        boolean lineComplete = true;
        boolean textBlock = false;
        int textBlockLeadingSpace = -1;
        for (String line : lines) {
            if (textBlock) {
                if (line.endsWith(TEXT_BLOCK_MARKER)) {
                    buf.append("\"");
                    textBlock = false;
                    textBlockLeadingSpace = -1;
                    lineComplete = true;
                } else {
                    if (textBlockLeadingSpace == -1) {
                        textBlockLeadingSpace = 0;
                        for (int i = 0; i < line.length() && Character.isWhitespace(line.charAt(i)); ++i) {
                            ++textBlockLeadingSpace;
                        }
                    }
                    buf.append(line, textBlockLeadingSpace, line.length());
                    buf.append("\n");
                }
            } else if (!COMMENT_PATTERN.matcher(line).matches() && line.endsWith(MULTI_LINE_SEPARATOR)) {
                buf.append(line, 0, line.length() - 1);
                lineComplete = false;
            } else if (!COMMENT_PATTERN.matcher(line).matches() && line.endsWith(TEXT_BLOCK_MARKER)) {
                buf.append(line, 0, line.length() - 2);
                lineComplete = false;
                textBlock = true;
            } else if (lineComplete) {
                buf.append(line);
            } else {
                buf.append(line.stripLeading());
                lineComplete = true;
            }
            if (lineComplete) {
                dslLines.add(new DslLine(buf.toString(), lineNumber));
                buf = new StringBuilder();
            }
            ++lineNumber;
        }
        return dslLines;
    }

    private void throwRestrictedModeException(String firstToken) {
        throw new RuntimeException(firstToken + " is not available when the parser is running in restricted mode");
    }

    private String substituteStrings(String token) {
        Matcher m = STRING_SUBSTITUTION_PATTERN.matcher(token);
        while (m.find()) {
            String environmentVariable;
            String before = m.group(0);
            String after = null;
            String name = before.substring(2, before.length() - 1);
            if (this.constantsAndVariables.containsKey(name)) {
                after = this.constantsAndVariables.get(name).getValue();
            } else if (!this.restricted && (environmentVariable = System.getenv().get(name)) != null) {
                after = environmentVariable;
            }
            if (after == null) continue;
            token = token.replace(before, after);
        }
        return token;
    }

    private boolean shouldStartContext(Tokens tokens) {
        return "{".equalsIgnoreCase(tokens.get(tokens.size() - 1));
    }

    private void startContext(DslContext context) {
        context.setWorkspace(this.workspace);
        context.setIdentifierRegister(this.identifiersRegister);
        context.setExtendingWorkspace(this.extendingWorkspace);
        this.contextStack.push(context);
    }

    private DslContext getContext() {
        if (!this.contextStack.empty()) {
            return this.contextStack.peek();
        }
        return null;
    }

    private <T> T getContext(Class<T> clazz) throws StructurizrDslParserException {
        if (this.inContext(clazz)) {
            return (T)this.contextStack.peek();
        }
        throw new StructurizrDslParserException("Expected " + clazz.getName() + " but got " + this.contextStack.peek().getClass().getName());
    }

    private void endContext() throws StructurizrDslParserException {
        if (this.contextStack.empty()) {
            throw new StructurizrDslParserException("Unexpected end of context");
        }
        DslContext context = this.contextStack.pop();
        context.end();
    }

    private boolean isGroup(DslContext context) {
        if (context instanceof GroupableDslContext) {
            return ((GroupableDslContext)((Object)context)).hasGroup();
        }
        return false;
    }

    public Features getFeatures() {
        return this.features;
    }

    private boolean isElementKeywordOrArchetype(String token, String keyword) {
        if (token.equalsIgnoreCase(keyword)) {
            return true;
        }
        return this.archetypes.get(keyword).containsKey(token.toLowerCase());
    }

    private boolean isRelationshipKeywordOrArchetype(String token) {
        if (token.equalsIgnoreCase("->")) {
            return true;
        }
        if (token.startsWith("--") && token.endsWith("->")) {
            token = token.substring("--".length(), token.length() - "->".length());
            return this.archetypes.get("->").containsKey(token.toLowerCase());
        }
        return false;
    }

    private void addArchetype(Archetype archetype) {
        this.archetypes.get(archetype.getType()).put(archetype.getName(), archetype);
    }

    private Archetype getArchetype(String archetypeType, String archetypeName) {
        Archetype archetype = null;
        if ("->".equals(archetypeType) && archetypeName.startsWith("--") && archetypeName.endsWith("->")) {
            archetypeName = archetypeName.substring("--".length(), archetypeName.length() - "->".length());
        }
        if ((archetype = this.archetypes.get(archetypeType).get(archetypeName.toLowerCase())) == null) {
            archetype = new Archetype(archetypeName, archetypeType);
        }
        return archetype;
    }

    private void extendArchetype(Archetype archetype, String archetypeName) {
        archetypeName = archetypeName.toLowerCase();
        Archetype parentArchetype = this.getArchetype(archetype.getType(), archetypeName);
        archetype.setDescription(parentArchetype.getDescription());
        archetype.setTechnology(parentArchetype.getTechnology());
        archetype.addTags(parentArchetype.getTags().toArray(new String[0]));
    }

    public IdentifiersRegister getIdentifiersRegister() {
        return this.identifiersRegister;
    }

    void registerIdentifier(String identifier, Element element) {
        this.identifiersRegister.register(identifier, element);
        element.addProperty(STRUCTURIZR_DSL_IDENTIFIER_PROPERTY_NAME, this.identifiersRegister.findIdentifier(element));
    }

    void registerIdentifier(String identifier, Relationship relationship) {
        this.identifiersRegister.register(identifier, relationship);
        if (!StringUtils.isNullOrEmpty((String)identifier)) {
            relationship.addProperty(STRUCTURIZR_DSL_IDENTIFIER_PROPERTY_NAME, this.identifiersRegister.findIdentifier(relationship));
        }
    }

    public String getConstant(String name) {
        NameValuePair nameValuePair = this.constantsAndVariables.get(name);
        if (nameValuePair != null) {
            return nameValuePair.getValue();
        }
        return "";
    }

    public void addConstant(String name, String value) {
        if (StringUtils.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("A constant name must be specified");
        }
        this.addConstant(new NameValuePair(name, value));
    }

    private void addConstant(NameValuePair nameValuePair) {
        if (this.constantsAndVariables.containsKey(nameValuePair.getName())) {
            throw new IllegalArgumentException("A constant/variable \"" + nameValuePair.getName() + "\" already exists");
        }
        this.constantsAndVariables.put(nameValuePair.getName(), nameValuePair);
    }

    private boolean inContext(Class clazz) {
        if (this.contextStack.empty()) {
            return false;
        }
        return clazz.isAssignableFrom(this.contextStack.peek().getClass());
    }
}

