/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.Workspace;
import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.util.Url;
import com.structurizr.view.ThemeUtils;
import java.io.File;

final class ThemeParser
extends AbstractParser {
    private static final String DEFAULT_THEME_NAME = "default";
    private static final String DEFAULT_THEME_URL = "https://static.structurizr.com/themes/default/theme.json";
    private static final int FIRST_THEME_INDEX = 1;

    ThemeParser() {
    }

    void parseTheme(DslContext context, File dslFile, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: theme <url|file>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: theme <url|file>");
        }
        this.addTheme(context, dslFile, tokens.get(1));
    }

    void parseThemes(DslContext context, File dslFile, Tokens tokens) {
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: themes <url|file> [url|file] ... [url|file]");
        }
        for (int i = 1; i < tokens.size(); ++i) {
            this.addTheme(context, dslFile, tokens.get(i));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addTheme(DslContext context, File dslFile, String theme) {
        if (DEFAULT_THEME_NAME.equalsIgnoreCase(theme)) {
            theme = DEFAULT_THEME_URL;
        }
        if (Url.isUrl((String)theme)) {
            context.getWorkspace().getViews().getConfiguration().addTheme(theme);
            return;
        }
        File file = new File(dslFile.getParentFile(), theme);
        if (!file.exists()) throw new RuntimeException(file.getAbsolutePath() + " does not exist");
        if (!file.isFile()) throw new RuntimeException(file.getAbsolutePath() + " is not a file");
        try {
            ThemeUtils.inlineTheme((Workspace)context.getWorkspace(), (File)file);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading theme from " + file.getAbsolutePath() + ": " + e.getMessage());
        }
    }
}

