/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.PerspectivesHolder;
import com.structurizr.PropertyHolder;
import com.structurizr.model.Perspective;
import com.structurizr.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

final class Archetype
implements PropertyHolder,
PerspectivesHolder {
    private final String name;
    private final String type;
    private String metadata = "";
    private String description = "";
    private String technology = "";
    private final Set<String> tags = new LinkedHashSet<String>();
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Set<Perspective> perspectives = new TreeSet<Perspective>();

    Archetype(String name, String type) {
        if (StringUtils.isNullOrEmpty((String)name)) {
            name = type;
        }
        this.name = name.toLowerCase();
        this.type = type;
    }

    String getName() {
        return this.name;
    }

    String getType() {
        return this.type;
    }

    String getMetadata() {
        return this.metadata;
    }

    void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
    }

    String getTechnology() {
        return this.technology;
    }

    void setTechnology(String technology) {
        this.technology = technology;
    }

    void addTags(String ... tags) {
        if (tags == null) {
            return;
        }
        for (String tag : tags) {
            if (tag == null) continue;
            this.tags.add(tag.trim());
        }
    }

    Set<String> getTags() {
        return new LinkedHashSet<String>(this.tags);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void addProperty(String name, String value) {
        if (StringUtils.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("A property name must be specified.");
        }
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("A property value must be specified.");
        }
        this.properties.put(name, value);
    }

    public Set<Perspective> getPerspectives() {
        return new TreeSet<Perspective>(this.perspectives);
    }

    public Perspective addPerspective(String name, String description) {
        return this.addPerspective(name, description, "");
    }

    public Perspective addPerspective(String name, String description, String value) {
        if (StringUtils.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("A name must be specified.");
        }
        if (StringUtils.isNullOrEmpty((String)description)) {
            throw new IllegalArgumentException("A description must be specified.");
        }
        if (this.perspectives.stream().anyMatch(p -> p.getName().equals(name))) {
            throw new IllegalArgumentException("A perspective named \"" + name + "\" already exists.");
        }
        Perspective perspective = new Perspective(name, description, value);
        this.perspectives.add(perspective);
        return perspective;
    }
}

