/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.component.filter.ExcludeFullyQualifiedNameRegexFilter;
import com.structurizr.component.filter.IncludeFullyQualifiedNameRegexFilter;
import com.structurizr.component.filter.TypeFilter;
import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.ComponentFinderDslContext;
import com.structurizr.dsl.Tokens;

final class ComponentFinderParser
extends AbstractParser {
    private static final String CLASSES_GRAMMAR = "classes <path>";
    private static final String SOURCE_GRAMMAR = "source <path>";
    private static final String FILTER_INCLUDE = "include";
    private static final String FILTER_EXCLUDE = "exclude";
    private static final String FILTER_FQN_REGEX = "fqn-regex";
    private static final String FILTER_GRAMMAR = "filter <include|exclude> <fqn-regex> [parameters]";

    ComponentFinderParser() {
    }

    void parseClasses(ComponentFinderDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: classes <path>");
        }
        context.getComponentFinderBuilder().fromClasses(tokens.get(1));
    }

    void parseSource(ComponentFinderDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: source <path>");
        }
        context.getComponentFinderBuilder().fromSource(tokens.get(1));
    }

    void parseFilter(ComponentFinderDslContext context, Tokens tokens) {
        String type;
        if (tokens.size() < 3) {
            throw new RuntimeException("Too few tokens, expected: filter <include|exclude> <fqn-regex> [parameters]");
        }
        String includeOrExclude = tokens.get(1).toLowerCase();
        if (!FILTER_INCLUDE.equalsIgnoreCase(includeOrExclude) && !FILTER_EXCLUDE.equalsIgnoreCase(includeOrExclude)) {
            throw new RuntimeException("Filter mode should be \"include\" or \"exclude\": filter <include|exclude> <fqn-regex> [parameters]");
        }
        switch (type = tokens.get(2).toLowerCase()) {
            case "fqn-regex": {
                if (tokens.size() == 4) {
                    String regex = tokens.get(3);
                    if (FILTER_INCLUDE.equalsIgnoreCase(includeOrExclude)) {
                        context.getComponentFinderBuilder().filteredBy((TypeFilter)new IncludeFullyQualifiedNameRegexFilter(regex));
                        break;
                    }
                    context.getComponentFinderBuilder().filteredBy((TypeFilter)new ExcludeFullyQualifiedNameRegexFilter(regex));
                    break;
                }
                throw new RuntimeException("Expected: filter <include|exclude> <fqn-regex> [parameters]");
            }
            default: {
                throw new IllegalArgumentException("Unknown filter: " + type);
            }
        }
    }
}

