/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.Archetype;
import com.structurizr.dsl.DeploymentEnvironmentDslContext;
import com.structurizr.dsl.DeploymentNodeDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import java.util.ArrayList;
import java.util.Arrays;

final class DeploymentNodeParser
extends AbstractParser {
    private static final String GRAMMAR = "deploymentNode <name> [description] [technology] [tags] [instances] {";
    private static final int NAME_INDEX = 1;
    private static final int DESCRIPTION_INDEX = 2;
    private static final int TECHNOLOGY_INDEX = 3;
    private static final int TAGS_INDEX = 4;
    private static final int INSTANCES_INDEX = 5;

    DeploymentNodeParser() {
    }

    DeploymentNode parse(DeploymentEnvironmentDslContext context, Tokens tokens, Archetype archetype) {
        return this.parse(context, null, tokens, archetype);
    }

    DeploymentNode parse(DeploymentNodeDslContext context, Tokens tokens, Archetype archetype) {
        return this.parse(null, context, tokens, archetype);
    }

    DeploymentNode parse(DeploymentEnvironmentDslContext deploymentEnvironmentDslContext, DeploymentNodeDslContext deploymentNodeDslContext, Tokens tokens, Archetype archetype) {
        if (tokens.hasMoreThan(5)) {
            throw new RuntimeException("Too many tokens, expected: deploymentNode <name> [description] [technology] [tags] [instances] {");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: deploymentNode <name> [description] [technology] [tags] [instances] {");
        }
        DeploymentNode deploymentNode = null;
        String name = tokens.get(1);
        String description = archetype.getDescription();
        if (tokens.includes(2)) {
            description = tokens.get(2);
        }
        String technology = archetype.getTechnology();
        if (tokens.includes(3)) {
            technology = tokens.get(3);
        }
        if (deploymentEnvironmentDslContext != null) {
            deploymentNode = deploymentEnvironmentDslContext.getWorkspace().getModel().addDeploymentNode(deploymentEnvironmentDslContext.getEnvironment().getName(), name, description, technology);
            if (deploymentEnvironmentDslContext.hasGroup()) {
                deploymentNode.setGroup(deploymentEnvironmentDslContext.getGroup().getName());
                deploymentEnvironmentDslContext.getGroup().addElement((Element)deploymentNode);
            }
        } else {
            deploymentNode = deploymentNodeDslContext.getDeploymentNode().addDeploymentNode(name, description, technology);
            if (deploymentNodeDslContext.hasGroup()) {
                deploymentNode.setGroup(deploymentNodeDslContext.getGroup().getName());
                deploymentNodeDslContext.getGroup().addElement((Element)deploymentNode);
            }
        }
        ArrayList<String> tags = new ArrayList<String>(archetype.getTags());
        if (tokens.includes(4)) {
            tags.addAll(Arrays.asList(tokens.get(4).split(",")));
        }
        deploymentNode.addTags(tags.toArray(new String[0]));
        deploymentNode.addProperties(archetype.getProperties());
        deploymentNode.addPerspectives(archetype.getPerspectives());
        String instances = "1";
        if (tokens.includes(5)) {
            instances = tokens.get(5);
            deploymentNode.setInstances(instances);
        }
        return deploymentNode;
    }

    void parseTechnology(DeploymentNodeDslContext context, Tokens tokens) {
        int index = 1;
        if (tokens.hasMoreThan(index)) {
            throw new RuntimeException("Too many tokens, expected: technology <technology>");
        }
        if (!tokens.includes(index)) {
            throw new RuntimeException("Expected: technology <technology>");
        }
        String technology = tokens.get(index);
        context.getDeploymentNode().setTechnology(technology);
    }

    void parseInstances(DeploymentNodeDslContext context, Tokens tokens) {
        int index = 1;
        if (tokens.hasMoreThan(index)) {
            throw new RuntimeException("Too many tokens, expected: instances <number|range>");
        }
        if (!tokens.includes(index)) {
            throw new RuntimeException("Expected: instances <number|range>");
        }
        String instances = tokens.get(index);
        context.getDeploymentNode().setInstances(instances);
    }
}

