/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractRelationshipParser;
import com.structurizr.dsl.Archetype;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.ElementDslContext;
import com.structurizr.dsl.ElementsDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

final class ExplicitRelationshipParser
extends AbstractRelationshipParser {
    private static final String GRAMMAR = "<identifier> -> <identifier> [description] [technology] [tags]";
    private static final int SOURCE_IDENTIFIER_INDEX = 0;
    private static final int DESTINATION_IDENTIFIER_INDEX = 2;
    private static final int DESCRIPTION_INDEX = 3;
    private static final int TECHNOLOGY_INDEX = 4;
    private static final int TAGS_INDEX = 5;

    ExplicitRelationshipParser() {
    }

    Relationship parse(DslContext context, Tokens tokens, Archetype archetype) {
        if (tokens.hasMoreThan(5)) {
            throw new RuntimeException("Too many tokens, expected: <identifier> -> <identifier> [description] [technology] [tags]");
        }
        if (!tokens.includes(2)) {
            throw new RuntimeException("Expected: <identifier> -> <identifier> [description] [technology] [tags]");
        }
        String sourceId = tokens.get(0);
        Element sourceElement = this.findElement(sourceId, context);
        if (sourceElement == null) {
            throw new RuntimeException("The source element \"" + sourceId + "\" does not exist");
        }
        String destinationId = tokens.get(2);
        Element destinationElement = this.findElement(destinationId, context);
        if (destinationElement == null) {
            throw new RuntimeException("The destination element \"" + destinationId + "\" does not exist");
        }
        String description = archetype.getDescription();
        if (tokens.includes(3)) {
            description = tokens.get(3);
        }
        String technology = archetype.getTechnology();
        if (tokens.includes(4)) {
            technology = tokens.get(4);
        }
        ArrayList<String> tags = new ArrayList<String>(archetype.getTags());
        if (tokens.includes(5)) {
            tags.addAll(Arrays.asList(tokens.get(5).split(",")));
        }
        Relationship relationship = this.createRelationship(sourceElement, description, technology, tags.toArray(new String[0]), destinationElement);
        relationship.addProperties(archetype.getProperties());
        relationship.addPerspectives(archetype.getPerspectives());
        return relationship;
    }

    Set<Relationship> parse(ElementsDslContext context, Tokens tokens, Archetype archetype) {
        if (tokens.hasMoreThan(5)) {
            throw new RuntimeException("Too many tokens, expected: <identifier> -> <identifier> [description] [technology] [tags]");
        }
        if (!tokens.includes(2)) {
            throw new RuntimeException("Expected: <identifier> -> <identifier> [description] [technology] [tags]");
        }
        String sourceId = tokens.get(0);
        Set<Element> sourceElements = this.findElements(sourceId, context);
        if (sourceElements.isEmpty()) {
            throw new RuntimeException("The source element \"" + sourceId + "\" does not exist");
        }
        String destinationId = tokens.get(2);
        Set<Element> destinationElements = this.findElements(destinationId, context);
        if (destinationElements.isEmpty()) {
            throw new RuntimeException("The destination element \"" + destinationId + "\" does not exist");
        }
        String description = archetype.getDescription();
        if (tokens.includes(3)) {
            description = tokens.get(3);
        }
        String technology = archetype.getTechnology();
        if (tokens.includes(4)) {
            technology = tokens.get(4);
        }
        String[] tags = archetype.getTags().toArray(new String[0]);
        if (tokens.includes(5)) {
            tags = tokens.get(5).split(",");
        }
        LinkedHashSet<Relationship> relationships = new LinkedHashSet<Relationship>();
        for (Element sourceElement : sourceElements) {
            for (Element destinationElement : destinationElements) {
                Relationship relationship = this.createRelationship(sourceElement, description, technology, tags, destinationElement);
                relationship.addProperties(archetype.getProperties());
                relationship.addPerspectives(archetype.getPerspectives());
                relationships.add(relationship);
            }
        }
        return relationships;
    }

    private Element findElement(String identifier, DslContext context) {
        Element element = context.getElement(identifier);
        if (element == null && "this".equalsIgnoreCase(identifier) && context instanceof ElementDslContext) {
            element = ((ElementDslContext)context).getElement();
        }
        return element;
    }

    private Set<Element> findElements(String identifier, ElementsDslContext context) {
        Element element = context.getElement(identifier);
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
        if (element == null) {
            if ("this".equalsIgnoreCase(identifier)) {
                elements.addAll(context.getElements());
            }
        } else {
            elements.add(element);
        }
        return elements;
    }
}

