/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.ExpressionParser;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Element;
import com.structurizr.model.ModelItem;
import java.util.Set;
import java.util.stream.Collectors;

final class FindElementsParser
extends AbstractParser {
    private static final String GRAMMAR = "!elements <expression>";
    private static final int EXPRESSION_INDEX = 1;

    FindElementsParser() {
    }

    Set<Element> parse(DslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: !elements <expression>");
        }
        String expression = tokens.get(1);
        Set<ModelItem> modelItems = new ExpressionParser().parseExpression(expression, context);
        Set<Element> elements = modelItems.stream().filter(mi -> mi instanceof Element).map(mi -> (Element)mi).collect(Collectors.toSet());
        if (elements.isEmpty()) {
            throw new RuntimeException("No elements found for expression \"" + expression + "\"");
        }
        return elements;
    }
}

