/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.StructurizrDslParser;
import com.structurizr.dsl.StructurizrDslPlugin;
import com.structurizr.dsl.StructurizrDslPluginContext;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

class PluginDslContext
extends DslContext {
    private final String fullyQualifiedClassName;
    private final File dslFile;
    private final StructurizrDslParser dslParser;
    private final Map<String, String> parameters = new HashMap<String, String>();

    PluginDslContext(String fullyQualifiedClassName, File dslFile, StructurizrDslParser dslParser) {
        this.fullyQualifiedClassName = fullyQualifiedClassName;
        this.dslFile = dslFile;
        this.dslParser = dslParser;
    }

    void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    @Override
    void end() {
        try {
            Class pluginClass = this.loadClass(this.fullyQualifiedClassName, this.dslFile);
            StructurizrDslPlugin plugin = (StructurizrDslPlugin)pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            StructurizrDslPluginContext pluginContext = new StructurizrDslPluginContext(this.dslParser, this.dslFile, this.getWorkspace(), this.parameters);
            plugin.run(pluginContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error running plugin " + this.fullyQualifiedClassName + ", caused by " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    @Override
    protected String[] getPermittedTokens() {
        return new String[0];
    }
}

