/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.component.description.DescriptionStrategy;
import com.structurizr.component.description.FirstSentenceDescriptionStrategy;
import com.structurizr.component.description.TruncatedDescriptionStrategy;
import com.structurizr.component.filter.ExcludeFullyQualifiedNameRegexFilter;
import com.structurizr.component.filter.IncludeFullyQualifiedNameRegexFilter;
import com.structurizr.component.filter.TypeFilter;
import com.structurizr.component.matcher.AnnotationTypeMatcher;
import com.structurizr.component.matcher.ExtendsTypeMatcher;
import com.structurizr.component.matcher.ImplementsTypeMatcher;
import com.structurizr.component.matcher.NameSuffixTypeMatcher;
import com.structurizr.component.matcher.RegexTypeMatcher;
import com.structurizr.component.matcher.TypeMatcher;
import com.structurizr.component.naming.DefaultPackageNamingStrategy;
import com.structurizr.component.naming.FullyQualifiedNamingStrategy;
import com.structurizr.component.naming.NamingStrategy;
import com.structurizr.component.naming.TypeNamingStrategy;
import com.structurizr.component.supporting.AllReferencedTypesInPackageSupportingTypesStrategy;
import com.structurizr.component.supporting.AllReferencedTypesSupportingTypesStrategy;
import com.structurizr.component.supporting.AllTypesInPackageSupportingTypesStrategy;
import com.structurizr.component.supporting.AllTypesUnderPackageSupportingTypesStrategy;
import com.structurizr.component.supporting.DefaultSupportingTypesStrategy;
import com.structurizr.component.supporting.ImplementationWithPrefixSupportingTypesStrategy;
import com.structurizr.component.supporting.ImplementationWithSuffixSupportingTypesStrategy;
import com.structurizr.component.supporting.SupportingTypesStrategy;
import com.structurizr.component.url.PrefixSourceUrlStrategy;
import com.structurizr.component.url.UrlStrategy;
import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.ComponentFinderStrategyDslContext;
import com.structurizr.dsl.Tokens;
import java.io.File;
import java.util.List;

final class ComponentFinderStrategyParser
extends AbstractParser {
    private static final String TECHNOLOGY_GRAMMAR = "technology <name>";
    private static final String MATCHER_ANNOTATION = "annotation";
    private static final String MATCHER_EXTENDS = "extends";
    private static final String MATCHER_IMPLEMENTS = "implements";
    private static final String MATCHER_NAME_SUFFIX = "name-suffix";
    private static final String MATCHER_FQN_REGEX = "fqn-regex";
    private static final String MATCHER_GRAMMAR = "matcher <" + String.join((CharSequence)"|", List.of("annotation", "extends", "implements", "name-suffix", "fqn-regex")) + "> [parameters]";
    private static final String MATCHER_ANNOTATION_GRAMMAR = "matcher annotation <fqn>";
    private static final String MATCHER_EXTENDS_GRAMMAR = "matcher extends <fqn>";
    private static final String MATCHER_IMPLEMENTS_GRAMMAR = "matcher implements <fqn>";
    private static final String MATCHER_NAMESUFFIX_GRAMMAR = "matcher name-suffix <name>";
    private static final String MATCHER_REGEX_GRAMMAR = "matcher fqn-regex <regex>";
    private static final String FILTER_INCLUDE = "include";
    private static final String FILTER_EXCLUDE = "exclude";
    private static final String FILTER_FQN_REGEX = "fqn-regex";
    private static final String FILTER_GRAMMAR = "filter <include|exclude> <fqn-regex> [parameters]";
    private static final String SUPPORTING_TYPES_ALL_REFERENCED = "all-referenced";
    private static final String SUPPORTING_TYPES_REFERENCED_IN_PACKAGE = "referenced-in-package";
    private static final String SUPPORTING_TYPES_IN_PACKAGE = "in-package";
    private static final String SUPPORTING_TYPES_UNDER_PACKAGE = "under-package";
    private static final String SUPPORTING_TYPES_IMPLEMENTATION_WITH_PREFIX = "implementation-prefix";
    private static final String SUPPORTING_TYPES_IMPLEMENTATION_WITH_SUFFIX = "implementation-suffix";
    private static final String SUPPORTING_TYPES_NONE = "none";
    private static final String SUPPORTING_TYPES_GRAMMAR = "supportingTypes <" + String.join((CharSequence)"|", List.of("all-referenced", "referenced-in-package", "in-package", "under-package", "implementation-prefix", "implementation-suffix", "none")) + "> [parameters]";
    private static final String SUPPORTING_TYPES_IMPLEMENTATION_WITH_PREFIX_GRAMMAR = "supportingTypes implementation-prefix <prefix>";
    private static final String SUPPORTING_TYPES_IMPLEMENTATION_WITH_SUFFIX_GRAMMAR = "supportingTypes implementation-suffix <suffix>";
    private static final String NAME_TYPE_NAME = "type-name";
    private static final String NAME_FQN = "fqn";
    private static final String NAME_PACKAGE = "package";
    private static final String NAME_GRAMMAR = "name <" + String.join((CharSequence)"|", List.of("type-name", "fqn", "package")) + ">";
    private static final String DESCRIPTION_TRUNCATED = "truncated";
    private static final String DESCRIPTION_FIRST_SENTENCE = "first-sentence";
    private static final String DESCRIPTION_GRAMMAR = "description <" + String.join((CharSequence)"|", List.of("first-sentence", "truncated")) + ">";
    private static final String DESCRIPTION_TRUNCATED_GRAMMAR = "description truncated <maxLength>";
    private static final String URL_PREFIX_SRC = "prefix-src";
    private static final String URL_GRAMMAR = "url <" + String.join((CharSequence)"|", List.of("prefix-src")) + ">";
    private static final String URL_PREFIX_SRC_GRAMMAR = "url prefix-src <prefix>";

    ComponentFinderStrategyParser() {
    }

    void parseTechnology(ComponentFinderStrategyDslContext context, Tokens tokens) {
        if (tokens.size() != 2) {
            throw new RuntimeException("Expected: technology <name>");
        }
        String name = tokens.get(1);
        context.getComponentFinderStrategyBuilder().withTechnology(name);
    }

    void parseMatcher(ComponentFinderStrategyDslContext context, Tokens tokens, File dslFile) {
        if (tokens.size() < 2) {
            throw new RuntimeException("Too few tokens, expected: " + MATCHER_GRAMMAR);
        }
        String type = tokens.get(1);
        switch (type.toLowerCase()) {
            case "annotation": {
                if (tokens.size() == 3) {
                    String name = tokens.get(2);
                    context.getComponentFinderStrategyBuilder().matchedBy((TypeMatcher)new AnnotationTypeMatcher(name));
                    break;
                }
                throw new RuntimeException("Expected: matcher annotation <fqn>");
            }
            case "extends": {
                if (tokens.size() == 3) {
                    String name = tokens.get(2);
                    context.getComponentFinderStrategyBuilder().matchedBy((TypeMatcher)new ExtendsTypeMatcher(name));
                    break;
                }
                throw new RuntimeException("Expected: matcher extends <fqn>");
            }
            case "implements": {
                if (tokens.size() == 3) {
                    String name = tokens.get(2);
                    context.getComponentFinderStrategyBuilder().matchedBy((TypeMatcher)new ImplementsTypeMatcher(name));
                    break;
                }
                throw new RuntimeException("Expected: matcher implements <fqn>");
            }
            case "name-suffix": {
                if (tokens.size() == 3) {
                    String suffix = tokens.get(2);
                    context.getComponentFinderStrategyBuilder().matchedBy((TypeMatcher)new NameSuffixTypeMatcher(suffix));
                    break;
                }
                throw new RuntimeException("Expected: matcher name-suffix <name>");
            }
            case "fqn-regex": {
                if (tokens.size() == 3) {
                    String regex = tokens.get(2);
                    context.getComponentFinderStrategyBuilder().matchedBy((TypeMatcher)new RegexTypeMatcher(regex));
                    break;
                }
                throw new RuntimeException("Expected: matcher fqn-regex <regex>");
            }
            default: {
                try {
                    TypeMatcher typeMatcher;
                    Class typeMatcherClass = context.loadClass(type, dslFile);
                    if (tokens.size() == 3) {
                        String parameter = tokens.get(2);
                        typeMatcher = (TypeMatcher)typeMatcherClass.getDeclaredConstructor(String.class).newInstance(parameter);
                    } else {
                        typeMatcher = (TypeMatcher)typeMatcherClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    context.getComponentFinderStrategyBuilder().matchedBy(typeMatcher);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Type matcher \"" + type + "\" could not be loaded - " + e.getClass() + ": " + e.getMessage());
                }
            }
        }
    }

    void parseFilter(ComponentFinderStrategyDslContext context, Tokens tokens, File dslFile) {
        String type;
        if (tokens.size() < 3) {
            throw new RuntimeException("Too few tokens, expected: filter <include|exclude> <fqn-regex> [parameters]");
        }
        String includeOrExclude = tokens.get(1).toLowerCase();
        if (!FILTER_INCLUDE.equalsIgnoreCase(includeOrExclude) && !FILTER_EXCLUDE.equalsIgnoreCase(includeOrExclude)) {
            throw new RuntimeException("Filter mode should be \"include\" or \"exclude\": filter <include|exclude> <fqn-regex> [parameters]");
        }
        switch (type = tokens.get(2).toLowerCase()) {
            case "fqn-regex": {
                if (tokens.size() == 4) {
                    String regex = tokens.get(3);
                    if (FILTER_INCLUDE.equalsIgnoreCase(includeOrExclude)) {
                        context.getComponentFinderStrategyBuilder().filteredBy((TypeFilter)new IncludeFullyQualifiedNameRegexFilter(regex));
                        break;
                    }
                    context.getComponentFinderStrategyBuilder().filteredBy((TypeFilter)new ExcludeFullyQualifiedNameRegexFilter(regex));
                    break;
                }
                throw new RuntimeException("Expected: filter <include|exclude> <fqn-regex> [parameters]");
            }
            default: {
                throw new IllegalArgumentException("Unknown filter: " + type);
            }
        }
    }

    void parseSupportingTypes(ComponentFinderStrategyDslContext context, Tokens tokens, File dslFile) {
        String type;
        if (tokens.size() < 2) {
            throw new RuntimeException("Too few tokens, expected: " + SUPPORTING_TYPES_GRAMMAR);
        }
        switch (type = tokens.get(1).toLowerCase()) {
            case "all-referenced": {
                context.getComponentFinderStrategyBuilder().supportedBy((SupportingTypesStrategy)new AllReferencedTypesSupportingTypesStrategy());
                break;
            }
            case "referenced-in-package": {
                context.getComponentFinderStrategyBuilder().supportedBy((SupportingTypesStrategy)new AllReferencedTypesInPackageSupportingTypesStrategy());
                break;
            }
            case "in-package": {
                context.getComponentFinderStrategyBuilder().supportedBy((SupportingTypesStrategy)new AllTypesInPackageSupportingTypesStrategy());
                break;
            }
            case "under-package": {
                context.getComponentFinderStrategyBuilder().supportedBy((SupportingTypesStrategy)new AllTypesUnderPackageSupportingTypesStrategy());
                break;
            }
            case "implementation-prefix": {
                if (tokens.size() < 3) {
                    throw new RuntimeException("Too few tokens, expected: supportingTypes implementation-prefix <prefix>");
                }
                String prefix = tokens.get(2);
                context.getComponentFinderStrategyBuilder().supportedBy((SupportingTypesStrategy)new ImplementationWithPrefixSupportingTypesStrategy(prefix));
                break;
            }
            case "implementation-suffix": {
                if (tokens.size() < 3) {
                    throw new RuntimeException("Too few tokens, expected: supportingTypes implementation-suffix <suffix>");
                }
                String suffix = tokens.get(2);
                context.getComponentFinderStrategyBuilder().supportedBy((SupportingTypesStrategy)new ImplementationWithSuffixSupportingTypesStrategy(suffix));
                break;
            }
            case "none": {
                context.getComponentFinderStrategyBuilder().supportedBy((SupportingTypesStrategy)new DefaultSupportingTypesStrategy());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown supporting types strategy: " + type);
            }
        }
    }

    void parseName(ComponentFinderStrategyDslContext context, Tokens tokens, File dslFile) {
        String type;
        if (tokens.size() < 2) {
            throw new RuntimeException("Too few tokens, expected: " + NAME_GRAMMAR);
        }
        switch (type = tokens.get(1).toLowerCase()) {
            case "type-name": {
                context.getComponentFinderStrategyBuilder().withName((NamingStrategy)new TypeNamingStrategy());
                break;
            }
            case "fqn": {
                context.getComponentFinderStrategyBuilder().withName((NamingStrategy)new FullyQualifiedNamingStrategy());
                break;
            }
            case "package": {
                context.getComponentFinderStrategyBuilder().withName((NamingStrategy)new DefaultPackageNamingStrategy());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown name strategy: " + type);
            }
        }
    }

    void parseDescription(ComponentFinderStrategyDslContext context, Tokens tokens, File dslFile) {
        String type;
        if (tokens.size() < 2) {
            throw new RuntimeException("Too few tokens, expected: " + DESCRIPTION_GRAMMAR);
        }
        switch (type = tokens.get(1).toLowerCase()) {
            case "first-sentence": {
                context.getComponentFinderStrategyBuilder().withDescription((DescriptionStrategy)new FirstSentenceDescriptionStrategy());
                break;
            }
            case "truncated": {
                if (tokens.size() < 3) {
                    throw new RuntimeException("Too few tokens, expected: description truncated <maxLength>");
                }
                try {
                    int maxLength = Integer.parseInt(tokens.get(2));
                    context.getComponentFinderStrategyBuilder().withDescription((DescriptionStrategy)new TruncatedDescriptionStrategy(maxLength));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Max length must be an integer");
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown description strategy: " + type);
            }
        }
    }

    void parseUrl(ComponentFinderStrategyDslContext context, Tokens tokens, File dslFile) {
        String type;
        if (tokens.size() < 2) {
            throw new RuntimeException("Too few tokens, expected: " + URL_GRAMMAR);
        }
        switch (type = tokens.get(1).toLowerCase()) {
            case "prefix-src": {
                if (tokens.size() < 3) {
                    throw new RuntimeException("Too few tokens, expected: url prefix-src <prefix>");
                }
                String prefix = tokens.get(2);
                context.getComponentFinderStrategyBuilder().withUrl((UrlStrategy)new PrefixSourceUrlStrategy(prefix));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URL strategy: " + type);
            }
        }
    }
}

