/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.DeploymentNodeDslContext;
import com.structurizr.dsl.StaticStructureInstanceParser;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import java.util.HashSet;
import java.util.Set;

final class ContainerInstanceParser
extends StaticStructureInstanceParser {
    private static final String GRAMMAR = "containerInstance <identifier> [deploymentGroups] [tags]";
    private static final int IDENTIFIER_INDEX = 1;
    private static final int DEPLOYMENT_GROUPS_TOKEN = 2;
    private static final int TAGS_INDEX = 3;

    ContainerInstanceParser() {
    }

    ContainerInstance parse(DeploymentNodeDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(3)) {
            throw new RuntimeException("Too many tokens, expected: containerInstance <identifier> [deploymentGroups] [tags]");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: containerInstance <identifier> [deploymentGroups] [tags]");
        }
        String containerIdentifier = tokens.get(1);
        Element element = context.getElement(containerIdentifier, Container.class);
        if (element == null) {
            throw new RuntimeException("The container \"" + containerIdentifier + "\" does not exist");
        }
        DeploymentNode deploymentNode = context.getDeploymentNode();
        Set<Object> deploymentGroups = new HashSet();
        if (tokens.includes(2)) {
            deploymentGroups = this.getDeploymentGroups(context, tokens.get(2));
        }
        ContainerInstance containerInstance = deploymentNode.add((Container)element, deploymentGroups.toArray(new String[0]));
        if (tokens.includes(3)) {
            String tags = tokens.get(3);
            containerInstance.addTags(tags.split(","));
        }
        if (context.hasGroup()) {
            containerInstance.setGroup(context.getGroup().getName());
            context.getGroup().addElement((Element)containerInstance);
        }
        return containerInstance;
    }
}

