/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DeploymentViewAnimationDslContext;
import com.structurizr.dsl.DeploymentViewDslContext;
import com.structurizr.dsl.DeploymentViewExpressionParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.ExpressionParser;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.ModelItem;
import com.structurizr.model.StaticStructureElementInstance;
import com.structurizr.view.DeploymentView;
import java.util.ArrayList;
import java.util.Set;

final class DeploymentViewAnimationStepParser
extends AbstractParser {
    private static final String GRAMMAR = "<identifier|element expression> [identifier|element expression...]";

    DeploymentViewAnimationStepParser() {
    }

    void parse(DeploymentViewDslContext context, Tokens tokens) {
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: animationStep <identifier|element expression> [identifier|element expression...]");
        }
        this.parse(context, context.getView(), tokens, 1);
    }

    void parse(DeploymentViewAnimationDslContext context, Tokens tokens) {
        if (!tokens.includes(0)) {
            throw new RuntimeException("Expected: <identifier|element expression> [identifier|element expression...]");
        }
        this.parse(context, context.getView(), tokens, 0);
    }

    private void parse(DslContext context, DeploymentView view, Tokens tokens, int startIndex) {
        ArrayList<StaticStructureElementInstance> staticStructureElementInstances = new ArrayList<StaticStructureElementInstance>();
        ArrayList<InfrastructureNode> infrastructureNodes = new ArrayList<InfrastructureNode>();
        for (int i = startIndex; i < tokens.size(); ++i) {
            Set<ModelItem> elements;
            String token = tokens.get(i);
            if (ExpressionParser.isExpression(token.toLowerCase())) {
                elements = new DeploymentViewExpressionParser().parseExpression(token, context);
                for (ModelItem element : elements) {
                    if (element instanceof StaticStructureElementInstance) {
                        staticStructureElementInstances.add((StaticStructureElementInstance)element);
                    }
                    if (!(element instanceof InfrastructureNode)) continue;
                    infrastructureNodes.add((InfrastructureNode)element);
                }
                continue;
            }
            elements = new DeploymentViewExpressionParser().parseIdentifier(token, context);
            if (elements.isEmpty()) {
                throw new RuntimeException("The element \"" + token + "\" does not exist");
            }
            for (ModelItem element : elements) {
                if (element instanceof StaticStructureElementInstance) {
                    staticStructureElementInstances.add((StaticStructureElementInstance)element);
                }
                if (!(element instanceof InfrastructureNode)) continue;
                infrastructureNodes.add((InfrastructureNode)element);
            }
        }
        if (staticStructureElementInstances.isEmpty() && infrastructureNodes.isEmpty()) {
            throw new RuntimeException("No software system instances, container instances, or infrastructure nodes were found");
        }
        view.addAnimation(staticStructureElementInstances.toArray(new StaticStructureElementInstance[0]), infrastructureNodes.toArray(new InfrastructureNode[0]));
    }
}

