/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.Workspace;
import com.structurizr.util.StringUtils;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class DslUtils {
    static final String STRUCTURIZR_DSL_PROPERTY_NAME = "structurizr.dsl";
    static final String STRUCTURIZR_DSL_RETAIN_SOURCE_PROPERTY_NAME = "structurizr.dsl.source";

    public static String getDsl(Workspace workspace) {
        String base64 = (String)workspace.getProperties().get(STRUCTURIZR_DSL_PROPERTY_NAME);
        if (!StringUtils.isNullOrEmpty((String)base64)) {
            return new String(Base64.getDecoder().decode(base64));
        }
        return "";
    }

    public static void setDsl(Workspace workspace, String dsl) {
        if (!StringUtils.isNullOrEmpty((String)dsl)) {
            String base64 = Base64.getEncoder().encodeToString(dsl.getBytes(StandardCharsets.UTF_8));
            workspace.addProperty(STRUCTURIZR_DSL_PROPERTY_NAME, base64);
        }
    }

    public static void clearDsl(Workspace workspace) {
        workspace.removeProperty(STRUCTURIZR_DSL_PROPERTY_NAME);
    }
}

