/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.ElementsDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;

final class ElementsParser
extends AbstractParser {
    private static final int DESCRIPTION_INDEX = 1;
    private static final int TECHNOLOGY_INDEX = 1;

    ElementsParser() {
    }

    void parseDescription(ElementsDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: description <description>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: description <description>");
        }
        String description = tokens.get(1);
        for (Element element : context.getElements()) {
            element.setDescription(description);
        }
    }

    void parseTechnology(ElementsDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: technology <technology>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: technology <technology>");
        }
        String technology = tokens.get(1);
        for (Element element : context.getElements()) {
            if (element instanceof Container) {
                ((Container)element).setTechnology(technology);
                continue;
            }
            if (element instanceof Component) {
                ((Component)element).setTechnology(technology);
                continue;
            }
            if (element instanceof DeploymentNode) {
                ((DeploymentNode)element).setTechnology(technology);
                continue;
            }
            if (!(element instanceof InfrastructureNode)) continue;
            ((InfrastructureNode)element).setTechnology(technology);
        }
    }
}

