/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.DeploymentEnvironment;
import com.structurizr.dsl.IdentifierScope;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import com.structurizr.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;

public class IdentifiersRegister {
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("\\w[a-zA-Z0-9_-]*");
    private IdentifierScope identifierScope = IdentifierScope.Flat;
    private final Map<String, Element> elementsByIdentifier = new HashMap<String, Element>();
    private final Map<String, Relationship> relationshipsByIdentifier = new HashMap<String, Relationship>();

    IdentifiersRegister() {
    }

    public IdentifierScope getIdentifierScope() {
        return this.identifierScope;
    }

    public void setIdentifierScope(IdentifierScope identifierScope) {
        this.identifierScope = identifierScope;
    }

    public Set<String> getElementIdentifiers() {
        return this.elementsByIdentifier.keySet();
    }

    public Set<String> getRelationshipIdentifiers() {
        return this.relationshipsByIdentifier.keySet();
    }

    public Element getElement(String identifier) {
        for (String key : this.elementsByIdentifier.keySet()) {
            if (!key.equalsIgnoreCase(identifier)) continue;
            return this.elementsByIdentifier.get(key);
        }
        return null;
    }

    public void register(String identifier, Element element) {
        if (element == null) {
            throw new IllegalArgumentException("An element must be specified");
        }
        if (StringUtils.isNullOrEmpty((String)identifier)) {
            identifier = UUID.randomUUID().toString();
        }
        if (this.identifierScope == IdentifierScope.Hierarchical) {
            identifier = this.calculateHierarchicalIdentifier(identifier, element);
        }
        for (String id : this.elementsByIdentifier.keySet()) {
            Element e = this.elementsByIdentifier.get(id);
            if (!e.equals(element) || id.equalsIgnoreCase(identifier)) continue;
            if (id.matches("[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}")) {
                throw new RuntimeException("Please assign an identifier to \"" + element.getCanonicalName() + "\" before using it");
            }
            throw new RuntimeException("The element is already registered with an identifier of \"" + id + "\"");
        }
        Element e = this.getElement(identifier);
        Relationship r = this.getRelationship(identifier);
        if ((e != null || r != null) && e != element) {
            throw new RuntimeException("The identifier \"" + identifier + "\" is already in use");
        }
        this.elementsByIdentifier.put(identifier, element);
    }

    public Relationship getRelationship(String identifier) {
        for (String key : this.relationshipsByIdentifier.keySet()) {
            if (!key.equalsIgnoreCase(identifier)) continue;
            return this.relationshipsByIdentifier.get(key);
        }
        return null;
    }

    public void register(String identifier, Relationship relationship) {
        if (relationship == null) {
            throw new IllegalArgumentException("A relationship must be specified");
        }
        if (StringUtils.isNullOrEmpty((String)identifier)) {
            identifier = UUID.randomUUID().toString();
        }
        for (String id : this.relationshipsByIdentifier.keySet()) {
            Relationship r = this.relationshipsByIdentifier.get(id);
            if (!r.equals(relationship) || id.equalsIgnoreCase(identifier)) continue;
            if (id.matches("[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}")) {
                throw new RuntimeException("Please assign an identifier to \"" + relationship.getCanonicalName() + "\" before using it");
            }
            throw new RuntimeException("The relationship is already registered with an identifier of \"" + id + "\"");
        }
        Element e = this.getElement(identifier);
        Relationship r = this.getRelationship(identifier);
        if ((e != null || r != null) && r != relationship) {
            throw new RuntimeException("The identifier \"" + identifier + "\" is already in use");
        }
        this.relationshipsByIdentifier.put(identifier, relationship);
    }

    private String calculateHierarchicalIdentifier(String identifier, Element element) {
        if (element.getParent() == null) {
            if (element instanceof DeploymentNode) {
                DeploymentNode dn = (DeploymentNode)element;
                return this.findIdentifier(new DeploymentEnvironment(dn.getEnvironment())) + "." + identifier;
            }
            return identifier;
        }
        return this.findIdentifier(element.getParent()) + "." + identifier;
    }

    public String findIdentifier(Element element) {
        if (this.elementsByIdentifier.containsValue(element)) {
            for (String identifier : this.elementsByIdentifier.keySet()) {
                Element e = this.elementsByIdentifier.get(identifier);
                if (!e.equals(element)) continue;
                return identifier;
            }
        }
        return null;
    }

    public String findIdentifier(Relationship relationship) {
        if (this.relationshipsByIdentifier.containsValue(relationship)) {
            for (String identifier : this.relationshipsByIdentifier.keySet()) {
                Relationship r = this.relationshipsByIdentifier.get(identifier);
                if (!r.equals(relationship)) continue;
                return identifier;
            }
        }
        return null;
    }

    void validateIdentifierName(String identifier) {
        if (identifier.startsWith("-")) {
            throw new RuntimeException("Identifiers cannot start with a - character");
        }
        if (!IDENTIFIER_PATTERN.matcher(identifier).matches()) {
            throw new RuntimeException("Identifiers can only contain the following characters: a-zA-Z0-9_-");
        }
    }

    static String toIdentifier(String s) {
        String identifierName = s.replaceAll("[^a-zA-Z0-9_-]", "");
        if (identifierName.startsWith("-")) {
            identifierName = identifierName.substring(1);
        }
        return identifierName;
    }
}

