/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.ImageViewDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.export.mermaid.MermaidDiagramExporter;
import com.structurizr.export.plantuml.StructurizrPlantUMLExporter;
import com.structurizr.http.RemoteContent;
import com.structurizr.importer.diagrams.image.ImageImporter;
import com.structurizr.importer.diagrams.kroki.KrokiImporter;
import com.structurizr.importer.diagrams.mermaid.MermaidImporter;
import com.structurizr.importer.diagrams.plantuml.PlantUMLImporter;
import com.structurizr.util.FeatureNotEnabledException;
import com.structurizr.util.StringUtils;
import com.structurizr.util.Url;
import com.structurizr.view.ColorScheme;
import com.structurizr.view.ModelView;
import com.structurizr.view.View;
import java.io.File;

final class ImageViewContentParser
extends AbstractParser {
    private static final String PLANTUML_GRAMMAR = "plantuml <source|file|url|viewKey>";
    private static final String MERMAID_GRAMMAR = "mermaid <source|file|url|viewKey>";
    private static final String KROKI_GRAMMAR = "kroki <format> <source|file|url>";
    private static final String IMAGE_GRAMMAR = "image <file|url>";
    private static final int PLANTUML_SOURCE_INDEX = 1;
    private static final int MERMAID_SOURCE_INDEX = 1;
    private static final int KROKI_FORMAT_INDEX = 1;
    private static final int KROKI_SOURCE_INDEX = 2;
    private static final int IMAGE_SOURCE_INDEX = 1;

    ImageViewContentParser() {
    }

    void parsePlantUML(ImageViewDslContext context, File dslFile, Tokens tokens) {
        block13: {
            if (!tokens.includes(1)) {
                throw new RuntimeException("Expected: plantuml <source|file|url|viewKey>");
            }
            if (tokens.hasMoreThan(1)) {
                throw new RuntimeException("Too many tokens, expected: plantuml <source|file|url|viewKey>");
            }
            String source = tokens.get(1);
            ColorScheme colorScheme = context.getColorScheme();
            try {
                if (source.contains("\n")) {
                    new PlantUMLImporter(context.getHttpClient()).importDiagram(context.getView(), source, colorScheme);
                    break block13;
                }
                View viewWithKey = context.getWorkspace().getViews().getViewWithKey(source);
                if (viewWithKey instanceof ModelView) {
                    String plantumlLight = new StructurizrPlantUMLExporter(ColorScheme.Light).export((ModelView)viewWithKey).getDefinition();
                    new PlantUMLImporter(context.getHttpClient()).importDiagram(context.getView(), plantumlLight, ColorScheme.Light);
                    String plantumlDark = new StructurizrPlantUMLExporter(ColorScheme.Dark).export((ModelView)viewWithKey).getDefinition();
                    new PlantUMLImporter(context.getHttpClient()).importDiagram(context.getView(), plantumlDark, ColorScheme.Dark);
                    if (!StringUtils.isNullOrEmpty((String)viewWithKey.getTitle())) {
                        context.getView().setTitle(viewWithKey.getTitle());
                    } else {
                        context.getView().setTitle(viewWithKey.getName());
                    }
                    context.getView().setDescription(viewWithKey.getDescription());
                    break block13;
                }
                if (Url.isHttpsUrl((String)source) || Url.isHttpUrl((String)source)) {
                    if (Url.isHttpsUrl((String)source) && !context.getFeatures().isEnabled("structurizr.feature.dsl.https")) {
                        throw new FeatureNotEnabledException("structurizr.feature.dsl.https", "Image views via HTTPS are not permitted");
                    }
                    if (Url.isHttpUrl((String)source) && !context.getFeatures().isEnabled("structurizr.feature.dsl.http")) {
                        throw new FeatureNotEnabledException("structurizr.feature.dsl.http", "Image views via HTTP are not permitted");
                    }
                    RemoteContent content = context.getHttpClient().get(source);
                    new PlantUMLImporter(context.getHttpClient()).importDiagram(context.getView(), content.getContentAsString(), colorScheme);
                    context.getView().setTitle(source.substring(source.lastIndexOf("/") + 1));
                    break block13;
                }
                if (context.getFeatures().isEnabled("structurizr.feature.dsl.filesystem")) {
                    File file = new File(dslFile.getParentFile(), source);
                    if (file.exists()) {
                        context.setDslPortable(false);
                        new PlantUMLImporter(context.getHttpClient()).importDiagram(context.getView(), file, colorScheme);
                        break block13;
                    }
                    throw new RuntimeException("The file at " + file.getAbsolutePath() + " does not exist");
                }
                throw new FeatureNotEnabledException("structurizr.feature.dsl.filesystem", "plantuml <file> is not permitted");
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    void parseMermaid(ImageViewDslContext context, File dslFile, Tokens tokens) {
        block13: {
            if (!tokens.includes(1)) {
                throw new RuntimeException("Expected: mermaid <source|file|url|viewKey>");
            }
            if (tokens.hasMoreThan(1)) {
                throw new RuntimeException("Too many tokens, expected: mermaid <source|file|url|viewKey>");
            }
            String source = tokens.get(1);
            ColorScheme colorScheme = context.getColorScheme();
            try {
                if (source.contains("\n")) {
                    new MermaidImporter(context.getHttpClient()).importDiagram(context.getView(), source, colorScheme);
                    break block13;
                }
                View viewWithKey = context.getWorkspace().getViews().getViewWithKey(source);
                if (viewWithKey instanceof ModelView) {
                    MermaidDiagramExporter exporter = new MermaidDiagramExporter();
                    String mermaid = exporter.export((ModelView)viewWithKey).getDefinition();
                    new MermaidImporter(context.getHttpClient()).importDiagram(context.getView(), mermaid, colorScheme);
                    if (!StringUtils.isNullOrEmpty((String)viewWithKey.getTitle())) {
                        context.getView().setTitle(viewWithKey.getTitle());
                    } else {
                        context.getView().setTitle(viewWithKey.getName());
                    }
                    context.getView().setDescription(viewWithKey.getDescription());
                    break block13;
                }
                if (Url.isHttpsUrl((String)source) || Url.isHttpUrl((String)source)) {
                    if (Url.isHttpsUrl((String)source) && !context.getFeatures().isEnabled("structurizr.feature.dsl.https")) {
                        throw new FeatureNotEnabledException("structurizr.feature.dsl.https", "Image views via HTTPS are not permitted");
                    }
                    if (Url.isHttpUrl((String)source) && !context.getFeatures().isEnabled("structurizr.feature.dsl.http")) {
                        throw new FeatureNotEnabledException("structurizr.feature.dsl.http", "Image views via HTTP are not permitted");
                    }
                    RemoteContent content = context.getHttpClient().get(source);
                    new MermaidImporter(context.getHttpClient()).importDiagram(context.getView(), content.getContentAsString(), colorScheme);
                    context.getView().setTitle(source.substring(source.lastIndexOf("/") + 1));
                    break block13;
                }
                if (context.getFeatures().isEnabled("structurizr.feature.dsl.filesystem")) {
                    File file = new File(dslFile.getParentFile(), source);
                    if (file.exists()) {
                        context.setDslPortable(false);
                        new MermaidImporter(context.getHttpClient()).importDiagram(context.getView(), file, colorScheme);
                        break block13;
                    }
                    throw new RuntimeException("The file at " + file.getAbsolutePath() + " does not exist");
                }
                throw new FeatureNotEnabledException("structurizr.feature.dsl.filesystem", "mermaid <file> is not permitted");
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    void parseKroki(ImageViewDslContext context, File dslFile, Tokens tokens) {
        block10: {
            if (!tokens.includes(2)) {
                throw new RuntimeException("Expected: kroki <format> <source|file|url>");
            }
            if (tokens.hasMoreThan(2)) {
                throw new RuntimeException("Too many tokens, expected: kroki <format> <source|file|url>");
            }
            String format = tokens.get(1);
            String source = tokens.get(2);
            ColorScheme colorScheme = context.getColorScheme();
            try {
                if (source.contains("\n")) {
                    new KrokiImporter(context.getHttpClient()).importDiagram(context.getView(), format, source, colorScheme);
                    break block10;
                }
                if (Url.isHttpsUrl((String)source) || Url.isHttpUrl((String)source)) {
                    if (Url.isHttpsUrl((String)source) && !context.getFeatures().isEnabled("structurizr.feature.dsl.https")) {
                        throw new FeatureNotEnabledException("structurizr.feature.dsl.https", "Image views via HTTPS are not permitted");
                    }
                    if (Url.isHttpUrl((String)source) && !context.getFeatures().isEnabled("structurizr.feature.dsl.http")) {
                        throw new FeatureNotEnabledException("structurizr.feature.dsl.http", "Image views via HTTP are not permitted");
                    }
                    RemoteContent content = context.getHttpClient().get(source);
                    new KrokiImporter(context.getHttpClient()).importDiagram(context.getView(), format, content.getContentAsString(), colorScheme);
                    context.getView().setTitle(source.substring(source.lastIndexOf("/") + 1));
                    break block10;
                }
                if (context.getFeatures().isEnabled("structurizr.feature.dsl.filesystem")) {
                    File file = new File(dslFile.getParentFile(), source);
                    if (file.exists()) {
                        context.setDslPortable(false);
                        new KrokiImporter(context.getHttpClient()).importDiagram(context.getView(), format, file, colorScheme);
                        break block10;
                    }
                    throw new RuntimeException("The file at " + file.getAbsolutePath() + " does not exist");
                }
                throw new FeatureNotEnabledException("structurizr.feature.dsl.filesystem", "kroki " + format + " <file> is not permitted");
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    void parseImage(ImageViewDslContext context, File dslFile, Tokens tokens) {
        block9: {
            if (!tokens.includes(1)) {
                throw new RuntimeException("Expected: image <file|url>");
            }
            if (tokens.hasMoreThan(1)) {
                throw new RuntimeException("Too many tokens, expected: image <file|url>");
            }
            String source = tokens.get(1);
            ColorScheme colorScheme = context.getColorScheme();
            try {
                if (Url.isHttpsUrl((String)source) || Url.isHttpUrl((String)source)) {
                    if (Url.isHttpsUrl((String)source) && !context.getFeatures().isEnabled("structurizr.feature.dsl.https")) {
                        throw new FeatureNotEnabledException("structurizr.feature.dsl.https", "Image views via HTTPS are not permitted");
                    }
                    if (Url.isHttpUrl((String)source) && !context.getFeatures().isEnabled("structurizr.feature.dsl.http")) {
                        throw new FeatureNotEnabledException("structurizr.feature.dsl.http", "Image views via HTTP are not permitted");
                    }
                    new ImageImporter(context.getHttpClient()).importDiagram(context.getView(), source, colorScheme);
                    break block9;
                }
                if (context.getFeatures().isEnabled("structurizr.feature.dsl.filesystem")) {
                    File file = new File(dslFile.getParentFile(), source);
                    if (file.exists()) {
                        context.setDslPortable(false);
                        new ImageImporter(context.getHttpClient()).importDiagram(context.getView(), file, colorScheme);
                        break block9;
                    }
                    throw new RuntimeException("The file at " + file.getAbsolutePath() + " does not exist");
                }
                throw new FeatureNotEnabledException("structurizr.feature.dsl.filesystem", "image <file> is not permitted");
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

