/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.IncludedFile;
import com.structurizr.dsl.Tokens;
import com.structurizr.http.RemoteContent;
import com.structurizr.util.FeatureNotEnabledException;
import com.structurizr.util.Url;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class IncludeParser
extends AbstractParser {
    private static final String GRAMMAR = "!include <file|directory|url>";
    private static final int SOURCE_INDEX = 1;

    IncludeParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<IncludedFile> parse(DslContext context, File dslFile, Tokens tokens) {
        if (!context.getFeatures().isEnabled("structurizr.feature.dsl.include")) {
            throw new FeatureNotEnabledException("structurizr.feature.dsl.include", "!include is not permitted");
        }
        ArrayList<IncludedFile> includedFiles = new ArrayList<IncludedFile>();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: !include <file|directory|url>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: !include <file|directory|url>");
        }
        String source = tokens.get(1);
        if (Url.isHttpsUrl((String)source)) {
            if (!context.getFeatures().isEnabled("structurizr.feature.dsl.https")) throw new FeatureNotEnabledException("structurizr.feature.dsl.https", "Includes via HTTPS are not permitted");
            RemoteContent content = context.getHttpClient().get(source);
            List<String> lines = Arrays.asList(content.getContentAsString().split("\n"));
            includedFiles.add(new IncludedFile(dslFile, lines));
            return includedFiles;
        }
        if (Url.isHttpUrl((String)source)) {
            if (!context.getFeatures().isEnabled("structurizr.feature.dsl.http")) throw new FeatureNotEnabledException("structurizr.feature.dsl.http", "Includes via HTTP are not permitted");
            RemoteContent content = context.getHttpClient().get(source);
            List<String> lines = Arrays.asList(content.getContentAsString().split("\n"));
            includedFiles.add(new IncludedFile(dslFile, lines));
            return includedFiles;
        }
        if (!context.getFeatures().isEnabled("structurizr.feature.dsl.filesystem")) throw new FeatureNotEnabledException("structurizr.feature.dsl.filesystem", "!include <file> is not permitted");
        if (dslFile == null) return includedFiles;
        File path = new File(dslFile.getParent(), source);
        try {
            if (!path.exists()) {
                throw new RuntimeException(path.getCanonicalPath() + " could not be found");
            }
            includedFiles.addAll(this.readFiles(path));
            context.setDslPortable(false);
            return includedFiles;
        }
        catch (IOException e) {
            throw new RuntimeException("Error including " + path.getAbsolutePath() + ": " + e.getMessage());
        }
    }

    private List<IncludedFile> readFiles(File path) throws IOException {
        ArrayList<IncludedFile> includedFiles;
        block5: {
            block4: {
                includedFiles = new ArrayList<IncludedFile>();
                if (path.isHidden() || path.getName().startsWith(".")) {
                    return includedFiles;
                }
                if (!path.isDirectory()) break block4;
                Object[] files = path.listFiles();
                if (files == null) break block5;
                Arrays.sort(files);
                for (Object file : files) {
                    includedFiles.addAll(this.readFiles((File)file));
                }
                break block5;
            }
            try {
                includedFiles.add(new IncludedFile(path, Files.readAllLines(path.toPath(), StandardCharsets.UTF_8)));
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading file at " + path.getAbsolutePath() + ": " + e.getMessage());
            }
        }
        return includedFiles;
    }
}

