/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.ContainerInstanceParser;
import com.structurizr.dsl.DeploymentNodeDslContext;
import com.structurizr.dsl.SoftwareSystemInstanceParser;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.StaticStructureElementInstance;

final class InstanceOfParser {
    private static final String GRAMMAR = "instanceOf <identifier> [deploymentGroups] [tags]";
    private static final int IDENTIFIER_INDEX = 1;
    private static final int TAGS_INDEX = 3;

    InstanceOfParser() {
    }

    StaticStructureElementInstance parse(DeploymentNodeDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(3)) {
            throw new RuntimeException("Too many tokens, expected: instanceOf <identifier> [deploymentGroups] [tags]");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: instanceOf <identifier> [deploymentGroups] [tags]");
        }
        String elementIdentifier = tokens.get(1);
        Element element = context.getElement(elementIdentifier);
        if (element == null) {
            throw new RuntimeException("The element \"" + elementIdentifier + "\" does not exist");
        }
        if (element instanceof SoftwareSystem) {
            return new SoftwareSystemInstanceParser().parse(context, tokens);
        }
        if (element instanceof Container) {
            return new ContainerInstanceParser().parse(context, tokens);
        }
        throw new RuntimeException("The element \"" + elementIdentifier + "\" must be a software system or a container");
    }
}

