/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractRelationshipParser;
import com.structurizr.dsl.DeploymentEnvironmentDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.StaticStructureElementInstance;
import java.util.HashSet;
import java.util.Set;

final class NoRelationshipParser
extends AbstractRelationshipParser {
    private static final String GRAMMAR = "<identifier> -/> <identifier> [description]";
    private static final int SOURCE_IDENTIFIER_INDEX = 0;
    private static final int DESTINATION_IDENTIFIER_INDEX = 2;
    private static final int DESCRIPTION_IDENTIFIER_INDEX = 3;

    NoRelationshipParser() {
    }

    Set<Relationship> parse(DeploymentEnvironmentDslContext context, Tokens tokens) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        if (tokens.hasMoreThan(3)) {
            throw new RuntimeException("Too many tokens, expected: <identifier> -/> <identifier> [description]");
        }
        if (!tokens.includes(2)) {
            throw new RuntimeException("Not enough tokens, expected: <identifier> -/> <identifier> [description]");
        }
        String sourceId = tokens.get(0);
        Element sourceElement = context.getElement(sourceId);
        Set<Object> sourceElements = new HashSet<StaticStructureElementInstance>();
        if (sourceElement == null) {
            throw new RuntimeException("The source element \"" + sourceId + "\" does not exist");
        }
        if (sourceElement instanceof SoftwareSystem) {
            sourceElements = this.findSoftwareSystemInstances((SoftwareSystem)sourceElement, context.getEnvironment().getName());
        } else if (sourceElement instanceof Container) {
            sourceElements = this.findContainerInstances((Container)sourceElement, context.getEnvironment().getName());
        } else if (sourceElement instanceof StaticStructureElementInstance) {
            sourceElements.add((StaticStructureElementInstance)sourceElement);
        } else {
            throw new RuntimeException("The source element \"" + sourceId + "\" is not valid - expecting a software system, software system instance, container, or container instance");
        }
        String destinationId = tokens.get(2);
        Element destinationElement = context.getElement(destinationId);
        Set<Object> destinationElements = new HashSet<StaticStructureElementInstance>();
        if (destinationElement == null) {
            throw new RuntimeException("The destination element \"" + destinationId + "\" does not exist");
        }
        if (destinationElement instanceof SoftwareSystem) {
            destinationElements = this.findSoftwareSystemInstances((SoftwareSystem)destinationElement, context.getEnvironment().getName());
        } else if (destinationElement instanceof Container) {
            destinationElements = this.findContainerInstances((Container)destinationElement, context.getEnvironment().getName());
        } else if (destinationElement instanceof StaticStructureElementInstance) {
            destinationElements.add((StaticStructureElementInstance)destinationElement);
        } else {
            throw new RuntimeException("The destination element \"" + destinationId + "\" is not valid - expecting a software system, software system instance, container, or container instance");
        }
        String description = null;
        if (tokens.includes(3)) {
            description = tokens.get(3);
        }
        int count = 0;
        for (Element element : sourceElements) {
            for (Element element2 : destinationElements) {
                Relationship relationship;
                do {
                    if ((relationship = description != null ? element.getEfferentRelationshipWith(element2, description) : element.getEfferentRelationshipWith(element2)) == null || relationship.getLinkedRelationshipId() == null) continue;
                    context.getWorkspace().remove(relationship);
                    relationships.add(relationship);
                    ++count;
                } while (relationship != null);
            }
        }
        if (count == 0) {
            if (description != null) {
                throw new RuntimeException("A relationship between \"" + sourceId + "\" and \"" + destinationId + "\" with description \"" + description + "\" does not exist");
            }
            throw new RuntimeException("A relationship between \"" + sourceId + "\" and \"" + destinationId + "\" does not exist");
        }
        return relationships;
    }
}

