/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.Workspace;
import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.DslParserContext;
import com.structurizr.dsl.DslUtils;
import com.structurizr.dsl.StructurizrDslParser;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.CreateImpliedRelationshipsUnlessAnyRelationshipExistsStrategy;
import com.structurizr.model.Element;
import com.structurizr.model.ImpliedRelationshipsStrategy;
import com.structurizr.model.Relationship;
import com.structurizr.util.FeatureNotEnabledException;
import com.structurizr.util.Url;
import com.structurizr.util.WorkspaceUtils;
import java.io.File;

final class WorkspaceParser
extends AbstractParser {
    private static final String GRAMMAR_STANDALONE = "workspace [name] [description]";
    private static final String GRAMMAR_EXTENDS = "workspace extends <file|url>";
    private static final String STRUCTURIZR_DSL_IDENTIFIER_PROPERTY_NAME = "structurizr.dsl.identifier";
    private static final int FIRST_INDEX = 1;
    private static final int SECOND_INDEX = 2;

    WorkspaceParser() {
    }

    /*
     * Unable to fully structure code
     */
    Workspace parse(DslParserContext context, Tokens tokens) {
        block15: {
            workspace = new Workspace("Name", "Description");
            if (tokens.hasMoreThan(2)) {
                throw new RuntimeException("Too many tokens, expected: workspace [name] [description] or workspace extends <file|url>");
            }
            if (!tokens.includes(1)) break block15;
            firstToken = tokens.get(1);
            if (!"extends".equals(firstToken)) ** GOTO lbl49
            if (tokens.includes(2)) {
                source = tokens.get(2);
                try {
                    if (Url.isHttpsUrl((String)source) || Url.isHttpUrl((String)source)) {
                        if (Url.isHttpsUrl((String)source) && !context.getFeatures().isEnabled("structurizr.feature.dsl.https")) {
                            throw new FeatureNotEnabledException("structurizr.feature.dsl.https", "Extends via HTTPS are not permitted");
                        }
                        if (Url.isHttpUrl((String)source) && !context.getFeatures().isEnabled("structurizr.feature.dsl.http")) {
                            throw new FeatureNotEnabledException("structurizr.feature.dsl.http", "Extends via HTTP are not permitted");
                        }
                        remoteContent = context.getHttpClient().get(source);
                        if (source.toLowerCase().endsWith(".json") || remoteContent.getContentType().startsWith("application/json")) {
                            json = remoteContent.getContentAsString();
                            workspace = WorkspaceUtils.fromJson((String)json);
                            this.registerIdentifiers(workspace, context);
                        }
                        dsl = remoteContent.getContentAsString();
                        structurizrDslParser = this.createParser(context);
                        structurizrDslParser.parse(context, dsl);
                        workspace = structurizrDslParser.getWorkspace();
                        context.getParser().configureFrom(structurizrDslParser);
                    }
                    if (!context.getFeatures().isEnabled("structurizr.feature.dsl.filesystem")) {
                        throw new FeatureNotEnabledException("structurizr.feature.dsl.filesystem", "Extending a file-based workspace is not permitted");
                    }
                    if (context.getFile() == null) ** GOTO lbl52
                    file = new File(context.getFile().getParent(), source);
                    if (!file.exists()) {
                        throw new RuntimeException(file.getCanonicalPath() + " could not be found");
                    }
                    if (file.isDirectory()) {
                        throw new RuntimeException(file.getCanonicalPath() + " should be a single file");
                    }
                    if (source.toLowerCase().endsWith(".json")) {
                        workspace = WorkspaceUtils.loadWorkspaceFromJson((File)file);
                        this.registerIdentifiers(workspace, context);
                    } else {
                        structurizrDslParser = this.createParser(context);
                        structurizrDslParser.parse(context, file);
                        workspace = structurizrDslParser.getWorkspace();
                        context.getParser().configureFrom(structurizrDslParser);
                    }
                    DslUtils.clearDsl(workspace);
                    context.setDslPortable(false);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            } else {
                throw new RuntimeException("Expected: workspace extends <file|url>");
lbl49:
                // 1 sources

                workspace.setName(firstToken);
                if (tokens.includes(2)) {
                    workspace.setDescription(tokens.get(2));
                }
            }
        }
        workspace.getModel().setImpliedRelationshipsStrategy((ImpliedRelationshipsStrategy)new CreateImpliedRelationshipsUnlessAnyRelationshipExistsStrategy());
        return workspace;
    }

    private StructurizrDslParser createParser(DslParserContext context) {
        StructurizrDslParser parser = new StructurizrDslParser();
        parser.setFeatures(context.getFeatures());
        parser.setHttpClient(context.getHttpClient());
        return parser;
    }

    private void registerIdentifiers(Workspace workspace, DslParserContext context) {
        String identifier;
        for (Element element : workspace.getModel().getElements()) {
            if (!element.getProperties().containsKey(STRUCTURIZR_DSL_IDENTIFIER_PROPERTY_NAME)) continue;
            identifier = (String)element.getProperties().get(STRUCTURIZR_DSL_IDENTIFIER_PROPERTY_NAME);
            context.identifiersRegister.register(identifier, element);
        }
        for (Relationship relationship : workspace.getModel().getRelationships()) {
            if (!relationship.getProperties().containsKey(STRUCTURIZR_DSL_IDENTIFIER_PROPERTY_NAME)) continue;
            identifier = (String)relationship.getProperties().get(STRUCTURIZR_DSL_IDENTIFIER_PROPERTY_NAME);
            context.identifiersRegister.register(identifier, relationship);
        }
    }

    void parseName(DslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: name <name>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: name <name>");
        }
        String name = tokens.get(1);
        context.getWorkspace().setName(name);
    }

    void parseDescription(DslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: description <description>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: description <description>");
        }
        String description = tokens.get(1);
        context.getWorkspace().setDescription(description);
    }
}

