/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.export;

import com.structurizr.Workspace;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.CustomElement;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.util.StringUtils;
import com.structurizr.view.Configuration;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.MetadataSymbols;
import com.structurizr.view.ModelView;
import com.structurizr.view.RelationshipStyle;

public abstract class AbstractExporter {
    protected String breakText(int maxWidth, int fontSize, String s) {
        if (StringUtils.isNullOrEmpty((String)s)) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        double characterWidth = (double)fontSize * 0.6;
        int maxCharacters = (int)((double)maxWidth / characterWidth);
        if (s.length() < maxCharacters) {
            return s;
        }
        String[] words = s.split(" ");
        String line = null;
        for (String word : words) {
            if (line == null) {
                line = word;
                continue;
            }
            if (line.length() + word.length() + 1 < maxCharacters) {
                line = line + " ";
                line = line + word;
                continue;
            }
            buf.append(line);
            buf.append("<br />");
            line = word;
        }
        if (line != null) {
            buf.append(line);
        }
        return buf.toString();
    }

    protected String typeOf(Workspace workspace, Element e, boolean includeMetadataSymbols) {
        return this.typeOf(workspace.getViews().getConfiguration(), e, includeMetadataSymbols);
    }

    protected String typeOf(ModelView view, Element e, boolean includeMetadataSymbols) {
        return this.typeOf(view.getViewSet().getConfiguration(), e, includeMetadataSymbols);
    }

    private String typeOf(Configuration configuration, Element e, boolean includeMetadataSymbols) {
        String type = "";
        if (e instanceof Person) {
            type = configuration.getTerminology().findTerminology((ModelItem)e);
        } else if (e instanceof SoftwareSystem) {
            type = configuration.getTerminology().findTerminology((ModelItem)e);
        } else if (e instanceof Container) {
            Container container = (Container)e;
            type = configuration.getTerminology().findTerminology((ModelItem)e) + (this.hasValue(container.getTechnology()) ? ": " + container.getTechnology() : "");
        } else if (e instanceof Component) {
            Component component = (Component)e;
            type = configuration.getTerminology().findTerminology((ModelItem)e) + (this.hasValue(component.getTechnology()) ? ": " + component.getTechnology() : "");
        } else if (e instanceof DeploymentNode) {
            DeploymentNode deploymentNode = (DeploymentNode)e;
            type = configuration.getTerminology().findTerminology((ModelItem)e) + (this.hasValue(deploymentNode.getTechnology()) ? ": " + deploymentNode.getTechnology() : "");
        } else if (e instanceof InfrastructureNode) {
            InfrastructureNode infrastructureNode = (InfrastructureNode)e;
            type = configuration.getTerminology().findTerminology((ModelItem)e) + (this.hasValue(infrastructureNode.getTechnology()) ? ": " + infrastructureNode.getTechnology() : "");
        } else if (e instanceof CustomElement) {
            type = ((CustomElement)e).getMetadata();
        }
        if (StringUtils.isNullOrEmpty((String)type)) {
            return type;
        }
        if (includeMetadataSymbols) {
            if (configuration.getMetadataSymbols() == null) {
                configuration.setMetadataSymbols(MetadataSymbols.SquareBrackets);
            }
            switch (configuration.getMetadataSymbols()) {
                case RoundBrackets: {
                    return "(" + type + ")";
                }
                case CurlyBrackets: {
                    return "{" + type + "}";
                }
                case AngleBrackets: {
                    return "<" + type + ">";
                }
                case DoubleAngleBrackets: {
                    return "<<" + type + ">>";
                }
                case None: {
                    return type;
                }
            }
            return "[" + type + "]";
        }
        return type;
    }

    protected boolean hasValue(String s) {
        return !StringUtils.isNullOrEmpty((String)s);
    }

    protected ElementStyle findElementStyle(ModelView view, Element element) {
        return view.getViewSet().getConfiguration().getStyles().findElementStyle(element);
    }

    protected RelationshipStyle findRelationshipStyle(ModelView view, Relationship relationship) {
        return view.getViewSet().getConfiguration().getStyles().findRelationshipStyle(relationship);
    }
}

