/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.export.plantuml;

import com.structurizr.export.Diagram;
import com.structurizr.export.IndentingWriter;
import com.structurizr.export.plantuml.AbstractPlantUMLExporter;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.CustomElement;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.Location;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.StaticStructureElementInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.CustomView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.ElementView;
import com.structurizr.view.Font;
import com.structurizr.view.LineStyle;
import com.structurizr.view.ModelView;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.Shape;
import java.util.ArrayList;
import java.util.HashMap;

public class C4PlantUMLExporter
extends AbstractPlantUMLExporter {
    private static final String STRUCTURIZR_PROPERTY_NAME = "structurizr.";
    public static final String C4PLANTUML_LEGEND_PROPERTY = "c4plantuml.legend";
    public static final String C4PLANTUML_STEREOTYPES_PROPERTY = "c4plantuml.stereotypes";
    public static final String C4PLANTUML_TAGS_PROPERTY = "c4plantuml.tags";
    public static final String C4PLANTUML_STANDARD_LIBRARY_PROPERTY = "c4plantuml.stdlib";
    public static final String C4PLANTUML_SPRITE = "c4plantuml.sprite";
    public static final String C4PLANTUML_SHADOW = "c4plantuml.shadow";
    public static final String C4PLANTUML_ELEMENT_PROPERTIES_PROPERTY = "c4plantuml.elementProperties";
    public static final String C4PLANTUML_RELATIONSHIP_PROPERTIES_PROPERTY = "c4plantuml.relationshipProperties";
    private int groupId = 0;

    @Override
    protected void writeHeader(ModelView view, IndentingWriter writer) {
        String fontName;
        super.writeHeader(view, writer);
        this.groupId = 0;
        Font font = view.getViewSet().getConfiguration().getBranding().getFont();
        if (font != null && !StringUtils.isNullOrEmpty((String)(fontName = font.getName()))) {
            this.addSkinParam("defaultFontName", "\"" + fontName + "\"");
        }
        this.writeSkinParams(writer);
        if (view.getAutomaticLayout() != null) {
            switch (view.getAutomaticLayout().getRankDirection()) {
                case LeftRight: {
                    writer.writeLine("left to right direction");
                    break;
                }
                default: {
                    writer.writeLine("top to bottom direction");
                    break;
                }
            }
        } else {
            writer.writeLine("top to bottom direction");
        }
        writer.writeLine();
        if (this.usePlantUMLStandardLibrary(view)) {
            writer.writeLine("!include <C4/C4>");
            writer.writeLine("!include <C4/C4_Context>");
        } else {
            writer.writeLine("!include https://raw.githubusercontent.com/plantuml-stdlib/C4-PlantUML/master/C4.puml");
            writer.writeLine("!include https://raw.githubusercontent.com/plantuml-stdlib/C4-PlantUML/master/C4_Context.puml");
        }
        if (view.getElements().stream().map(ElementView::getElement).anyMatch(e -> e instanceof Container || e instanceof ContainerInstance)) {
            if (this.usePlantUMLStandardLibrary(view)) {
                writer.writeLine("!include <C4/C4_Container>");
            } else {
                writer.writeLine("!include https://raw.githubusercontent.com/plantuml-stdlib/C4-PlantUML/master/C4_Container.puml");
            }
        }
        if (view.getElements().stream().map(ElementView::getElement).anyMatch(e -> e instanceof Component)) {
            if (this.usePlantUMLStandardLibrary(view)) {
                writer.writeLine("!include <C4/C4_Component>");
            } else {
                writer.writeLine("!include https://raw.githubusercontent.com/plantuml-stdlib/C4-PlantUML/master/C4_Component.puml");
            }
        }
        if (view instanceof DeploymentView) {
            if (this.usePlantUMLStandardLibrary(view)) {
                writer.writeLine("!include <C4/C4_Deployment>");
            } else {
                writer.writeLine("!include https://raw.githubusercontent.com/plantuml-stdlib/C4-PlantUML/master/C4_Deployment.puml");
            }
        }
        this.writeIncludes(view, writer);
        if (this.includeTags(view)) {
            RelationshipStyle relationshipStyle;
            ElementStyle elementStyle;
            HashMap<String, ElementStyle> elementStyles = new HashMap<String, ElementStyle>();
            HashMap<String, RelationshipStyle> relationshipStyles = new HashMap<String, RelationshipStyle>();
            HashMap<String, ElementStyle> boundaryStyles = new HashMap<String, ElementStyle>();
            for (ElementView elementView : view.getElements()) {
                Element element = elementView.getElement();
                elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle(element);
                elementStyles.put(elementStyle.getTag(), elementStyle);
            }
            for (RelationshipView relationshipView : view.getRelationships()) {
                Relationship relationship = relationshipView.getRelationship();
                relationshipStyle = view.getViewSet().getConfiguration().getStyles().findRelationshipStyle(relationship);
                relationshipStyles.put(relationshipStyle.getTag(), relationshipStyle);
            }
            ArrayList<Object> boundaryElements = new ArrayList<Object>();
            if (view instanceof ContainerView) {
                boundaryElements.addAll(this.getBoundarySoftwareSystems(view));
            } else if (view instanceof ComponentView) {
                boundaryElements.addAll(this.getBoundaryContainers(view));
            } else if (view instanceof DynamicView) {
                DynamicView dynamicView = (DynamicView)view;
                if (dynamicView.getElement() instanceof SoftwareSystem) {
                    boundaryElements.addAll(this.getBoundarySoftwareSystems(view));
                } else if (dynamicView.getElement() instanceof Container) {
                    boundaryElements.addAll(this.getBoundaryContainers(view));
                }
            }
            for (Element element : boundaryElements) {
                elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle(element);
                boundaryStyles.put(elementStyle.getTag(), elementStyle);
            }
            if (!elementStyles.isEmpty()) {
                writer.writeLine();
                for (String string : elementStyles.keySet()) {
                    elementStyle = (ElementStyle)elementStyles.get(string);
                    String string2 = string.replaceFirst("Element,", "");
                    String sprite = "";
                    if (this.elementStyleHasSupportedIcon(elementStyle)) {
                        double scale = this.calculateIconScale(elementStyle.getIcon());
                        sprite = "img:" + elementStyle.getIcon() + "{scale=" + scale + "}";
                    }
                    sprite = elementStyle.getProperties().getOrDefault(C4PLANTUML_SPRITE, sprite);
                    writer.writeLine(String.format("AddElementTag(\"%s\", $bgColor=\"%s\", $borderColor=\"%s\", $fontColor=\"%s\", $sprite=\"%s\", $shadowing=\"%s\")", string2, elementStyle.getBackground(), elementStyle.getStroke(), elementStyle.getColor(), sprite, elementStyle.getProperties().getOrDefault(C4PLANTUML_SHADOW, "")));
                }
            }
            if (!relationshipStyles.isEmpty()) {
                writer.writeLine();
                for (String string : relationshipStyles.keySet()) {
                    relationshipStyle = (RelationshipStyle)relationshipStyles.get(string);
                    String string3 = string.replaceFirst("Relationship,", "");
                    String lineStyle = "\"\"";
                    if (relationshipStyle.getStyle() == LineStyle.Dashed) {
                        lineStyle = "DashedLine()";
                    } else if (relationshipStyle.getStyle() == LineStyle.Dotted) {
                        lineStyle = "DottedLine()";
                    }
                    writer.writeLine(String.format("AddRelTag(\"%s\", $textColor=\"%s\", $lineColor=\"%s\", $lineStyle = %s)", string3, relationshipStyle.getColor(), relationshipStyle.getColor(), lineStyle));
                }
            }
            if (!boundaryStyles.isEmpty()) {
                writer.writeLine();
                for (String string : boundaryStyles.keySet()) {
                    elementStyle = (ElementStyle)boundaryStyles.get(string);
                    String string4 = string.replaceFirst("Element,", "");
                    writer.writeLine(String.format("AddBoundaryTag(\"%s\", $bgColor=\"%s\", $borderColor=\"%s\", $fontColor=\"%s\", $shadowing=\"%s\")", string4, "#ffffff", elementStyle.getStroke(), elementStyle.getStroke(), elementStyle.getProperties().getOrDefault(C4PLANTUML_SHADOW, "")));
                }
            }
        }
        writer.writeLine();
    }

    @Override
    protected void writeFooter(ModelView view, IndentingWriter writer) {
        if (this.includeLegend(view)) {
            writer.writeLine();
            writer.writeLine("SHOW_LEGEND(" + !this.includeStereotypes(view) + ")");
        } else {
            writer.writeLine();
            writer.writeLine((this.includeStereotypes(view) ? "show" : "hide") + " stereotypes");
        }
        super.writeFooter(view, writer);
    }

    @Override
    protected void startEnterpriseBoundary(ModelView view, String enterpriseName, IndentingWriter writer) {
        writer.writeLine(String.format("Enterprise_Boundary(enterprise, \"%s\") {", enterpriseName));
        writer.indent();
    }

    @Override
    protected void endEnterpriseBoundary(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    @Override
    protected void startGroupBoundary(ModelView view, String group, IndentingWriter writer) {
        ++this.groupId;
        String groupName = group;
        String groupSeparator = (String)view.getModel().getProperties().get("structurizr.groupSeparator");
        if (!StringUtils.isNullOrEmpty((String)groupSeparator)) {
            groupName = group.substring(group.lastIndexOf(groupSeparator) + groupSeparator.length());
        }
        String color = "#cccccc";
        ElementStyle elementStyleForGroup = view.getViewSet().getConfiguration().getStyles().findElementStyle("Group:" + group);
        ElementStyle elementStyleForAllGroups = view.getViewSet().getConfiguration().getStyles().findElementStyle("Group");
        if (elementStyleForGroup != null && !StringUtils.isNullOrEmpty((String)elementStyleForGroup.getColor())) {
            color = elementStyleForGroup.getColor();
        } else if (elementStyleForAllGroups != null && !StringUtils.isNullOrEmpty((String)elementStyleForAllGroups.getColor())) {
            color = elementStyleForAllGroups.getColor();
        }
        writer.writeLine(String.format("AddBoundaryTag(\"%s\", $borderColor=\"%s\", $fontColor=\"%s\")", group, color, color));
        writer.writeLine(String.format("Boundary(group_%s, \"%s\", $tags=\"%s\") {", this.groupId, groupName, group));
        writer.indent();
    }

    @Override
    protected void endGroupBoundary(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    @Override
    protected void startSoftwareSystemBoundary(ModelView view, SoftwareSystem softwareSystem, IndentingWriter writer) {
        writer.writeLine(String.format("System_Boundary(\"%s_boundary\", \"%s\", $tags=\"%s\") {", this.idOf((ModelItem)softwareSystem), softwareSystem.getName(), this.tagsOf(view, (Element)softwareSystem)));
        writer.indent();
    }

    @Override
    protected void endSoftwareSystemBoundary(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    @Override
    protected void startContainerBoundary(ModelView view, Container container, IndentingWriter writer) {
        writer.writeLine(String.format("Container_Boundary(\"%s_boundary\", \"%s\", $tags=\"%s\") {", this.idOf((ModelItem)container), container.getName(), this.tagsOf(view, (Element)container)));
        writer.indent();
    }

    @Override
    protected void endContainerBoundary(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    @Override
    protected void startDeploymentNodeBoundary(DeploymentView view, DeploymentNode deploymentNode, IndentingWriter writer) {
        String technology;
        String url = deploymentNode.getUrl();
        if (StringUtils.isNullOrEmpty((String)url)) {
            url = "";
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(this.getViewOrViewSetProperty((ModelView)view, C4PLANTUML_ELEMENT_PROPERTIES_PROPERTY, Boolean.FALSE.toString()))) {
            this.addProperties((ModelView)view, writer, (ModelItem)deploymentNode);
        }
        if (StringUtils.isNullOrEmpty((String)(technology = deploymentNode.getTechnology()))) {
            technology = "";
        }
        writer.writeLine(String.format("Deployment_Node(%s, \"%s\", $type=\"%s\", $tags=\"%s\", $link=\"%s\") {", this.idOf((ModelItem)deploymentNode), deploymentNode.getName() + (!"1".equals(deploymentNode.getInstances()) ? " (x" + deploymentNode.getInstances() + ")" : ""), technology, this.tagsOf((ModelView)view, (Element)deploymentNode), url));
        writer.indent();
        if (!this.isVisible((ModelView)view, (Element)deploymentNode)) {
            writer.writeLine("hide " + this.idOf((ModelItem)deploymentNode));
        }
    }

    @Override
    protected void endDeploymentNodeBoundary(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    @Override
    public Diagram export(CustomView view) {
        return null;
    }

    @Override
    protected void writeElement(ModelView view, Element element, IndentingWriter writer) {
        if (element instanceof CustomElement) {
            return;
        }
        Element elementToWrite = element;
        ElementStyle elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle(element);
        String id = this.idOf((ModelItem)element);
        String url = element.getUrl();
        if (StringUtils.isNullOrEmpty((String)url)) {
            url = "";
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(this.getViewOrViewSetProperty(view, C4PLANTUML_ELEMENT_PROPERTIES_PROPERTY, Boolean.FALSE.toString()))) {
            this.addProperties(view, writer, (ModelItem)element);
        }
        if (element instanceof StaticStructureElementInstance) {
            StaticStructureElementInstance elementInstance = (StaticStructureElementInstance)element;
            element = elementInstance.getElement();
            if (StringUtils.isNullOrEmpty((String)url)) {
                url = element.getUrl();
                url = !StringUtils.isNullOrEmpty((String)url) ? "[[" + url + "]]" : "";
            }
        }
        String name = element.getName();
        String description = element.getDescription();
        if (StringUtils.isNullOrEmpty((String)description)) {
            description = "";
        }
        if (element instanceof Person) {
            Person person = (Person)element;
            String location = "";
            if (person.getLocation() == Location.External) {
                location = "_Ext";
            }
            writer.writeLine(String.format("Person%s(%s, \"%s\", $descr=\"%s\", $tags=\"%s\", $link=\"%s\")", location, id, name, description, this.tagsOf(view, elementToWrite), url));
        } else if (element instanceof SoftwareSystem) {
            SoftwareSystem softwareSystem = (SoftwareSystem)element;
            String location = "";
            if (softwareSystem.getLocation() == Location.External) {
                location = "_Ext";
            }
            writer.writeLine(String.format("System%s(%s, \"%s\", $descr=\"%s\", $tags=\"%s\", $link=\"%s\")", location, id, name, description, this.tagsOf(view, elementToWrite), url));
        } else if (element instanceof Container) {
            Container container = (Container)element;
            String shape = "";
            if (elementStyle.getShape() == Shape.Cylinder) {
                shape = "Db";
            } else if (elementStyle.getShape() == Shape.Pipe) {
                shape = "Queue";
            }
            String technology = container.getTechnology();
            if (StringUtils.isNullOrEmpty((String)technology)) {
                technology = "";
            }
            writer.writeLine(String.format("Container%s(%s, \"%s\", $techn=\"%s\", $descr=\"%s\", $tags=\"%s\", $link=\"%s\")", shape, id, name, technology, description, this.tagsOf(view, elementToWrite), url));
        } else if (element instanceof Component) {
            Component component = (Component)element;
            String shape = "";
            if (elementStyle.getShape() == Shape.Cylinder) {
                shape = "Db";
            } else if (elementStyle.getShape() == Shape.Pipe) {
                shape = "Queue";
            }
            String technology = component.getTechnology();
            if (StringUtils.isNullOrEmpty((String)technology)) {
                technology = "";
            }
            writer.writeLine(String.format("Component%s(%s, \"%s\", $techn=\"%s\", $descr=\"%s\", $tags=\"%s\", $link=\"%s\")", shape, id, name, technology, description, this.tagsOf(view, elementToWrite), url));
        } else if (element instanceof InfrastructureNode) {
            InfrastructureNode infrastructureNode = (InfrastructureNode)element;
            String technology = infrastructureNode.getTechnology();
            if (StringUtils.isNullOrEmpty((String)technology)) {
                technology = "";
            }
            writer.writeLine(String.format("Deployment_Node(%s, \"%s\", $type=\"%s\", $descr=\"%s\", $tags=\"%s\", $link=\"%s\")", this.idOf((ModelItem)infrastructureNode), name, technology, description, this.tagsOf(view, elementToWrite), url));
        }
        if (!this.isVisible(view, elementToWrite)) {
            writer.writeLine("hide " + id);
        }
    }

    private String tagsOf(ModelView view, Element element) {
        if (this.includeTags(view)) {
            return view.getViewSet().getConfiguration().getStyles().findElementStyle(element).getTag().replaceFirst("Element,", "");
        }
        return "";
    }

    private String tagsOf(ModelView view, Relationship relationship) {
        if (this.includeTags(view)) {
            return view.getViewSet().getConfiguration().getStyles().findRelationshipStyle(relationship).getTag().replaceFirst("Relationship,", "");
        }
        return "";
    }

    @Override
    protected void writeRelationship(ModelView view, RelationshipView relationshipView, IndentingWriter writer) {
        String url;
        Relationship relationship = relationshipView.getRelationship();
        Element source = relationship.getSource();
        Element destination = relationship.getDestination();
        if (source instanceof CustomElement || destination instanceof CustomElement) {
            return;
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(this.getViewOrViewSetProperty(view, C4PLANTUML_RELATIONSHIP_PROPERTIES_PROPERTY, Boolean.FALSE.toString()))) {
            this.addProperties(view, writer, (ModelItem)relationship);
        }
        if (relationshipView.isResponse() != null && relationshipView.isResponse().booleanValue()) {
            source = relationship.getDestination();
            destination = relationship.getSource();
        }
        String description = "";
        if (!StringUtils.isNullOrEmpty((String)relationshipView.getOrder())) {
            description = relationshipView.getOrder() + ". ";
        }
        description = description + (this.hasValue(relationshipView.getDescription()) ? relationshipView.getDescription() : (this.hasValue(relationshipView.getRelationship().getDescription()) ? relationshipView.getRelationship().getDescription() : ""));
        String technology = relationship.getTechnology();
        if (StringUtils.isNullOrEmpty((String)technology)) {
            technology = "";
        }
        if (StringUtils.isNullOrEmpty((String)(url = relationship.getUrl()))) {
            url = "";
        }
        writer.writeLine(String.format("Rel_D(%s, %s, \"%s\", $techn=\"%s\", $tags=\"%s\", $link=\"%s\")", this.idOf((ModelItem)source), this.idOf((ModelItem)destination), description, technology, this.tagsOf(view, relationship), url));
    }

    private void addProperties(ModelView view, IndentingWriter writer, ModelItem element) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String key2 : element.getProperties().keySet()) {
            if (key2.startsWith(STRUCTURIZR_PROPERTY_NAME)) continue;
            properties.put(key2, (String)element.getProperties().get(key2));
        }
        if (!properties.isEmpty()) {
            writer.writeLine("WithoutPropertyHeader()");
            properties.keySet().stream().sorted().forEach(key -> writer.writeLine(String.format("AddProperty(\"%s\",\"%s\")", key, properties.get(key))));
        }
    }

    @Override
    protected boolean isAnimationSupported(ModelView view) {
        return !(view instanceof DynamicView) && super.isAnimationSupported(view);
    }

    protected boolean includeLegend(ModelView view) {
        return "true".equalsIgnoreCase(this.getViewOrViewSetProperty(view, C4PLANTUML_LEGEND_PROPERTY, "true"));
    }

    protected boolean includeStereotypes(ModelView view) {
        return "true".equalsIgnoreCase(this.getViewOrViewSetProperty(view, C4PLANTUML_STEREOTYPES_PROPERTY, "false"));
    }

    protected boolean includeTags(ModelView view) {
        return "true".equalsIgnoreCase(this.getViewOrViewSetProperty(view, C4PLANTUML_TAGS_PROPERTY, "false"));
    }

    protected boolean usePlantUMLStandardLibrary(ModelView view) {
        return "true".equalsIgnoreCase(this.getViewOrViewSetProperty(view, C4PLANTUML_STANDARD_LIBRARY_PROPERTY, "true"));
    }
}

