/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.export.plantuml;

import com.structurizr.export.Diagram;
import com.structurizr.export.IndentingWriter;
import com.structurizr.export.Legend;
import com.structurizr.export.plantuml.AbstractPlantUMLExporter;
import com.structurizr.model.Container;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.StaticStructureElementInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.ElementView;
import com.structurizr.view.Font;
import com.structurizr.view.LineStyle;
import com.structurizr.view.ModelView;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.Shape;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public class StructurizrPlantUMLExporter
extends AbstractPlantUMLExporter {
    public static final String PLANTUML_SEQUENCE_DIAGRAM_PROPERTY = "plantuml.sequenceDiagram";
    public static final String PLANTUML_SHADOW = "plantuml.shadow";
    private int groupId = 0;

    public StructurizrPlantUMLExporter() {
        this.addSkinParam("arrowFontSize", "10");
        this.addSkinParam("defaultTextAlignment", "center");
        this.addSkinParam("wrapWidth", "200");
        this.addSkinParam("maxMessageSize", "100");
    }

    @Override
    protected void writeHeader(ModelView view, IndentingWriter writer) {
        String fontName;
        Font font;
        super.writeHeader(view, writer);
        this.groupId = 0;
        if (!(view instanceof DynamicView) || !this.renderAsSequenceDiagram(view)) {
            if (view.getAutomaticLayout() != null) {
                switch (view.getAutomaticLayout().getRankDirection()) {
                    case LeftRight: {
                        writer.writeLine("left to right direction");
                        break;
                    }
                    default: {
                        writer.writeLine("top to bottom direction");
                        break;
                    }
                }
            } else {
                writer.writeLine("top to bottom direction");
            }
            writer.writeLine();
        }
        if ((font = view.getViewSet().getConfiguration().getBranding().getFont()) != null && !StringUtils.isNullOrEmpty((String)(fontName = font.getName()))) {
            this.addSkinParam("defaultFontName", "\"" + fontName + "\"");
        }
        this.writeSkinParams(writer);
        this.writeIncludes(view, writer);
        writer.writeLine();
        writer.writeLine("hide stereotype");
        writer.writeLine();
        List elements = view.getElements().stream().map(ElementView::getElement).sorted(Comparator.comparing(Element::getName)).collect(Collectors.toList());
        for (Element element : elements) {
            String string = this.idOf((ModelItem)element);
            String type = this.plantUMLShapeOf(view, element);
            if ("actor".equals(type)) {
                type = "rectangle";
            }
            ElementStyle elementStyle = this.findElementStyle(view, element);
            String background = elementStyle.getBackground();
            String stroke = elementStyle.getStroke();
            String color = elementStyle.getColor();
            Shape shape = elementStyle.getShape();
            if (view instanceof DynamicView && this.renderAsSequenceDiagram(view)) {
                type = "sequenceParticipant";
            }
            writer.writeLine(String.format("skinparam %s<<%s>> {", type, string));
            writer.indent();
            if (element instanceof DeploymentNode) {
                writer.writeLine("BackgroundColor #ffffff");
            } else {
                writer.writeLine(String.format("BackgroundColor %s", background));
            }
            writer.writeLine(String.format("FontColor %s", color));
            writer.writeLine(String.format("BorderColor %s", stroke));
            if (shape == Shape.RoundedBox) {
                writer.writeLine("roundCorner 20");
            }
            boolean shadow = "true".equalsIgnoreCase(elementStyle.getProperties().getOrDefault(PLANTUML_SHADOW, "false"));
            writer.writeLine(String.format("shadowing %s", shadow));
            writer.outdent();
            writer.writeLine("}");
        }
        if (!this.renderAsSequenceDiagram(view)) {
            ArrayList<Object> boundaryElements = new ArrayList<Object>();
            if (view instanceof ContainerView) {
                boundaryElements.addAll(this.getBoundarySoftwareSystems(view));
            } else if (view instanceof ComponentView) {
                boundaryElements.addAll(this.getBoundaryContainers(view));
            } else if (view instanceof DynamicView) {
                DynamicView dynamicView = (DynamicView)view;
                if (dynamicView.getElement() instanceof SoftwareSystem) {
                    boundaryElements.addAll(this.getBoundarySoftwareSystems(view));
                } else if (dynamicView.getElement() instanceof Container) {
                    boundaryElements.addAll(this.getBoundaryContainers(view));
                }
            }
            for (Element element : boundaryElements) {
                ElementStyle elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle(element);
                String id = this.idOf((ModelItem)element);
                String color = elementStyle.getStroke();
                boolean shadow = "true".equalsIgnoreCase(elementStyle.getProperties().getOrDefault(PLANTUML_SHADOW, "false"));
                writer.writeLine(String.format("skinparam rectangle<<%s>> {", id));
                writer.indent();
                writer.writeLine(String.format("BorderColor %s", color));
                writer.writeLine(String.format("FontColor %s", color));
                writer.writeLine(String.format("shadowing %s", shadow));
                writer.outdent();
                writer.writeLine("}");
            }
        }
        writer.writeLine();
    }

    @Override
    protected void startEnterpriseBoundary(ModelView view, String enterpriseName, IndentingWriter writer) {
        if (!this.renderAsSequenceDiagram(view)) {
            writer.writeLine(String.format("rectangle \"%s\" <<enterprise>> {", enterpriseName));
            writer.indent();
            writer.writeLine("skinparam RectangleBorderColor<<enterprise>> #444444");
            writer.writeLine("skinparam RectangleFontColor<<enterprise>> #444444");
            writer.writeLine();
        }
    }

    @Override
    protected void endEnterpriseBoundary(ModelView view, IndentingWriter writer) {
        if (!this.renderAsSequenceDiagram(view)) {
            writer.outdent();
            writer.writeLine("}");
            writer.writeLine();
        }
    }

    @Override
    protected void startGroupBoundary(ModelView view, String group, IndentingWriter writer) {
        ++this.groupId;
        String groupName = group;
        String groupSeparator = (String)view.getModel().getProperties().get("structurizr.groupSeparator");
        if (!StringUtils.isNullOrEmpty((String)groupSeparator)) {
            groupName = group.substring(group.lastIndexOf(groupSeparator) + groupSeparator.length());
        }
        if (!this.renderAsSequenceDiagram(view)) {
            String color = "#cccccc";
            Object icon = "";
            ElementStyle elementStyleForGroup = view.getViewSet().getConfiguration().getStyles().findElementStyle("Group:" + group);
            ElementStyle elementStyleForAllGroups = view.getViewSet().getConfiguration().getStyles().findElementStyle("Group");
            if (elementStyleForGroup != null && !StringUtils.isNullOrEmpty((String)elementStyleForGroup.getColor())) {
                color = elementStyleForGroup.getColor();
            } else if (elementStyleForAllGroups != null && !StringUtils.isNullOrEmpty((String)elementStyleForAllGroups.getColor())) {
                color = elementStyleForAllGroups.getColor();
            }
            if (elementStyleForGroup != null && this.elementStyleHasSupportedIcon(elementStyleForGroup)) {
                icon = elementStyleForGroup.getIcon();
            } else if (elementStyleForAllGroups != null && this.elementStyleHasSupportedIcon(elementStyleForAllGroups)) {
                icon = elementStyleForAllGroups.getColor();
            }
            if (!StringUtils.isNullOrEmpty((String)icon)) {
                double scale = this.calculateIconScale((String)icon);
                icon = "\\n\\n<img:" + (String)icon + "{scale=" + scale + "}>";
            }
            writer.writeLine(String.format("rectangle \"%s%s\" <<group%s>> {", groupName, icon, this.groupId));
            writer.indent();
            writer.writeLine(String.format("skinparam RectangleBorderColor<<group%s>> %s", this.groupId, color));
            writer.writeLine(String.format("skinparam RectangleFontColor<<group%s>> %s", this.groupId, color));
            writer.writeLine(String.format("skinparam RectangleBorderStyle<<group%s>> dashed", this.groupId));
            writer.writeLine();
        }
    }

    @Override
    protected void endGroupBoundary(ModelView view, IndentingWriter writer) {
        if (!this.renderAsSequenceDiagram(view)) {
            writer.outdent();
            writer.writeLine("}");
            writer.writeLine();
        }
    }

    @Override
    protected void startSoftwareSystemBoundary(ModelView view, SoftwareSystem softwareSystem, IndentingWriter writer) {
        if (!this.renderAsSequenceDiagram(view)) {
            writer.writeLine(String.format("rectangle \"%s\\n<size:10>%s</size>\" <<%s>> {", softwareSystem.getName(), this.typeOf(view, (Element)softwareSystem, true), this.idOf((ModelItem)softwareSystem)));
            writer.indent();
        }
    }

    @Override
    protected void endSoftwareSystemBoundary(ModelView view, IndentingWriter writer) {
        if (!this.renderAsSequenceDiagram(view)) {
            writer.outdent();
            writer.writeLine("}");
            writer.writeLine();
        }
    }

    @Override
    protected void startContainerBoundary(ModelView view, Container container, IndentingWriter writer) {
        if (!this.renderAsSequenceDiagram(view)) {
            writer.writeLine(String.format("rectangle \"%s\\n<size:10>%s</size>\" <<%s>> {", container.getName(), this.typeOf(view, (Element)container, true), this.idOf((ModelItem)container)));
            writer.indent();
        }
    }

    @Override
    protected void endContainerBoundary(ModelView view, IndentingWriter writer) {
        if (!this.renderAsSequenceDiagram(view)) {
            writer.outdent();
            writer.writeLine("}");
            writer.writeLine();
        }
    }

    @Override
    protected void startDeploymentNodeBoundary(DeploymentView view, DeploymentNode deploymentNode, IndentingWriter writer) {
        Object url;
        ElementStyle elementStyle = this.findElementStyle((ModelView)view, (Element)deploymentNode);
        Object icon = "";
        if (this.elementStyleHasSupportedIcon(elementStyle)) {
            double scale = this.calculateIconScale(elementStyle.getIcon());
            icon = "\\n\\n<img:" + elementStyle.getIcon() + "{scale=" + scale + "}>";
        }
        url = !StringUtils.isNullOrEmpty((String)(url = deploymentNode.getUrl())) ? " [[" + (String)url + "]]" : "";
        writer.writeLine(String.format("rectangle \"%s\\n<size:10>%s</size>%s\" <<%s>> as %s%s {", deploymentNode.getName() + (String)(!"1".equals(deploymentNode.getInstances()) ? " (x" + deploymentNode.getInstances() + ")" : ""), this.typeOf((ModelView)view, (Element)deploymentNode, true), icon, this.idOf((ModelItem)deploymentNode), this.idOf((ModelItem)deploymentNode), url));
        writer.indent();
        if (!this.isVisible((ModelView)view, (Element)deploymentNode)) {
            writer.writeLine("hide " + this.idOf((ModelItem)deploymentNode));
        }
    }

    @Override
    protected void endDeploymentNodeBoundary(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    @Override
    public Diagram export(DynamicView view) {
        if (this.renderAsSequenceDiagram((ModelView)view)) {
            IndentingWriter writer = new IndentingWriter();
            this.writeHeader((ModelView)view, writer);
            LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
            for (RelationshipView relationshipView : view.getRelationships()) {
                elements.add(relationshipView.getRelationship().getSource());
                elements.add(relationshipView.getRelationship().getDestination());
            }
            for (Element element : elements) {
                this.writeElement((ModelView)view, element, writer);
            }
            this.writeRelationships((ModelView)view, writer);
            this.writeFooter((ModelView)view, writer);
            return this.createDiagram((ModelView)view, writer.toString());
        }
        return super.export(view);
    }

    @Override
    protected void writeElement(ModelView view, Element element, IndentingWriter writer) {
        ElementStyle elementStyle = this.findElementStyle(view, element);
        if (view instanceof DynamicView && this.renderAsSequenceDiagram(view)) {
            writer.writeLine(String.format("%s \"%s\\n<size:10>%s</size>\" as %s <<%s>> %s", this.plantumlSequenceType(view, element), element.getName(), this.typeOf(view, element, true), this.idOf((ModelItem)element), this.idOf((ModelItem)element), elementStyle.getBackground()));
        } else {
            String shape = this.plantUMLShapeOf(view, element);
            if ("actor".equals(shape)) {
                shape = "rectangle";
            }
            String name = element.getName();
            Object description = element.getDescription();
            String type = this.typeOf(view, element, true);
            Object icon = "";
            Object url = element.getUrl();
            url = !StringUtils.isNullOrEmpty((String)url) ? " [[" + (String)url + "]]" : "";
            if (element instanceof StaticStructureElementInstance) {
                StaticStructureElementInstance elementInstance = (StaticStructureElementInstance)element;
                name = elementInstance.getElement().getName();
                description = elementInstance.getElement().getDescription();
                type = this.typeOf(view, (Element)elementInstance.getElement(), true);
                shape = this.plantUMLShapeOf(view, (Element)elementInstance.getElement());
                if (StringUtils.isNullOrEmpty((String)url)) {
                    url = element.getUrl();
                    url = !StringUtils.isNullOrEmpty((String)url) ? " [[" + (String)url + "]]" : "";
                }
            }
            description = StringUtils.isNullOrEmpty((String)description) || false == elementStyle.getDescription() ? "" : "\\n\\n" + (String)description;
            type = StringUtils.isNullOrEmpty((String)type) || false == elementStyle.getMetadata() ? "" : String.format("\\n<size:10>%s</size>", type);
            if (this.elementStyleHasSupportedIcon(elementStyle)) {
                double scale = this.calculateIconScale(elementStyle.getIcon());
                icon = "\\n\\n<img:" + elementStyle.getIcon() + "{scale=" + scale + "}>";
            }
            String id = this.idOf((ModelItem)element);
            writer.writeLine(String.format("%s \"==%s%s%s%s\" <<%s>> as %s%s", shape, name, type, description, icon, id, id, url));
            if (!this.isVisible(view, element)) {
                writer.writeLine("hide " + id);
            }
        }
    }

    @Override
    protected void writeRelationship(ModelView view, RelationshipView relationshipView, IndentingWriter writer) {
        Relationship relationship = relationshipView.getRelationship();
        RelationshipStyle style = this.findRelationshipStyle(view, relationship);
        Object description = "";
        String technology = relationship.getTechnology();
        if (!(view instanceof DynamicView && this.renderAsSequenceDiagram(view) || StringUtils.isNullOrEmpty((String)relationshipView.getOrder()))) {
            description = relationshipView.getOrder() + ". ";
        }
        description = (String)description + (this.hasValue(relationshipView.getDescription()) ? relationshipView.getDescription() : (this.hasValue(relationshipView.getRelationship().getDescription()) ? relationshipView.getRelationship().getDescription() : ""));
        if (view instanceof DynamicView && this.renderAsSequenceDiagram(view)) {
            String arrowStart = "-";
            String arrowEnd = ">";
            if (relationshipView.isResponse() != null && relationshipView.isResponse().booleanValue()) {
                arrowStart = "<-";
                arrowEnd = "-";
            }
            writer.writeLine(String.format("%s %s[%s]%s %s : %s", this.idOf((ModelItem)relationship.getSource()), arrowStart, style.getColor(), arrowEnd, this.idOf((ModelItem)relationship.getDestination()), description));
        } else {
            String arrowEnd;
            String arrowStart;
            boolean solid = style.getStyle() == LineStyle.Solid || false == style.getDashed();
            Object relationshipStyle = style.getColor();
            if (style.getThickness() != null) {
                relationshipStyle = (String)relationshipStyle + ",thickness=" + style.getThickness();
            }
            if (relationshipView.isResponse() != null && relationshipView.isResponse().booleanValue()) {
                arrowStart = solid ? "<-" : "<.";
                arrowEnd = solid ? "-" : ".";
            } else {
                arrowStart = solid ? "-" : ".";
                String string = arrowEnd = solid ? "->" : ".>";
            }
            if (!this.isVisible(view, relationshipView)) {
                relationshipStyle = "hidden";
            }
            writer.writeLine(String.format("%s %s[%s]%s %s : \"<color:%s>%s%s\"", this.idOf((ModelItem)relationship.getSource()), arrowStart, relationshipStyle, arrowEnd, this.idOf((ModelItem)relationship.getDestination()), style.getColor(), description, StringUtils.isNullOrEmpty((String)technology) ? "" : "\\n<color:" + style.getColor() + "><size:8>[" + technology + "]</size>"));
        }
    }

    @Override
    protected Legend createLegend(ModelView view) {
        String fontName;
        IndentingWriter writer = new IndentingWriter();
        int id = 0;
        writer.writeLine("@startuml");
        writer.writeLine("set separator none");
        writer.writeLine();
        writer.writeLine("skinparam {");
        writer.indent();
        writer.writeLine("shadowing false");
        writer.writeLine("arrowFontSize 15");
        writer.writeLine("defaultTextAlignment center");
        writer.writeLine("wrapWidth 100");
        writer.writeLine("maxMessageSize 100");
        Font font = view.getViewSet().getConfiguration().getBranding().getFont();
        if (font != null && !StringUtils.isNullOrEmpty((String)(fontName = font.getName()))) {
            writer.writeLine("defaultFontName \"" + fontName + "\"");
        }
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine("hide stereotype");
        writer.writeLine();
        writer.writeLine("skinparam rectangle<<_transparent>> {");
        writer.indent();
        writer.writeLine("BorderColor transparent");
        writer.writeLine("BackgroundColor transparent");
        writer.writeLine("FontColor transparent");
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
        HashMap<String, ElementStyle> elementStyles = new HashMap<String, ElementStyle>();
        List elements = view.getElements().stream().map(ElementView::getElement).collect(Collectors.toList());
        for (Object element : elements) {
            ElementStyle elementStyle = this.findElementStyle(view, (Element)element);
            if (element instanceof DeploymentNode) {
                elementStyle.setBackground("#ffffff");
            }
            if (StringUtils.isNullOrEmpty((String)elementStyle.getTag())) continue;
            elementStyles.put(elementStyle.getTag(), elementStyle);
        }
        List sortedElementStyles = elementStyles.values().stream().sorted(Comparator.comparing(ElementStyle::getTag)).collect(Collectors.toList());
        for (ElementStyle elementStyle : sortedElementStyles) {
            ++id;
            Shape shape = elementStyle.getShape();
            String type = this.plantUMLShapeOf(elementStyle.getShape());
            if ("actor".equals(type)) {
                type = "rectangle";
            }
            String background = elementStyle.getBackground();
            String stroke = elementStyle.getStroke();
            String color = elementStyle.getColor();
            if (view instanceof DynamicView && this.renderAsSequenceDiagram(view)) {
                type = "sequenceParticipant";
            }
            writer.writeLine(String.format("skinparam %s<<%s>> {", type, id));
            writer.indent();
            writer.writeLine(String.format("BackgroundColor %s", background));
            writer.writeLine(String.format("FontColor %s", color));
            writer.writeLine(String.format("BorderColor %s", stroke));
            if (shape == Shape.RoundedBox) {
                writer.writeLine("roundCorner 20");
            }
            writer.outdent();
            writer.writeLine("}");
            String description = elementStyle.getTag();
            if (description.startsWith("Element,")) {
                description = description.substring("Element,".length());
            }
            description = description.replaceAll(",", ", ");
            Object icon = "";
            if (this.elementStyleHasSupportedIcon(elementStyle)) {
                double scale = this.calculateIconScale(elementStyle.getIcon());
                icon = "\\n\\n<img:" + elementStyle.getIcon() + "{scale=" + scale + "}>";
            }
            writer.writeLine(String.format("%s \"==%s%s\" <<%s>>", type, description, icon, id));
            writer.writeLine();
        }
        HashMap<String, RelationshipStyle> relationshipStyles = new HashMap<String, RelationshipStyle>();
        List relationships = view.getRelationships().stream().map(RelationshipView::getRelationship).collect(Collectors.toList());
        for (Relationship relationship : relationships) {
            RelationshipStyle relationshipStyle = this.findRelationshipStyle(view, relationship);
            if (StringUtils.isNullOrEmpty((String)relationshipStyle.getTag())) continue;
            relationshipStyles.put(relationshipStyle.getTag(), relationshipStyle);
        }
        List sortedRelationshipStyles = relationshipStyles.values().stream().sorted(Comparator.comparing(RelationshipStyle::getTag)).collect(Collectors.toList());
        for (RelationshipStyle relationshipStyle : sortedRelationshipStyles) {
            ++id;
            String description = relationshipStyle.getTag();
            if (description.startsWith("Relationship,")) {
                description = description.substring("Relationship,".length());
            }
            description = description.replaceAll(",", ", ");
            writer.writeLine(String.format("rectangle \".\" <<_transparent>> as %s", id));
            boolean solid = relationshipStyle.getStyle() == LineStyle.Solid || false == relationshipStyle.getDashed();
            String arrowStart = solid ? "-" : ".";
            String arrowEnd = solid ? "->" : ".>";
            Object buf = relationshipStyle.getColor();
            if (relationshipStyle.getThickness() != null) {
                buf = (String)buf + ",thickness=" + relationshipStyle.getThickness();
            }
            writer.writeLine(String.format("%s %s[%s]%s %s : \"<color:%s>%s\"", id, arrowStart, buf, arrowEnd, id, relationshipStyle.getColor(), description));
            writer.writeLine();
        }
        writer.writeLine();
        writer.writeLine("@enduml");
        return new Legend(writer.toString());
    }

    protected boolean renderAsSequenceDiagram(ModelView view) {
        return view instanceof DynamicView && "true".equalsIgnoreCase(this.getViewOrViewSetProperty(view, PLANTUML_SEQUENCE_DIAGRAM_PROPERTY, "false"));
    }
}

