/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.io;

import com.structurizr.Workspace;
import com.structurizr.io.AbstractExporter;
import com.structurizr.io.Diagram;
import com.structurizr.io.IndentingWriter;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.CustomElement;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.GroupableElement;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.Location;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Person;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.model.StaticStructureElement;
import com.structurizr.model.StaticStructureElementInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.Animation;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.StaticView;
import com.structurizr.view.SystemContextView;
import com.structurizr.view.SystemLandscapeView;
import com.structurizr.view.View;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractDiagramExporter
extends AbstractExporter {
    private Object frame = null;

    public final Collection<Diagram> export(Workspace workspace) {
        Diagram diagram;
        if (workspace == null) {
            throw new IllegalArgumentException("A workspace must be provided.");
        }
        ArrayList<Diagram> diagrams = new ArrayList<Diagram>();
        for (SystemLandscapeView view : workspace.getViews().getSystemLandscapeViews()) {
            diagram = this.export(view);
            if (diagram == null) continue;
            diagrams.add(diagram);
        }
        for (SystemLandscapeView view : workspace.getViews().getSystemContextViews()) {
            diagram = this.export((SystemContextView)view);
            if (diagram == null) continue;
            diagrams.add(diagram);
        }
        for (SystemLandscapeView view : workspace.getViews().getContainerViews()) {
            diagram = this.export((ContainerView)view);
            if (diagram == null) continue;
            diagrams.add(diagram);
        }
        for (SystemLandscapeView view : workspace.getViews().getComponentViews()) {
            diagram = this.export((ComponentView)view);
            if (diagram == null) continue;
            diagrams.add(diagram);
        }
        for (SystemLandscapeView view : workspace.getViews().getDynamicViews()) {
            diagram = this.export((DynamicView)view);
            if (diagram == null) continue;
            diagrams.add(diagram);
        }
        for (SystemLandscapeView view : workspace.getViews().getDeploymentViews()) {
            diagram = this.export((DeploymentView)view);
            if (diagram == null) continue;
            diagrams.add(diagram);
        }
        return diagrams;
    }

    public Diagram export(SystemLandscapeView view) {
        Diagram diagram = this.export(view, null);
        if (this.isAnimationSupported((View)view) && !view.getAnimations().isEmpty()) {
            for (Animation animation : view.getAnimations()) {
                Diagram frame = this.export(view, (Integer)animation.getOrder());
                diagram.addFrame(frame);
            }
        }
        return diagram;
    }

    private Diagram export(SystemLandscapeView view, Integer animationStep) {
        this.frame = animationStep;
        return this.export((View)view, view.isEnterpriseBoundaryVisible());
    }

    public Diagram export(SystemContextView view) {
        Diagram diagram = this.export(view, null);
        if (this.isAnimationSupported((View)view) && !view.getAnimations().isEmpty()) {
            for (Animation animation : view.getAnimations()) {
                Diagram frame = this.export(view, (Integer)animation.getOrder());
                diagram.addFrame(frame);
            }
        }
        return diagram;
    }

    private Diagram export(SystemContextView view, Integer animationStep) {
        this.frame = animationStep;
        return this.export((View)view, view.isEnterpriseBoundaryVisible());
    }

    private Diagram export(View view, boolean enterpriseBoundaryIsVisible) {
        boolean showEnterpriseBoundary;
        IndentingWriter writer = new IndentingWriter();
        this.writeHeader(view, writer);
        boolean bl = showEnterpriseBoundary = enterpriseBoundaryIsVisible && (view.getElements().stream().map(ElementView::getElement).anyMatch(e -> e instanceof Person && ((Person)e).getLocation() == Location.Internal) || view.getElements().stream().map(ElementView::getElement).anyMatch(e -> e instanceof SoftwareSystem && ((SoftwareSystem)e).getLocation() == Location.Internal));
        if (showEnterpriseBoundary) {
            String enterpriseName = "Enterprise";
            if (view.getModel().getEnterprise() != null) {
                enterpriseName = view.getModel().getEnterprise().getName();
            }
            this.startEnterpriseBoundary(enterpriseName, writer);
            ArrayList<GroupableElement> elementsInsideEnterpriseBoundary = new ArrayList<GroupableElement>();
            for (ElementView elementView : view.getElements()) {
                if (elementView.getElement() instanceof Person && ((Person)elementView.getElement()).getLocation() == Location.Internal) {
                    elementsInsideEnterpriseBoundary.add((GroupableElement)((StaticStructureElement)elementView.getElement()));
                }
                if (!(elementView.getElement() instanceof SoftwareSystem) || ((SoftwareSystem)elementView.getElement()).getLocation() != Location.Internal) continue;
                elementsInsideEnterpriseBoundary.add((GroupableElement)((StaticStructureElement)elementView.getElement()));
            }
            this.writeElements(view, elementsInsideEnterpriseBoundary, writer);
            this.endEnterpriseBoundary(writer);
            ArrayList<GroupableElement> elementsOutsideEnterpriseBoundary = new ArrayList<GroupableElement>();
            for (ElementView elementView : view.getElements()) {
                if (elementView.getElement() instanceof Person && ((Person)elementView.getElement()).getLocation() != Location.Internal) {
                    elementsOutsideEnterpriseBoundary.add((GroupableElement)((StaticStructureElement)elementView.getElement()));
                }
                if (elementView.getElement() instanceof SoftwareSystem && ((SoftwareSystem)elementView.getElement()).getLocation() != Location.Internal) {
                    elementsOutsideEnterpriseBoundary.add((GroupableElement)((StaticStructureElement)elementView.getElement()));
                }
                if (!(elementView.getElement() instanceof CustomElement)) continue;
                elementsOutsideEnterpriseBoundary.add((GroupableElement)((CustomElement)elementView.getElement()));
            }
            this.writeElements(view, elementsOutsideEnterpriseBoundary, writer);
        } else {
            ArrayList<GroupableElement> elements = new ArrayList<GroupableElement>();
            for (ElementView elementView : view.getElements()) {
                elements.add((GroupableElement)elementView.getElement());
            }
            this.writeElements(view, elements, writer);
        }
        writer.writeLine();
        this.writeRelationships(view, writer);
        this.writeFooter(view, writer);
        return new Diagram(view, writer.toString());
    }

    public Diagram export(ContainerView view) {
        Diagram diagram = this.export(view, null);
        if (this.isAnimationSupported((View)view) && !view.getAnimations().isEmpty()) {
            for (Animation animation : view.getAnimations()) {
                Diagram frame = this.export(view, (Integer)animation.getOrder());
                diagram.addFrame(frame);
            }
        }
        return diagram;
    }

    public Diagram export(ContainerView view, Integer animationStep) {
        this.frame = animationStep;
        IndentingWriter writer = new IndentingWriter();
        this.writeHeader((View)view, writer);
        boolean elementsWritten = false;
        for (ElementView elementView : view.getElements()) {
            if (elementView.getElement() instanceof Container) continue;
            this.writeElement((View)view, elementView.getElement(), writer);
            elementsWritten = true;
        }
        if (elementsWritten) {
            writer.writeLine();
        }
        ArrayList<SoftwareSystem> softwareSystems = new ArrayList<SoftwareSystem>(view.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof Container).map(c -> ((Container)c).getSoftwareSystem()).collect(Collectors.toSet()));
        softwareSystems.sort(Comparator.comparing(ModelItem::getId));
        for (SoftwareSystem softwareSystem : softwareSystems) {
            boolean showSoftwareSystemBoundary;
            boolean bl = showSoftwareSystemBoundary = softwareSystem.equals(view.getSoftwareSystem()) || view.getExternalSoftwareSystemBoundariesVisible();
            if (showSoftwareSystemBoundary) {
                this.startSoftwareSystemBoundary((View)view, softwareSystem, writer);
            }
            ArrayList<GroupableElement> scopedElements = new ArrayList<GroupableElement>();
            for (ElementView elementView : view.getElements()) {
                if (elementView.getElement().getParent() != softwareSystem) continue;
                scopedElements.add((GroupableElement)((StaticStructureElement)elementView.getElement()));
            }
            this.writeElements((View)view, scopedElements, writer);
            if (showSoftwareSystemBoundary) {
                this.endSoftwareSystemBoundary(writer);
                continue;
            }
            writer.writeLine();
        }
        this.writeRelationships((View)view, writer);
        this.writeFooter((View)view, writer);
        return new Diagram((View)view, writer.toString());
    }

    public Diagram export(ComponentView view) {
        Diagram diagram = this.export(view, null);
        if (this.isAnimationSupported((View)view) && !view.getAnimations().isEmpty()) {
            for (Animation animation : view.getAnimations()) {
                Diagram frame = this.export(view, (Integer)animation.getOrder());
                diagram.addFrame(frame);
            }
        }
        return diagram;
    }

    public Diagram export(ComponentView view, Integer animationStep) {
        this.frame = animationStep;
        IndentingWriter writer = new IndentingWriter();
        this.writeHeader((View)view, writer);
        boolean elementsWritten = false;
        for (ElementView elementView : view.getElements()) {
            if (elementView.getElement() instanceof Component) continue;
            this.writeElement((View)view, elementView.getElement(), writer);
            elementsWritten = true;
        }
        if (elementsWritten) {
            writer.writeLine();
        }
        ArrayList<Container> containers = new ArrayList<Container>(view.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof Component).map(c -> ((Component)c).getContainer()).collect(Collectors.toSet()));
        containers.sort(Comparator.comparing(ModelItem::getId));
        for (Container container : containers) {
            boolean showContainerBoundary;
            boolean bl = showContainerBoundary = container.equals(view.getContainer()) || view.getExternalContainerBoundariesVisible();
            if (showContainerBoundary) {
                this.startContainerBoundary((View)view, container, writer);
            }
            ArrayList<GroupableElement> scopedElements = new ArrayList<GroupableElement>();
            for (ElementView elementView : view.getElements()) {
                if (elementView.getElement().getParent() != container) continue;
                scopedElements.add((GroupableElement)((StaticStructureElement)elementView.getElement()));
            }
            this.writeElements((View)view, scopedElements, writer);
            if (showContainerBoundary) {
                this.endContainerBoundary(writer);
                continue;
            }
            writer.writeLine();
        }
        this.writeRelationships((View)view, writer);
        this.writeFooter((View)view, writer);
        return new Diagram((View)view, writer.toString());
    }

    public Diagram export(DynamicView view) {
        Diagram diagram = this.export(view, null);
        if (this.isAnimationSupported((View)view)) {
            LinkedHashSet<String> orders = new LinkedHashSet<String>();
            for (RelationshipView relationshipView : view.getRelationships()) {
                orders.add(relationshipView.getOrder());
            }
            for (String order : orders) {
                Diagram frame = this.export(view, order);
                diagram.addFrame(frame);
            }
        }
        return diagram;
    }

    public Diagram export(DynamicView view, String order) {
        this.frame = order;
        IndentingWriter writer = new IndentingWriter();
        this.writeHeader((View)view, writer);
        boolean elementsWritten = false;
        Element element = view.getElement();
        if (element == null) {
            for (ElementView elementView : view.getElements()) {
                this.writeElement((View)view, elementView.getElement(), writer);
                elementsWritten = true;
            }
        } else if (element instanceof SoftwareSystem) {
            ArrayList<SoftwareSystem> softwareSystems = new ArrayList<SoftwareSystem>(view.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof Container).map(c -> ((Container)c).getSoftwareSystem()).collect(Collectors.toSet()));
            softwareSystems.sort(Comparator.comparing(ModelItem::getId));
            for (SoftwareSystem softwareSystem : softwareSystems) {
                boolean showSoftwareSystemBoundary;
                boolean bl = showSoftwareSystemBoundary = softwareSystem.equals(view.getElement()) || view.getExternalBoundariesVisible();
                if (showSoftwareSystemBoundary) {
                    this.startSoftwareSystemBoundary((View)view, softwareSystem, writer);
                }
                for (ElementView elementView : view.getElements()) {
                    if (elementView.getElement().getParent() != softwareSystem) continue;
                    this.writeElement((View)view, elementView.getElement(), writer);
                }
                if (showSoftwareSystemBoundary) {
                    this.endSoftwareSystemBoundary(writer);
                    continue;
                }
                writer.writeLine();
            }
            for (ElementView elementView : view.getElements()) {
                if (elementView.getElement().getParent() != null) continue;
                this.writeElement((View)view, elementView.getElement(), writer);
                elementsWritten = true;
            }
        } else if (element instanceof Container) {
            ArrayList<Container> containers = new ArrayList<Container>(view.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof Component).map(c -> ((Component)c).getContainer()).collect(Collectors.toSet()));
            containers.sort(Comparator.comparing(ModelItem::getId));
            for (Container container : containers) {
                boolean showContainerBoundary;
                boolean bl = showContainerBoundary = container.equals(view.getElement()) || view.getExternalBoundariesVisible();
                if (showContainerBoundary) {
                    this.startContainerBoundary((View)view, container, writer);
                }
                for (ElementView elementView : view.getElements()) {
                    if (elementView.getElement().getParent() != container) continue;
                    this.writeElement((View)view, elementView.getElement(), writer);
                }
                if (showContainerBoundary) {
                    this.endContainerBoundary(writer);
                    continue;
                }
                writer.writeLine();
            }
            for (ElementView elementView : view.getElements()) {
                if (elementView.getElement().getParent() instanceof Container) continue;
                this.writeElement((View)view, elementView.getElement(), writer);
                elementsWritten = true;
            }
        }
        if (elementsWritten) {
            writer.writeLine();
        }
        this.writeRelationships((View)view, writer);
        this.writeFooter((View)view, writer);
        return new Diagram((View)view, writer.toString());
    }

    public Diagram export(DeploymentView view) {
        Diagram diagram = this.export(view, null);
        if (this.isAnimationSupported((View)view) && !view.getAnimations().isEmpty()) {
            for (Animation animation : view.getAnimations()) {
                Diagram frame = this.export(view, (Integer)animation.getOrder());
                diagram.addFrame(frame);
            }
        }
        return diagram;
    }

    public Diagram export(DeploymentView view, Integer animationStep) {
        this.frame = animationStep;
        IndentingWriter writer = new IndentingWriter();
        this.writeHeader((View)view, writer);
        for (ElementView elementView : view.getElements()) {
            if (!(elementView.getElement() instanceof DeploymentNode) || elementView.getElement().getParent() != null) continue;
            this.write(view, (DeploymentNode)elementView.getElement(), writer);
        }
        this.writeRelationships((View)view, writer);
        this.writeFooter((View)view, writer);
        return new Diagram((View)view, writer.toString());
    }

    private void write(DeploymentView view, DeploymentNode deploymentNode, IndentingWriter writer) {
        this.startDeploymentNodeBoundary(view, deploymentNode, writer);
        ArrayList<DeploymentNode> children = new ArrayList<DeploymentNode>(deploymentNode.getChildren());
        children.sort(Comparator.comparing(Element::getName));
        for (DeploymentNode deploymentNode2 : children) {
            if (!view.isElementInView((Element)deploymentNode2)) continue;
            this.write(view, deploymentNode2, writer);
        }
        ArrayList<InfrastructureNode> infrastructureNodes = new ArrayList<InfrastructureNode>(deploymentNode.getInfrastructureNodes());
        infrastructureNodes.sort(Comparator.comparing(Element::getName));
        for (InfrastructureNode infrastructureNode : infrastructureNodes) {
            if (!view.isElementInView((Element)infrastructureNode)) continue;
            this.writeElement((View)view, (Element)infrastructureNode, writer);
        }
        ArrayList<SoftwareSystemInstance> arrayList = new ArrayList<SoftwareSystemInstance>(deploymentNode.getSoftwareSystemInstances());
        arrayList.sort(Comparator.comparing(StaticStructureElementInstance::getName));
        for (SoftwareSystemInstance softwareSystemInstance : arrayList) {
            if (!view.isElementInView((Element)softwareSystemInstance)) continue;
            this.writeElement((View)view, (Element)softwareSystemInstance, writer);
        }
        ArrayList<ContainerInstance> arrayList2 = new ArrayList<ContainerInstance>(deploymentNode.getContainerInstances());
        arrayList2.sort(Comparator.comparing(StaticStructureElementInstance::getName));
        for (ContainerInstance containerInstance : arrayList2) {
            if (!view.isElementInView((Element)containerInstance)) continue;
            this.writeElement((View)view, (Element)containerInstance, writer);
        }
        this.endDeploymentNodeBoundary(writer);
    }

    protected void writeElements(View view, List<GroupableElement> elements, IndentingWriter writer) {
        elements.sort(Comparator.comparing(ModelItem::getId));
        HashSet<String> groupsAsSet = new HashSet<String>();
        for (GroupableElement element : elements) {
            String group = element.getGroup();
            if (StringUtils.isNullOrEmpty((String)group)) continue;
            groupsAsSet.add(group);
        }
        ArrayList groupsAsList = new ArrayList(groupsAsSet);
        Collections.sort(groupsAsList);
        for (String group : groupsAsList) {
            this.startGroupBoundary(view, group, writer);
            for (GroupableElement element : elements) {
                if (!group.equals(element.getGroup())) continue;
                this.writeElement(view, (Element)element, writer);
            }
            this.endGroupBoundary(writer);
        }
        for (GroupableElement element : elements) {
            if (!StringUtils.isNullOrEmpty((String)element.getGroup())) continue;
            this.writeElement(view, (Element)element, writer);
        }
    }

    protected void writeRelationships(View view, IndentingWriter writer) {
        Collection relationshipList = view instanceof DynamicView ? view.getRelationships() : (Collection)view.getRelationships().stream().sorted(Comparator.comparing(rv -> rv.getRelationship().getId())).collect(Collectors.toList());
        for (RelationshipView relationshipView : relationshipList) {
            this.writeRelationship(view, relationshipView, writer);
        }
    }

    protected abstract void writeHeader(View var1, IndentingWriter var2);

    protected abstract void writeFooter(View var1, IndentingWriter var2);

    protected abstract void startEnterpriseBoundary(String var1, IndentingWriter var2);

    protected abstract void endEnterpriseBoundary(IndentingWriter var1);

    protected abstract void startGroupBoundary(View var1, String var2, IndentingWriter var3);

    protected abstract void endGroupBoundary(IndentingWriter var1);

    protected abstract void startSoftwareSystemBoundary(View var1, SoftwareSystem var2, IndentingWriter var3);

    protected abstract void endSoftwareSystemBoundary(IndentingWriter var1);

    protected abstract void startContainerBoundary(View var1, Container var2, IndentingWriter var3);

    protected abstract void endContainerBoundary(IndentingWriter var1);

    protected abstract void startDeploymentNodeBoundary(DeploymentView var1, DeploymentNode var2, IndentingWriter var3);

    protected abstract void endDeploymentNodeBoundary(IndentingWriter var1);

    protected abstract void writeElement(View var1, Element var2, IndentingWriter var3);

    protected abstract void writeRelationship(View var1, RelationshipView var2, IndentingWriter var3);

    protected boolean isAnimationSupported(View view) {
        return false;
    }

    protected boolean isVisible(View view, Element element) {
        if (this.frame != null) {
            HashSet elementIds = new HashSet();
            if (view instanceof StaticView) {
                int step = (Integer)this.frame;
                if (step > 0) {
                    StaticView staticView = (StaticView)view;
                    staticView.getAnimations().stream().filter(a -> a.getOrder() <= step).forEach(a -> elementIds.addAll(a.getElements()));
                    return elementIds.contains(element.getId());
                }
            } else if (view instanceof DeploymentView) {
                int step = (Integer)this.frame;
                if (step > 0) {
                    DeploymentView deploymentView = (DeploymentView)view;
                    deploymentView.getAnimations().stream().filter(a -> a.getOrder() <= step).forEach(a -> elementIds.addAll(a.getElements()));
                    return elementIds.contains(element.getId());
                }
            } else if (view instanceof DynamicView) {
                String order = (String)this.frame;
                view.getRelationships().stream().filter(rv -> order.equals(rv.getOrder())).forEach(rv -> {
                    elementIds.add(rv.getRelationship().getSourceId());
                    elementIds.add(rv.getRelationship().getDestinationId());
                });
                return elementIds.contains(element.getId());
            }
        }
        return true;
    }

    protected boolean isVisible(View view, RelationshipView relationshipView) {
        if (view instanceof DynamicView && this.frame != null) {
            return this.frame.equals(relationshipView.getOrder());
        }
        return true;
    }
}

