/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.io;

import com.structurizr.io.IndentType;

public final class IndentingWriter {
    private int indent = 0;
    private IndentType indentType = IndentType.Spaces;
    private int indentQuantity = 2;
    private StringBuilder buf = new StringBuilder();

    public void setIndentType(IndentType indentType) {
        this.indentType = indentType;
    }

    public void setIndentQuantity(int indentQuantity) {
        this.indentQuantity = indentQuantity;
    }

    public void indent() {
        ++this.indent;
    }

    public void outdent() {
        --this.indent;
    }

    private String padding() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.indent * this.indentQuantity; ++i) {
            if (this.indentType == IndentType.Spaces) {
                buf.append(" ");
                continue;
            }
            buf.append("\t");
        }
        return buf.toString();
    }

    public void writeLine() {
        this.buf.append("\n");
    }

    public void writeLine(String content) {
        this.buf.append(String.format("%s%s\n", this.padding(), content));
    }

    public String toString() {
        return this.buf.toString();
    }
}

