/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.io.mermaid;

import com.structurizr.io.AbstractDiagramExporter;
import com.structurizr.io.IndentingWriter;
import com.structurizr.model.Container;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.StaticStructureElement;
import com.structurizr.model.StaticStructureElementInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ComponentView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.Shape;
import com.structurizr.view.View;

public class MermaidDiagramExporter
extends AbstractDiagramExporter {
    private int groupId = 0;

    @Override
    protected void writeHeader(View view, IndentingWriter writer) {
        String direction = "TB";
        if (view.getAutomaticLayout() != null) {
            switch (view.getAutomaticLayout().getRankDirection()) {
                case TopBottom: {
                    direction = "TB";
                    break;
                }
                case BottomTop: {
                    direction = "BT";
                    break;
                }
                case LeftRight: {
                    direction = "LR";
                    break;
                }
                case RightLeft: {
                    direction = "RL";
                }
            }
        }
        writer.writeLine("graph " + direction);
        writer.indent();
        writer.writeLine("linkStyle default fill:#ffffff");
        writer.writeLine();
    }

    @Override
    protected void writeFooter(View view, IndentingWriter writer) {
        writer.outdent();
    }

    @Override
    protected void startEnterpriseBoundary(String enterpriseName, IndentingWriter writer) {
        writer.writeLine("subgraph enterprise [" + enterpriseName + "]");
        writer.indent();
        writer.writeLine("style enterprise fill:#ffffff,stroke:#444444,color:#444444");
        writer.writeLine();
    }

    @Override
    protected void endEnterpriseBoundary(IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("end");
        writer.writeLine();
    }

    @Override
    protected void startGroupBoundary(View view, String group, IndentingWriter writer) {
        ++this.groupId;
        String color = "#cccccc";
        ElementStyle elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle("Group:" + group);
        if (elementStyle == null || StringUtils.isNullOrEmpty((String)elementStyle.getColor())) {
            elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle("Group");
        }
        if (elementStyle != null && !StringUtils.isNullOrEmpty((String)elementStyle.getColor())) {
            color = elementStyle.getColor();
        }
        writer.writeLine(String.format("subgraph group%s [" + group + "]", this.groupId));
        writer.indent();
        writer.writeLine(String.format("style group%s fill:#ffffff,stroke:%s,color:%s", this.groupId, color, color));
        writer.writeLine();
    }

    @Override
    protected void endGroupBoundary(IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("end");
        writer.writeLine();
    }

    @Override
    protected void startSoftwareSystemBoundary(View view, SoftwareSystem softwareSystem, IndentingWriter writer) {
        String color = softwareSystem.equals(view.getSoftwareSystem()) ? "#444444" : "#cccccc";
        writer.writeLine(String.format("subgraph %s [%s]", softwareSystem.getId(), softwareSystem.getName()));
        writer.indent();
        writer.writeLine(String.format("style %s fill:#ffffff,stroke:%s,color:%s", softwareSystem.getId(), color, color));
        writer.writeLine();
    }

    @Override
    protected void endSoftwareSystemBoundary(IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("end");
        writer.writeLine();
    }

    @Override
    protected void startContainerBoundary(View view, Container container, IndentingWriter writer) {
        String color = "#444444";
        if (view instanceof ComponentView) {
            color = container.equals(((ComponentView)view).getContainer()) ? "#444444" : "#cccccc";
        } else if (view instanceof DynamicView) {
            color = container.equals(((DynamicView)view).getElement()) ? "#444444" : "#cccccc";
        }
        writer.writeLine(String.format("subgraph %s [%s]", container.getId(), container.getName()));
        writer.indent();
        writer.writeLine(String.format("style %s fill:#ffffff,stroke:%s,color:%s", container.getId(), color, color));
        writer.writeLine();
    }

    @Override
    protected void endContainerBoundary(IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("end");
        writer.writeLine();
    }

    @Override
    protected void startDeploymentNodeBoundary(DeploymentView view, DeploymentNode deploymentNode, IndentingWriter writer) {
        ElementStyle elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle((Element)deploymentNode);
        writer.writeLine(String.format("subgraph %s [%s]", deploymentNode.getId(), deploymentNode.getName()));
        writer.indent();
        writer.writeLine(String.format("style %s fill:#ffffff,stroke:%s,color:%s", deploymentNode.getId(), elementStyle.getStroke(), elementStyle.getColor()));
        writer.writeLine();
    }

    @Override
    protected void endDeploymentNodeBoundary(IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("end");
        writer.writeLine();
    }

    @Override
    protected void writeElement(View view, Element element, IndentingWriter writer) {
        ElementStyle elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle(element);
        String name = element.getName();
        String description = element.getDescription();
        String type = this.typeOf(view, element, true);
        if (element instanceof StaticStructureElementInstance) {
            StaticStructureElementInstance elementInstance = (StaticStructureElementInstance)element;
            name = elementInstance.getElement().getName();
            description = elementInstance.getElement().getDescription();
            type = this.typeOf(view, (Element)elementInstance.getElement(), true);
            elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle((Element)elementInstance.getElement());
        }
        String nodeOpeningSymbol = "[";
        String nodeClosingSymbol = "]";
        if (elementStyle.getShape() == Shape.RoundedBox) {
            nodeOpeningSymbol = "(";
            nodeClosingSymbol = ")";
        } else if (elementStyle.getShape() == Shape.Cylinder) {
            nodeOpeningSymbol = "[(";
            nodeClosingSymbol = ")]";
        }
        description = StringUtils.isNullOrEmpty((String)description) || false == elementStyle.getDescription() ? "" : String.format("<div style='font-size: 80%%; margin-top:10px'>%s</div>", this.lines(description));
        type = false == elementStyle.getMetadata() ? "" : String.format("<div style='font-size: 70%%; margin-top: 0px'>%s</div>", type);
        writer.writeLine(String.format("%s%s\"<div style='font-weight: bold'>%s</div>%s%s\"%s", element.getId(), nodeOpeningSymbol, name, type, description, nodeClosingSymbol));
        if (!StringUtils.isNullOrEmpty((String)element.getUrl())) {
            writer.writeLine(String.format("click %s %s \"%s\"", element.getId(), element.getUrl(), element.getUrl()));
        }
        if (element instanceof StaticStructureElementInstance) {
            StaticStructureElement e = ((StaticStructureElementInstance)element).getElement();
            writer.writeLine(String.format("style %s fill:%s,stroke:%s,color:%s", element.getId(), elementStyle.getBackground(), elementStyle.getStroke(), elementStyle.getColor()));
        } else {
            writer.writeLine(String.format("style %s fill:%s,stroke:%s,color:%s", element.getId(), elementStyle.getBackground(), elementStyle.getStroke(), elementStyle.getColor()));
        }
    }

    @Override
    protected void writeRelationship(View view, RelationshipView relationshipView, IndentingWriter writer) {
        String description;
        Relationship relationship = relationshipView.getRelationship();
        RelationshipStyle style = view.getViewSet().getConfiguration().getStyles().findRelationshipStyle(relationship);
        Element source = relationship.getSource();
        Element destination = relationship.getDestination();
        if (source instanceof DeploymentNode || destination instanceof DeploymentNode) {
            return;
        }
        if (relationshipView.isResponse() != null && relationshipView.isResponse().booleanValue()) {
            source = relationship.getDestination();
            destination = relationship.getSource();
        }
        if (style.getDashed() == null) {
            style.setDashed(Boolean.valueOf(true));
        }
        if (StringUtils.isNullOrEmpty((String)(description = relationshipView.getDescription()))) {
            description = relationshipView.getRelationship().getDescription();
        }
        if (!StringUtils.isNullOrEmpty((String)relationshipView.getOrder())) {
            description = relationshipView.getOrder() + ". " + description;
        }
        writer.writeLine(String.format("%s-%s \"<div>%s</div><div style='font-size: 70%%'>%s</div>\" %s->%s", source.getId(), style.getDashed() != false ? "." : "-", this.lines(description), !StringUtils.isNullOrEmpty((String)relationship.getTechnology()) ? "[" + relationship.getTechnology() + "]" : "", style.getDashed() != false ? "." : "-", destination.getId()));
    }

    private String lines(String text) {
        StringBuilder buf = new StringBuilder();
        if (text != null) {
            String[] words = text.trim().split("\\s+");
            StringBuilder line = new StringBuilder();
            for (String word : words) {
                if (line.length() == 0) {
                    line.append(word);
                    continue;
                }
                if (line.length() + word.length() + 1 < 30) {
                    line.append(' ').append(word);
                    continue;
                }
                buf.append(line.toString());
                buf.append("<br />");
                line.setLength(0);
                line.append(word);
            }
            if (line.length() > 0) {
                buf.append(line.toString());
            }
        }
        return buf.toString();
    }
}

