/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.io.plantuml;

import com.structurizr.io.AbstractDiagramExporter;
import com.structurizr.io.IndentingWriter;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Person;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.DynamicView;
import com.structurizr.view.Shape;
import com.structurizr.view.View;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractPlantUMLExporter
extends AbstractDiagramExporter {
    private final Map<String, String> skinParams = new LinkedHashMap<String, String>();
    private final List<String> includes = new ArrayList<String>();
    private boolean useSequenceDiagrams = false;
    private boolean includeTitle = true;

    public List<String> getIncludes() {
        return this.includes;
    }

    public void addIncludeFile(String file) {
        this.addIncludeFile(file, null);
    }

    public void addIncludeFile(String file, int id) {
        this.addIncludeFile(file, String.valueOf(id));
    }

    public void addIncludeFile(String file, String id) {
        if (id == null) {
            this.includes.add(String.format("!include %s", file));
        } else {
            this.includes.add(String.format("!include %s!%s", file, id));
        }
    }

    public void addIncludeURL(URI file) {
        this.addIncludeURL(file, null);
    }

    public void addIncludeURL(URI file, int id) {
        this.addIncludeURL(file, String.valueOf(id));
    }

    public void addIncludeURL(URI file, String id) {
        if (id == null) {
            this.includes.add(String.format("!includeurl %s", file));
        } else {
            this.includes.add(String.format("!includeurl %s!%s", file, id));
        }
    }

    public void clearIncludes() {
        this.includes.clear();
    }

    protected Map<String, String> getSkinParams() {
        return this.skinParams;
    }

    public void addSkinParam(String name, String value) {
        this.skinParams.put(name, value);
    }

    public void clearSkinParams() {
        this.skinParams.clear();
    }

    public boolean isUseSequenceDiagrams() {
        return this.useSequenceDiagrams;
    }

    public void setUseSequenceDiagrams(boolean useSequenceDiagrams) {
        this.useSequenceDiagrams = useSequenceDiagrams;
    }

    public boolean isIncludeTitle() {
        return this.includeTitle;
    }

    public void setIncludeTitle(boolean includeTitle) {
        this.includeTitle = includeTitle;
    }

    String plantUMLShapeOf(View view, Element element) {
        Shape shape = this.findElementStyle(view, element).getShape();
        if (element instanceof DeploymentNode) {
            return "node";
        }
        switch (shape) {
            case Person: 
            case Robot: {
                return "person";
            }
            case Component: {
                return "component";
            }
            case Cylinder: {
                return "database";
            }
            case Folder: {
                return "folder";
            }
            case Ellipse: 
            case Circle: {
                return "storage";
            }
            case Hexagon: {
                return "hexagon";
            }
            case Pipe: {
                return "queue";
            }
        }
        return "rectangle";
    }

    String plantumlSequenceType(View view, Element element) {
        Shape shape = this.findElementStyle(view, element).getShape();
        switch (shape) {
            case Box: {
                return "participant";
            }
            case Person: {
                return "actor";
            }
            case Cylinder: {
                return "database";
            }
            case Folder: {
                return "collections";
            }
            case Ellipse: 
            case Circle: {
                return "entity";
            }
        }
        return "participant";
    }

    String idOf(ModelItem modelItem) {
        if (modelItem instanceof Element) {
            Element element = (Element)modelItem;
            if (element.getParent() == null) {
                if (element instanceof DeploymentNode) {
                    DeploymentNode dn = (DeploymentNode)element;
                    return this.filter(dn.getEnvironment()) + "." + this.id(dn);
                }
                return this.id((ModelItem)element);
            }
            return this.idOf((ModelItem)element.getParent()) + "." + this.id(modelItem);
        }
        return this.id(modelItem);
    }

    private String id(ModelItem modelItem) {
        if (modelItem instanceof Person) {
            return this.id((Person)modelItem);
        }
        if (modelItem instanceof SoftwareSystem) {
            return this.id((SoftwareSystem)modelItem);
        }
        if (modelItem instanceof Container) {
            return this.id((Container)modelItem);
        }
        if (modelItem instanceof Component) {
            return this.id((Component)modelItem);
        }
        if (modelItem instanceof DeploymentNode) {
            return this.id((DeploymentNode)modelItem);
        }
        if (modelItem instanceof InfrastructureNode) {
            return this.id((InfrastructureNode)modelItem);
        }
        if (modelItem instanceof SoftwareSystemInstance) {
            return this.id((SoftwareSystemInstance)modelItem);
        }
        if (modelItem instanceof ContainerInstance) {
            return this.id((ContainerInstance)modelItem);
        }
        return modelItem.getId();
    }

    private String id(Person person) {
        return this.filter(person.getName());
    }

    private String id(SoftwareSystem softwareSystem) {
        return this.filter(softwareSystem.getName());
    }

    private String id(Container container) {
        return this.filter(container.getName());
    }

    private String id(Component component) {
        return this.filter(component.getName());
    }

    private String id(DeploymentNode deploymentNode) {
        return this.filter(deploymentNode.getName());
    }

    private String id(InfrastructureNode infrastructureNode) {
        return this.filter(infrastructureNode.getName());
    }

    private String id(SoftwareSystemInstance softwareSystemInstance) {
        return this.filter(softwareSystemInstance.getName()) + "_" + softwareSystemInstance.getInstanceId();
    }

    private String id(ContainerInstance containerInstance) {
        return this.filter(containerInstance.getName()) + "_" + containerInstance.getInstanceId();
    }

    private String filter(String s) {
        return s.replaceAll("\\W", "");
    }

    @Override
    protected void writeHeader(View view, IndentingWriter writer) {
        writer.writeLine("@startuml");
        for (String include : this.includes) {
            writer.writeLine(include);
        }
        if (this.includeTitle) {
            String viewTitle = view.getTitle();
            if (StringUtils.isNullOrEmpty((String)viewTitle)) {
                viewTitle = view.getName();
            }
            writer.writeLine("title " + viewTitle);
        }
        writer.writeLine();
        if (!(view instanceof DynamicView) || !this.isUseSequenceDiagrams()) {
            if (view.getAutomaticLayout() != null) {
                switch (view.getAutomaticLayout().getRankDirection()) {
                    case LeftRight: {
                        writer.writeLine("left to right direction");
                        break;
                    }
                    default: {
                        writer.writeLine("top to bottom direction");
                        break;
                    }
                }
            } else {
                writer.writeLine("top to bottom direction");
            }
            writer.writeLine();
        }
        if (!this.skinParams.isEmpty()) {
            writer.writeLine("skinparam {");
            writer.indent();
            for (String name : this.skinParams.keySet()) {
                writer.writeLine(String.format("%s %s", name, this.skinParams.get(name)));
            }
            writer.outdent();
            writer.writeLine("}");
        }
    }

    @Override
    protected void writeFooter(View view, IndentingWriter writer) {
        writer.writeLine("@enduml");
    }
}

