/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.export.plantuml;

import com.structurizr.export.Diagram;
import com.structurizr.export.IndentingWriter;
import com.structurizr.export.plantuml.AbstractPlantUMLExporter;
import com.structurizr.model.Container;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.StaticStructureElementInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ComponentView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.ElementView;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.Shape;
import com.structurizr.view.View;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public class StructurizrPlantUMLExporter
extends AbstractPlantUMLExporter {
    public StructurizrPlantUMLExporter() {
        this.addSkinParam("shadowing", "false");
        this.addSkinParam("arrowFontSize", "10");
        this.addSkinParam("defaultTextAlignment", "center");
        this.addSkinParam("wrapWidth", "200");
        this.addSkinParam("maxMessageSize", "100");
    }

    @Override
    protected boolean isAnimationSupported(View view) {
        return true;
    }

    @Override
    protected void writeHeader(View view, IndentingWriter writer) {
        super.writeHeader(view, writer);
        this.writeIncludes(view, writer);
        writer.writeLine();
        writer.writeLine("hide stereotype");
        writer.writeLine();
        List elements = view.getElements().stream().map(ElementView::getElement).sorted(Comparator.comparing(Element::getName)).collect(Collectors.toList());
        for (Element element : elements) {
            String id = this.idOf((ModelItem)element);
            String type = this.plantUMLShapeOf(view, element);
            if ("actor".equals(type)) {
                type = "rectangle";
            }
            ElementStyle elementStyle = this.findElementStyle(view, element);
            String background = elementStyle.getBackground();
            String stroke = elementStyle.getStroke();
            String color = elementStyle.getColor();
            Shape shape = elementStyle.getShape();
            if (view instanceof DynamicView && this.useSequenceDiagrams(view)) {
                type = "sequenceParticipant";
            }
            writer.writeLine(String.format("skinparam %s<<%s>> {", type, id));
            writer.indent();
            if (element instanceof DeploymentNode) {
                writer.writeLine("BackgroundColor #ffffff");
            } else {
                writer.writeLine(String.format("BackgroundColor %s", background));
            }
            writer.writeLine(String.format("FontColor %s", color));
            writer.writeLine(String.format("BorderColor %s", stroke));
            if (shape == Shape.RoundedBox) {
                writer.writeLine("roundCorner 20");
            }
            writer.outdent();
            writer.writeLine("}");
        }
        writer.writeLine();
    }

    @Override
    protected void startEnterpriseBoundary(View view, String enterpriseName, IndentingWriter writer) {
        if (!this.useSequenceDiagrams(view)) {
            writer.writeLine(String.format("package \"%s\" <<enterprise>> {", enterpriseName));
            writer.indent();
            writer.writeLine("skinparam PackageBorderColor<<enterprise>> #444444");
            writer.writeLine("skinparam PackageFontColor<<enterprise>> #444444");
            writer.writeLine();
        }
    }

    @Override
    protected void endEnterpriseBoundary(View view, IndentingWriter writer) {
        if (!this.useSequenceDiagrams(view)) {
            writer.outdent();
            writer.writeLine("}");
            writer.writeLine();
        }
    }

    @Override
    protected void startGroupBoundary(View view, String group, IndentingWriter writer) {
        if (!this.useSequenceDiagrams(view)) {
            String color = "#cccccc";
            ElementStyle elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle("Group:" + group);
            String groupId = "group:" + group;
            if (elementStyle == null || StringUtils.isNullOrEmpty((String)elementStyle.getColor())) {
                elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle("Group");
                groupId = "group";
            }
            if (elementStyle != null && !StringUtils.isNullOrEmpty((String)elementStyle.getColor())) {
                color = elementStyle.getColor();
            }
            writer.writeLine(String.format("package \"%s\\n[Group]\" <<%s>> {", group, groupId));
            writer.indent();
            writer.writeLine(String.format("skinparam PackageBorderColor<<%s>> %s", groupId, color));
            writer.writeLine(String.format("skinparam PackageFontColor<<%s>> %s", groupId, color));
            writer.writeLine();
        }
    }

    @Override
    protected void endGroupBoundary(View view, IndentingWriter writer) {
        if (!this.useSequenceDiagrams(view)) {
            writer.outdent();
            writer.writeLine("}");
            writer.writeLine();
        }
    }

    @Override
    protected void startSoftwareSystemBoundary(View view, SoftwareSystem softwareSystem, IndentingWriter writer) {
        if (!this.useSequenceDiagrams(view)) {
            String color = softwareSystem.equals(view.getSoftwareSystem()) ? "#444444" : "#cccccc";
            writer.writeLine(String.format("package \"%s\\n%s\" <<%s>> {", softwareSystem.getName(), this.typeOf(view, (Element)softwareSystem, true), this.idOf((ModelItem)softwareSystem)));
            writer.indent();
            writer.writeLine(String.format("skinparam PackageBorderColor<<%s>> %s", this.idOf((ModelItem)softwareSystem), color));
            writer.writeLine(String.format("skinparam PackageFontColor<<%s>> %s", this.idOf((ModelItem)softwareSystem), color));
            writer.writeLine();
        }
    }

    @Override
    protected void endSoftwareSystemBoundary(View view, IndentingWriter writer) {
        if (!this.useSequenceDiagrams(view)) {
            writer.outdent();
            writer.writeLine("}");
            writer.writeLine();
        }
    }

    @Override
    protected void startContainerBoundary(View view, Container container, IndentingWriter writer) {
        if (!this.useSequenceDiagrams(view)) {
            String color = "#444444";
            if (view instanceof ComponentView) {
                color = container.equals(((ComponentView)view).getContainer()) ? "#444444" : "#cccccc";
            } else if (view instanceof DynamicView) {
                color = container.equals(((DynamicView)view).getElement()) ? "#444444" : "#cccccc";
            }
            writer.writeLine(String.format("package \"%s\\n%s\" <<%s>> {", container.getName(), this.typeOf(view, (Element)container, true), this.idOf((ModelItem)container)));
            writer.indent();
            writer.writeLine(String.format("skinparam PackageBorderColor<<%s>> %s", this.idOf((ModelItem)container), color));
            writer.writeLine(String.format("skinparam PackageFontColor<<%s>> %s", this.idOf((ModelItem)container), color));
            writer.writeLine();
        }
    }

    @Override
    protected void endContainerBoundary(View view, IndentingWriter writer) {
        if (!this.useSequenceDiagrams(view)) {
            writer.outdent();
            writer.writeLine("}");
            writer.writeLine();
        }
    }

    @Override
    protected void startDeploymentNodeBoundary(DeploymentView view, DeploymentNode deploymentNode, IndentingWriter writer) {
        String url = deploymentNode.getUrl();
        url = !StringUtils.isNullOrEmpty((String)url) ? " [[" + url + "]]" : "";
        writer.writeLine(String.format("node \"%s\\n%s\" <<%s>> as %s%s {", deploymentNode.getName() + (deploymentNode.getInstances() > 1 ? " (x" + deploymentNode.getInstances() + ")" : ""), this.typeOf((View)view, (Element)deploymentNode, true), this.idOf((ModelItem)deploymentNode), this.idOf((ModelItem)deploymentNode), url));
        writer.indent();
        if (!this.isVisible((View)view, (Element)deploymentNode)) {
            writer.writeLine("hide " + this.idOf((ModelItem)deploymentNode));
        }
    }

    @Override
    protected void endDeploymentNodeBoundary(View view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    @Override
    public Diagram export(DynamicView view) {
        if (this.useSequenceDiagrams((View)view)) {
            IndentingWriter writer = new IndentingWriter();
            this.writeHeader((View)view, writer);
            LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
            for (RelationshipView relationshipView : view.getRelationships()) {
                elements.add(relationshipView.getRelationship().getSource());
                elements.add(relationshipView.getRelationship().getDestination());
            }
            for (Element element : elements) {
                this.writeElement((View)view, element, writer);
            }
            this.writeRelationships((View)view, writer);
            this.writeFooter((View)view, writer);
            return new Diagram((View)view, writer.toString());
        }
        return super.export(view);
    }

    @Override
    protected void writeElement(View view, Element element, IndentingWriter writer) {
        ElementStyle elementStyle = this.findElementStyle(view, element);
        if (view instanceof DynamicView && this.useSequenceDiagrams(view)) {
            writer.writeLine(String.format("%s \"%s\\n<size:10>%s</size>\" as %s <<%s>> %s", this.plantumlSequenceType(view, element), element.getName(), this.typeOf(view, element, true), this.idOf((ModelItem)element), this.idOf((ModelItem)element), elementStyle.getBackground()));
        } else {
            String shape = this.plantUMLShapeOf(view, element);
            if ("actor".equals(shape)) {
                shape = "rectangle";
            }
            String name = element.getName();
            String description = element.getDescription();
            String type = this.typeOf(view, element, true);
            String url = element.getUrl();
            url = !StringUtils.isNullOrEmpty((String)url) ? " [[" + url + "]]" : "";
            if (element instanceof StaticStructureElementInstance) {
                StaticStructureElementInstance elementInstance = (StaticStructureElementInstance)element;
                name = elementInstance.getElement().getName();
                description = elementInstance.getElement().getDescription();
                type = this.typeOf(view, (Element)elementInstance.getElement(), true);
                shape = this.plantUMLShapeOf(view, (Element)elementInstance.getElement());
                if (StringUtils.isNullOrEmpty((String)url)) {
                    url = element.getUrl();
                    url = !StringUtils.isNullOrEmpty((String)url) ? " [[" + url + "]]" : "";
                }
            }
            description = StringUtils.isNullOrEmpty((String)description) || false == elementStyle.getDescription() ? "" : "\\n\\n" + description;
            type = false == elementStyle.getMetadata() ? "" : String.format("\\n<size:10>%s</size>", type);
            String id = this.idOf((ModelItem)element);
            writer.writeLine(String.format("%s \"==%s%s%s\" <<%s>> as %s%s", shape, name, type, description, id, id, url));
            if (!this.isVisible(view, element)) {
                writer.writeLine("hide " + id);
            }
        }
    }

    @Override
    protected void writeRelationship(View view, RelationshipView relationshipView, IndentingWriter writer) {
        Relationship relationship = relationshipView.getRelationship();
        RelationshipStyle style = this.findRelationshipStyle(view, relationship);
        String description = "";
        String technology = relationship.getTechnology();
        if (!(view instanceof DynamicView && this.useSequenceDiagrams(view) || StringUtils.isNullOrEmpty((String)relationshipView.getOrder()))) {
            description = relationshipView.getOrder() + ". ";
        }
        description = description + (this.hasValue(relationshipView.getDescription()) ? relationshipView.getDescription() : (this.hasValue(relationshipView.getRelationship().getDescription()) ? relationshipView.getRelationship().getDescription() : ""));
        if (view instanceof DynamicView && this.useSequenceDiagrams(view)) {
            String arrowStart = "-";
            String arrowEnd = ">";
            if (relationshipView.isResponse() != null && relationshipView.isResponse().booleanValue()) {
                arrowStart = "<-";
                arrowEnd = "-";
            }
            writer.writeLine(String.format("%s %s[%s]%s %s : %s", this.idOf((ModelItem)relationship.getSource()), arrowStart, style.getColor(), arrowEnd, this.idOf((ModelItem)relationship.getDestination()), description));
        } else {
            String arrowEnd;
            String arrowStart;
            if (style.getDashed() == null) {
                style.setDashed(Boolean.valueOf(true));
            }
            String relationshipStyle = style.getColor();
            if (style.getThickness() != null) {
                relationshipStyle = relationshipStyle + ",thickness=" + style.getThickness();
            }
            if (relationshipView.isResponse() != null && relationshipView.isResponse().booleanValue()) {
                arrowStart = style.getDashed() != false ? "<." : "<-";
                arrowEnd = style.getDashed() != false ? "." : "-";
            } else {
                arrowStart = style.getDashed() != false ? "." : "-";
                String string = arrowEnd = style.getDashed() != false ? ".>" : "->";
            }
            if (!this.isVisible(view, relationshipView)) {
                relationshipStyle = "hidden";
            }
            writer.writeLine(String.format("%s %s[%s]%s %s : \"<color:%s>%s%s\"", this.idOf((ModelItem)relationship.getSource()), arrowStart, relationshipStyle, arrowEnd, this.idOf((ModelItem)relationship.getDestination()), style.getColor(), description, StringUtils.isNullOrEmpty((String)technology) ? "" : "\\n<color:" + style.getColor() + "><size:8>[" + technology + "]</size>"));
        }
    }
}

