/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.export.plantuml;

import com.structurizr.export.Diagram;
import com.structurizr.export.IndentingWriter;
import com.structurizr.export.plantuml.AbstractPlantUMLExporter;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.CustomElement;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.Location;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.StaticStructureElementInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.CustomView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.ElementView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.Shape;
import com.structurizr.view.View;

public class C4PlantUMLExporter
extends AbstractPlantUMLExporter {
    private int groupId = 0;

    @Override
    protected boolean isAnimationSupported(View view) {
        return !(view instanceof DynamicView);
    }

    @Override
    protected void writeHeader(View view, IndentingWriter writer) {
        super.writeHeader(view, writer);
        writer.writeLine("!include https://raw.githubusercontent.com/plantuml-stdlib/C4-PlantUML/master/C4.puml");
        writer.writeLine("!include https://raw.githubusercontent.com/plantuml-stdlib/C4-PlantUML/master/C4_Context.puml");
        if (view.getElements().stream().map(ElementView::getElement).anyMatch(e -> e instanceof Container || e instanceof ContainerInstance)) {
            writer.writeLine("!include https://raw.githubusercontent.com/plantuml-stdlib/C4-PlantUML/master/C4_Container.puml");
        }
        if (view.getElements().stream().map(ElementView::getElement).anyMatch(e -> e instanceof Component)) {
            writer.writeLine("!include https://raw.githubusercontent.com/plantuml-stdlib/C4-PlantUML/master/C4_Component.puml");
        }
        if (view instanceof DeploymentView) {
            writer.writeLine("!include https://raw.githubusercontent.com/plantuml-stdlib/C4-PlantUML/master/C4_Deployment.puml");
        }
        this.writeIncludes(view, writer);
        writer.writeLine();
    }

    @Override
    protected void writeFooter(View view, IndentingWriter writer) {
        if ("true".equalsIgnoreCase(view.getViewSet().getConfiguration().getProperties().getOrDefault("plantuml.legend", "true"))) {
            writer.writeLine();
            writer.writeLine("SHOW_LEGEND()");
        }
        super.writeFooter(view, writer);
    }

    @Override
    protected void startEnterpriseBoundary(View view, String enterpriseName, IndentingWriter writer) {
        writer.writeLine(String.format("Enterprise_Boundary(enterprise, \"%s\") {", enterpriseName));
        writer.indent();
    }

    @Override
    protected void endEnterpriseBoundary(View view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    @Override
    protected void startGroupBoundary(View view, String group, IndentingWriter writer) {
        writer.writeLine(String.format("Boundary(group_%s, \"%s\") {", this.groupId++, group));
        writer.indent();
    }

    @Override
    protected void endGroupBoundary(View view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    @Override
    protected void startSoftwareSystemBoundary(View view, SoftwareSystem softwareSystem, IndentingWriter writer) {
        writer.writeLine(String.format("System_Boundary(\"%s_boundary\", \"%s\") {", this.idOf((ModelItem)softwareSystem), softwareSystem.getName()));
        writer.indent();
    }

    @Override
    protected void endSoftwareSystemBoundary(View view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    @Override
    protected void startContainerBoundary(View view, Container container, IndentingWriter writer) {
        writer.writeLine(String.format("Container_Boundary(\"%s_boundary\", \"%s\") {", this.idOf((ModelItem)container), container.getName()));
        writer.indent();
    }

    @Override
    protected void endContainerBoundary(View view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    @Override
    protected void startDeploymentNodeBoundary(DeploymentView view, DeploymentNode deploymentNode, IndentingWriter writer) {
        String url = deploymentNode.getUrl();
        url = !StringUtils.isNullOrEmpty((String)url) ? "[[" + url + "]]" : "";
        if (StringUtils.isNullOrEmpty((String)deploymentNode.getTechnology())) {
            writer.writeLine(String.format("Deployment_Node(%s, \"%s\", $tags=\"%s\")%s {", this.idOf((ModelItem)deploymentNode), deploymentNode.getName() + (deploymentNode.getInstances() > 1 ? " (x" + deploymentNode.getInstances() + ")" : ""), this.tagsOf((Element)deploymentNode), url));
        } else {
            writer.writeLine(String.format("Deployment_Node(%s, \"%s\", \"%s\", $tags=\"%s\")%s {", this.idOf((ModelItem)deploymentNode), deploymentNode.getName() + (deploymentNode.getInstances() > 1 ? " (x" + deploymentNode.getInstances() + ")" : ""), deploymentNode.getTechnology(), this.tagsOf((Element)deploymentNode), url));
        }
        writer.indent();
        if (!this.isVisible((View)view, (Element)deploymentNode)) {
            writer.writeLine("hide " + this.idOf((ModelItem)deploymentNode));
        }
    }

    @Override
    protected void endDeploymentNodeBoundary(View view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    @Override
    public Diagram export(CustomView view) {
        return null;
    }

    @Override
    public Diagram export(DynamicView view) {
        if (this.useSequenceDiagrams((View)view)) {
            throw new UnsupportedOperationException("Sequence diagrams are not supported by C4-PlantUML");
        }
        return super.export(view);
    }

    @Override
    protected void writeElement(View view, Element element, IndentingWriter writer) {
        if (element instanceof CustomElement) {
            return;
        }
        Element elementToWrite = element;
        String id = this.idOf((ModelItem)element);
        String url = element.getUrl();
        url = !StringUtils.isNullOrEmpty((String)url) ? "[[" + url + "]]" : "";
        if (element instanceof StaticStructureElementInstance) {
            StaticStructureElementInstance elementInstance = (StaticStructureElementInstance)element;
            element = elementInstance.getElement();
            if (StringUtils.isNullOrEmpty((String)url)) {
                url = element.getUrl();
                url = !StringUtils.isNullOrEmpty((String)url) ? "[[" + url + "]]" : "";
            }
        }
        String name = element.getName();
        String description = element.getDescription();
        if (StringUtils.isNullOrEmpty((String)description)) {
            description = "";
        }
        if (element instanceof Person) {
            Person person = (Person)element;
            if (person.getLocation() == Location.External) {
                writer.writeLine(String.format("Person_Ext(%s, \"%s\", \"%s\", $tags=\"%s\")%s", id, name, description, this.tagsOf(elementToWrite), url));
            } else {
                writer.writeLine(String.format("Person(%s, \"%s\", \"%s\", $tags=\"%s\")%s", id, name, description, this.tagsOf(elementToWrite), url));
            }
        } else if (element instanceof SoftwareSystem) {
            SoftwareSystem softwareSystem = (SoftwareSystem)element;
            if (softwareSystem.getLocation() == Location.External) {
                writer.writeLine(String.format("System_Ext(%s, \"%s\", \"%s\", $tags=\"%s\")%s", id, name, description, this.tagsOf(elementToWrite), url));
            } else {
                writer.writeLine(String.format("System(%s, \"%s\", \"%s\", $tags=\"%s\")%s", id, name, description, this.tagsOf(elementToWrite), url));
            }
        } else if (element instanceof Container) {
            Container container = (Container)element;
            ElementStyle elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle(element);
            String shape = "";
            if (elementStyle.getShape() == Shape.Cylinder) {
                shape = "Db";
            } else if (elementStyle.getShape() == Shape.Pipe) {
                shape = "Queue";
            }
            if (StringUtils.isNullOrEmpty((String)container.getTechnology())) {
                writer.writeLine(String.format("Container%s(%s, \"%s\", \"%s\", $tags=\"%s\")%s", shape, id, name, description, this.tagsOf(elementToWrite), url));
            } else {
                writer.writeLine(String.format("Container%s(%s, \"%s\", \"%s\", \"%s\", $tags=\"%s\")%s", shape, id, name, container.getTechnology(), description, this.tagsOf(elementToWrite), url));
            }
        } else if (element instanceof Component) {
            Component component = (Component)element;
            if (StringUtils.isNullOrEmpty((String)component.getTechnology())) {
                writer.writeLine(String.format("Component(%s, \"%s\", \"%s\", $tags=\"%s\")%s", id, name, description, this.tagsOf(elementToWrite), url));
            } else {
                writer.writeLine(String.format("Component(%s, \"%s\", \"%s\", \"%s\", $tags=\"%s\")%s", id, name, component.getTechnology(), description, this.tagsOf(elementToWrite), url));
            }
        } else if (element instanceof InfrastructureNode) {
            InfrastructureNode infrastructureNode = (InfrastructureNode)element;
            if (StringUtils.isNullOrEmpty((String)infrastructureNode.getTechnology())) {
                writer.writeLine(String.format("Deployment_Node(%s, \"%s\", $tags=\"%s\")%s", this.idOf((ModelItem)infrastructureNode), name, this.tagsOf(elementToWrite), url));
            } else if (StringUtils.isNullOrEmpty((String)infrastructureNode.getTechnology())) {
                writer.writeLine(String.format("Deployment_Node(%s, \"%s\", \"%s\", $tags=\"%s\")%s", this.idOf((ModelItem)infrastructureNode), name, infrastructureNode.getTechnology(), this.tagsOf(elementToWrite), url));
            }
        }
        if (!this.isVisible(view, elementToWrite)) {
            writer.writeLine("hide " + id);
        }
    }

    private String tagsOf(Element element) {
        String tags = element instanceof StaticStructureElementInstance ? ((StaticStructureElementInstance)element).getElement().getTags() + "," + element.getTags() : element.getTags();
        return tags.replaceAll(",", "+");
    }

    private String tagsOf(Relationship relationship) {
        String tags;
        if (!StringUtils.isNullOrEmpty((String)relationship.getLinkedRelationshipId())) {
            tags = relationship.getModel().getRelationship(relationship.getLinkedRelationshipId()).getTags();
            if (!StringUtils.isNullOrEmpty((String)relationship.getTags())) {
                tags = tags + "," + relationship.getTags();
            }
        } else {
            tags = relationship.getTags();
        }
        return tags.replaceAll(",", "+");
    }

    @Override
    protected void writeRelationship(View view, RelationshipView relationshipView, IndentingWriter writer) {
        Relationship relationship = relationshipView.getRelationship();
        Element source = relationship.getSource();
        Element destination = relationship.getDestination();
        if (source instanceof CustomElement || destination instanceof CustomElement) {
            return;
        }
        if (relationshipView.isResponse() != null && relationshipView.isResponse().booleanValue()) {
            source = relationship.getDestination();
            destination = relationship.getSource();
        }
        String description = "";
        if (!StringUtils.isNullOrEmpty((String)relationshipView.getOrder())) {
            description = relationshipView.getOrder() + ". ";
        }
        description = description + (this.hasValue(relationshipView.getDescription()) ? relationshipView.getDescription() : (this.hasValue(relationshipView.getRelationship().getDescription()) ? relationshipView.getRelationship().getDescription() : ""));
        if (StringUtils.isNullOrEmpty((String)relationship.getTechnology())) {
            writer.writeLine(String.format("Rel_D(%s, %s, \"%s\", $tags=\"%s\")", this.idOf((ModelItem)source), this.idOf((ModelItem)destination), description, this.tagsOf(relationship)));
        } else {
            writer.writeLine(String.format("Rel_D(%s, %s, \"%s\", \"%s\", $tags=\"%s\")", this.idOf((ModelItem)source), this.idOf((ModelItem)destination), description, relationship.getTechnology(), this.tagsOf(relationship)));
        }
    }
}

