/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.export.websequencediagrams;

import com.structurizr.export.AbstractDiagramExporter;
import com.structurizr.export.Diagram;
import com.structurizr.export.IndentingWriter;
import com.structurizr.model.Container;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InteractionStyle;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.SystemContextView;
import com.structurizr.view.SystemLandscapeView;
import com.structurizr.view.View;
import java.util.LinkedHashSet;

public class WebSequenceDiagramsExporter
extends AbstractDiagramExporter {
    private static final String SYNCHRONOUS_INTERACTION = "->";
    private static final String ASYNCHRONOUS_INTERACTION = "->>";
    private static final String SYNCHRONOUS_INTERACTION_RETURN = "-->";
    private static final String ASYNCHRONOUS_INTERACTION_RETURN = "-->>";

    @Override
    public Diagram export(SystemLandscapeView view) {
        return null;
    }

    @Override
    public Diagram export(SystemContextView view) {
        return null;
    }

    @Override
    public Diagram export(ContainerView view) {
        return null;
    }

    @Override
    public Diagram export(ComponentView view) {
        return null;
    }

    @Override
    public Diagram export(DynamicView view) {
        IndentingWriter writer = new IndentingWriter();
        this.writeHeader((View)view, writer);
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
        for (RelationshipView relationshipView : view.getRelationships()) {
            elements.add(relationshipView.getRelationship().getSource());
            elements.add(relationshipView.getRelationship().getDestination());
        }
        for (Element element : elements) {
            this.writeElement((View)view, element, writer);
        }
        writer.writeLine();
        this.writeRelationships((View)view, writer);
        this.writeFooter((View)view, writer);
        return new Diagram((View)view, writer.toString());
    }

    @Override
    public Diagram export(DeploymentView view) {
        return null;
    }

    @Override
    protected void writeHeader(View view, IndentingWriter writer) {
        writer.writeLine("title " + view.getName() + " - " + view.getKey());
        writer.writeLine();
    }

    @Override
    protected void writeFooter(View view, IndentingWriter writer) {
    }

    @Override
    protected void startEnterpriseBoundary(View view, String enterpriseName, IndentingWriter writer) {
    }

    @Override
    protected void endEnterpriseBoundary(View view, IndentingWriter writer) {
    }

    @Override
    protected void startGroupBoundary(View view, String group, IndentingWriter writer) {
    }

    @Override
    protected void endGroupBoundary(View view, IndentingWriter writer) {
    }

    @Override
    protected void startSoftwareSystemBoundary(View view, SoftwareSystem softwareSystem, IndentingWriter writer) {
    }

    @Override
    protected void endSoftwareSystemBoundary(View view, IndentingWriter writer) {
    }

    @Override
    protected void startContainerBoundary(View view, Container container, IndentingWriter writer) {
    }

    @Override
    protected void endContainerBoundary(View view, IndentingWriter writer) {
    }

    @Override
    protected void startDeploymentNodeBoundary(DeploymentView view, DeploymentNode deploymentNode, IndentingWriter writer) {
    }

    @Override
    protected void endDeploymentNodeBoundary(View view, IndentingWriter writer) {
    }

    @Override
    protected void writeElement(View view, Element element, IndentingWriter writer) {
        if (element instanceof Person) {
            writer.writeLine(String.format("actor <<%s>>>\\n%s as %s", view.getViewSet().getConfiguration().getTerminology().findTerminology((ModelItem)element), element.getName(), element.getName()));
        } else {
            writer.writeLine(String.format("participant <<%s>>>\\n%s as %s", view.getViewSet().getConfiguration().getTerminology().findTerminology((ModelItem)element), element.getName(), element.getName()));
        }
    }

    @Override
    protected void writeRelationship(View view, RelationshipView relationshipView, IndentingWriter writer) {
        String arrow;
        Relationship r = relationshipView.getRelationship();
        Element source = r.getSource();
        Element destination = r.getDestination();
        String string = arrow = r.getInteractionStyle() == InteractionStyle.Asynchronous ? ASYNCHRONOUS_INTERACTION : SYNCHRONOUS_INTERACTION;
        if (relationshipView.isResponse() != null && relationshipView.isResponse().booleanValue()) {
            source = r.getDestination();
            destination = r.getSource();
            arrow = r.getInteractionStyle() == InteractionStyle.Asynchronous ? ASYNCHRONOUS_INTERACTION_RETURN : SYNCHRONOUS_INTERACTION_RETURN;
        }
        writer.writeLine(String.format("%s%s%s: %s", source.getName(), arrow, destination.getName(), relationshipView.getDescription()));
    }
}

