/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.export.plantuml;

import com.structurizr.export.AbstractDiagramExporter;
import com.structurizr.export.Diagram;
import com.structurizr.export.IndentingWriter;
import com.structurizr.export.plantuml.PlantUMLDiagram;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Person;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.DynamicView;
import com.structurizr.view.Shape;
import com.structurizr.view.View;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractPlantUMLExporter
extends AbstractDiagramExporter {
    public static final String PLANTUML_TITLE_PROPERTY = "plantuml.title";
    public static final String PLANTUML_LEGEND_PROPERTY = "plantuml.legend";
    public static final String PLANTUML_INCLUDES_PROPERTY = "plantuml.includes";
    public static final String PLANTUML_SEQUENCE_DIAGRAMS_PROPERTY = "plantuml.sequenceDiagrams";
    public static final String PLANTUML_ANIMATION_PROPERTY = "plantuml.animation";
    private final Map<String, String> skinParams = new LinkedHashMap<String, String>();

    protected Map<String, String> getSkinParams() {
        return this.skinParams;
    }

    public void addSkinParam(String name, String value) {
        this.skinParams.put(name, value);
    }

    public void clearSkinParams() {
        this.skinParams.clear();
    }

    String plantUMLShapeOf(View view, Element element) {
        Shape shape = this.findElementStyle(view, element).getShape();
        return this.plantUMLShapeOf(shape);
    }

    String plantUMLShapeOf(Shape shape) {
        switch (shape) {
            case Person: 
            case Robot: {
                return "person";
            }
            case Component: {
                return "component";
            }
            case Cylinder: {
                return "database";
            }
            case Folder: {
                return "folder";
            }
            case Ellipse: 
            case Circle: {
                return "storage";
            }
            case Hexagon: {
                return "hexagon";
            }
            case Pipe: {
                return "queue";
            }
        }
        return "rectangle";
    }

    String plantumlSequenceType(View view, Element element) {
        Shape shape = this.findElementStyle(view, element).getShape();
        switch (shape) {
            case Box: {
                return "participant";
            }
            case Person: {
                return "actor";
            }
            case Cylinder: {
                return "database";
            }
            case Folder: {
                return "collections";
            }
            case Ellipse: 
            case Circle: {
                return "entity";
            }
        }
        return "participant";
    }

    String idOf(ModelItem modelItem) {
        if (modelItem instanceof Element) {
            Element element = (Element)modelItem;
            if (element.getParent() == null) {
                if (element instanceof DeploymentNode) {
                    DeploymentNode dn = (DeploymentNode)element;
                    return this.filter(dn.getEnvironment()) + "." + this.id(dn);
                }
                return this.id((ModelItem)element);
            }
            return this.idOf((ModelItem)element.getParent()) + "." + this.id(modelItem);
        }
        return this.id(modelItem);
    }

    private String id(ModelItem modelItem) {
        if (modelItem instanceof Person) {
            return this.id((Person)modelItem);
        }
        if (modelItem instanceof SoftwareSystem) {
            return this.id((SoftwareSystem)modelItem);
        }
        if (modelItem instanceof Container) {
            return this.id((Container)modelItem);
        }
        if (modelItem instanceof Component) {
            return this.id((Component)modelItem);
        }
        if (modelItem instanceof DeploymentNode) {
            return this.id((DeploymentNode)modelItem);
        }
        if (modelItem instanceof InfrastructureNode) {
            return this.id((InfrastructureNode)modelItem);
        }
        if (modelItem instanceof SoftwareSystemInstance) {
            return this.id((SoftwareSystemInstance)modelItem);
        }
        if (modelItem instanceof ContainerInstance) {
            return this.id((ContainerInstance)modelItem);
        }
        return modelItem.getId();
    }

    private String id(Person person) {
        return this.filter(person.getName());
    }

    private String id(SoftwareSystem softwareSystem) {
        return this.filter(softwareSystem.getName());
    }

    private String id(Container container) {
        return this.filter(container.getName());
    }

    private String id(Component component) {
        return this.filter(component.getName());
    }

    private String id(DeploymentNode deploymentNode) {
        return this.filter(deploymentNode.getName());
    }

    private String id(InfrastructureNode infrastructureNode) {
        return this.filter(infrastructureNode.getName());
    }

    private String id(SoftwareSystemInstance softwareSystemInstance) {
        return this.filter(softwareSystemInstance.getName()) + "_" + softwareSystemInstance.getInstanceId();
    }

    private String id(ContainerInstance containerInstance) {
        return this.filter(containerInstance.getName()) + "_" + containerInstance.getInstanceId();
    }

    private String filter(String s) {
        return s.replaceAll("(?U)\\W", "");
    }

    protected boolean includeTitle(View view) {
        return "true".equalsIgnoreCase(view.getViewSet().getConfiguration().getProperties().getOrDefault(PLANTUML_TITLE_PROPERTY, "true"));
    }

    protected boolean useSequenceDiagrams(View view) {
        return "true".equalsIgnoreCase(view.getViewSet().getConfiguration().getProperties().getOrDefault(PLANTUML_SEQUENCE_DIAGRAMS_PROPERTY, "false"));
    }

    @Override
    protected boolean isAnimationSupported(View view) {
        return "true".equalsIgnoreCase(view.getViewSet().getConfiguration().getProperties().getOrDefault(PLANTUML_ANIMATION_PROPERTY, "false"));
    }

    @Override
    protected void writeHeader(View view, IndentingWriter writer) {
        writer.writeLine("@startuml");
        if (this.includeTitle(view)) {
            String viewTitle = view.getTitle();
            if (StringUtils.isNullOrEmpty((String)viewTitle)) {
                viewTitle = view.getName();
            }
            writer.writeLine("title " + viewTitle);
        }
        writer.writeLine();
        if (!(view instanceof DynamicView) || !this.useSequenceDiagrams(view)) {
            if (view.getAutomaticLayout() != null) {
                switch (view.getAutomaticLayout().getRankDirection()) {
                    case LeftRight: {
                        writer.writeLine("left to right direction");
                        break;
                    }
                    default: {
                        writer.writeLine("top to bottom direction");
                        break;
                    }
                }
            } else {
                writer.writeLine("top to bottom direction");
            }
            writer.writeLine();
        }
        this.writeSkinParams(writer);
    }

    protected void writeSkinParams(IndentingWriter writer) {
        if (!this.skinParams.isEmpty()) {
            writer.writeLine("skinparam {");
            writer.indent();
            for (String name : this.skinParams.keySet()) {
                writer.writeLine(String.format("%s %s", name, this.skinParams.get(name)));
            }
            writer.outdent();
            writer.writeLine("}");
        }
    }

    protected void writeIncludes(View view, IndentingWriter writer) {
        String[] includes;
        for (String include : includes = view.getViewSet().getConfiguration().getProperties().getOrDefault(PLANTUML_INCLUDES_PROPERTY, "").split(",")) {
            if (StringUtils.isNullOrEmpty((String)include)) continue;
            include = include.trim();
            writer.writeLine("!include " + include);
        }
    }

    @Override
    protected void writeFooter(View view, IndentingWriter writer) {
        writer.writeLine("@enduml");
    }

    @Override
    protected Diagram createDiagram(View view, String definition) {
        return new PlantUMLDiagram(view, definition);
    }
}

