/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.export;

import com.structurizr.Workspace;
import com.structurizr.export.AbstractExporter;
import com.structurizr.export.Diagram;
import com.structurizr.export.DiagramExporter;
import com.structurizr.export.IndentingWriter;
import com.structurizr.export.Legend;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.CustomElement;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.GroupableElement;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.ModelItem;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.model.StaticStructureElement;
import com.structurizr.model.StaticStructureElementInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.Animation;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.CustomView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementView;
import com.structurizr.view.ModelView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.StaticView;
import com.structurizr.view.SystemContextView;
import com.structurizr.view.SystemLandscapeView;
import com.structurizr.view.ViewSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class AbstractDiagramExporter
extends AbstractExporter
implements DiagramExporter {
    protected static final String GROUP_SEPARATOR_PROPERTY_NAME = "structurizr.groupSeparator";
    private Object frame = null;

    @Override
    public final Collection<Diagram> export(Workspace workspace) {
        Diagram diagram;
        if (workspace == null) {
            throw new IllegalArgumentException("A workspace must be provided.");
        }
        ArrayList<Diagram> diagrams = new ArrayList<Diagram>();
        for (CustomView view : workspace.getViews().getCustomViews()) {
            diagram = this.export(view);
            if (diagram == null) continue;
            diagrams.add(diagram);
        }
        for (CustomView view : workspace.getViews().getSystemLandscapeViews()) {
            diagram = this.export((SystemLandscapeView)view);
            if (diagram == null) continue;
            diagrams.add(diagram);
        }
        for (CustomView view : workspace.getViews().getSystemContextViews()) {
            diagram = this.export((SystemContextView)view);
            if (diagram == null) continue;
            diagrams.add(diagram);
        }
        for (CustomView view : workspace.getViews().getContainerViews()) {
            diagram = this.export((ContainerView)view);
            if (diagram == null) continue;
            diagrams.add(diagram);
        }
        for (CustomView view : workspace.getViews().getComponentViews()) {
            diagram = this.export((ComponentView)view);
            if (diagram == null) continue;
            diagrams.add(diagram);
        }
        for (CustomView view : workspace.getViews().getDynamicViews()) {
            diagram = this.export((DynamicView)view);
            if (diagram == null) continue;
            diagrams.add(diagram);
        }
        for (CustomView view : workspace.getViews().getDeploymentViews()) {
            diagram = this.export((DeploymentView)view);
            if (diagram == null) continue;
            diagrams.add(diagram);
        }
        return diagrams;
    }

    public Diagram export(CustomView view) {
        Diagram diagram = this.export(view, null);
        if (this.isAnimationSupported((ModelView)view) && !view.getAnimations().isEmpty()) {
            for (Animation animation : view.getAnimations()) {
                Diagram frame = this.export(view, (Integer)animation.getOrder());
                diagram.addFrame(frame);
            }
        }
        diagram.setLegend(this.createLegend((ModelView)view));
        return diagram;
    }

    private Diagram export(CustomView view, Integer animationStep) {
        this.frame = animationStep;
        IndentingWriter writer = new IndentingWriter();
        this.writeHeader((ModelView)view, writer);
        ArrayList<GroupableElement> elements = new ArrayList<GroupableElement>();
        for (ElementView elementView : view.getElements()) {
            elements.add((GroupableElement)((CustomElement)elementView.getElement()));
        }
        this.writeElements((ModelView)view, elements, writer);
        writer.writeLine();
        this.writeRelationships((ModelView)view, writer);
        this.writeFooter((ModelView)view, writer);
        return this.createDiagram((ModelView)view, writer.toString());
    }

    public Diagram export(SystemLandscapeView view) {
        Diagram diagram = this.export(view, null);
        if (this.isAnimationSupported((ModelView)view) && !view.getAnimations().isEmpty()) {
            for (Animation animation : view.getAnimations()) {
                Diagram frame = this.export(view, (Integer)animation.getOrder());
                diagram.addFrame(frame);
            }
        }
        diagram.setLegend(this.createLegend((ModelView)view));
        return diagram;
    }

    private Diagram export(SystemLandscapeView view, Integer animationStep) {
        this.frame = animationStep;
        IndentingWriter writer = new IndentingWriter();
        this.writeHeader((ModelView)view, writer);
        ArrayList<GroupableElement> elements = new ArrayList<GroupableElement>();
        for (ElementView elementView : view.getElements()) {
            elements.add((GroupableElement)elementView.getElement());
        }
        this.writeElements((ModelView)view, elements, writer);
        writer.writeLine();
        this.writeRelationships((ModelView)view, writer);
        this.writeFooter((ModelView)view, writer);
        return this.createDiagram((ModelView)view, writer.toString());
    }

    public Diagram export(SystemContextView view) {
        Diagram diagram = this.export(view, null);
        if (this.isAnimationSupported((ModelView)view) && !view.getAnimations().isEmpty()) {
            for (Animation animation : view.getAnimations()) {
                Diagram frame = this.export(view, (Integer)animation.getOrder());
                diagram.addFrame(frame);
            }
        }
        diagram.setLegend(this.createLegend((ModelView)view));
        return diagram;
    }

    private Diagram export(SystemContextView view, Integer animationStep) {
        this.frame = animationStep;
        IndentingWriter writer = new IndentingWriter();
        this.writeHeader((ModelView)view, writer);
        ArrayList<GroupableElement> elements = new ArrayList<GroupableElement>();
        for (ElementView elementView : view.getElements()) {
            elements.add((GroupableElement)elementView.getElement());
        }
        this.writeElements((ModelView)view, elements, writer);
        writer.writeLine();
        this.writeRelationships((ModelView)view, writer);
        this.writeFooter((ModelView)view, writer);
        return this.createDiagram((ModelView)view, writer.toString());
    }

    public Diagram export(ContainerView view) {
        Diagram diagram = this.export(view, null);
        if (this.isAnimationSupported((ModelView)view) && !view.getAnimations().isEmpty()) {
            for (Animation animation : view.getAnimations()) {
                Diagram frame = this.export(view, (Integer)animation.getOrder());
                diagram.addFrame(frame);
            }
        }
        diagram.setLegend(this.createLegend((ModelView)view));
        return diagram;
    }

    public Diagram export(ContainerView view, Integer animationStep) {
        this.frame = animationStep;
        IndentingWriter writer = new IndentingWriter();
        this.writeHeader((ModelView)view, writer);
        boolean elementsWritten = false;
        for (ElementView elementView : view.getElements()) {
            if (elementView.getElement() instanceof Container) continue;
            this.writeElement((ModelView)view, elementView.getElement(), writer);
            elementsWritten = true;
        }
        if (elementsWritten) {
            writer.writeLine();
        }
        List<SoftwareSystem> softwareSystems = this.getBoundarySoftwareSystems((ModelView)view);
        for (SoftwareSystem softwareSystem : softwareSystems) {
            this.startSoftwareSystemBoundary((ModelView)view, softwareSystem, writer);
            ArrayList<GroupableElement> scopedElements = new ArrayList<GroupableElement>();
            for (ElementView elementView : view.getElements()) {
                if (elementView.getElement().getParent() != softwareSystem) continue;
                scopedElements.add((GroupableElement)((StaticStructureElement)elementView.getElement()));
            }
            this.writeElements((ModelView)view, scopedElements, writer);
            this.endSoftwareSystemBoundary((ModelView)view, writer);
        }
        this.writeRelationships((ModelView)view, writer);
        this.writeFooter((ModelView)view, writer);
        return this.createDiagram((ModelView)view, writer.toString());
    }

    protected List<SoftwareSystem> getBoundarySoftwareSystems(ModelView view) {
        ArrayList<SoftwareSystem> softwareSystems = new ArrayList<SoftwareSystem>(view.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof Container).map(c -> ((Container)c).getSoftwareSystem()).collect(Collectors.toSet()));
        softwareSystems.sort(Comparator.comparing(ModelItem::getId));
        return softwareSystems;
    }

    public Diagram export(ComponentView view) {
        Diagram diagram = this.export(view, null);
        if (this.isAnimationSupported((ModelView)view) && !view.getAnimations().isEmpty()) {
            for (Animation animation : view.getAnimations()) {
                Diagram frame = this.export(view, (Integer)animation.getOrder());
                diagram.addFrame(frame);
            }
        }
        diagram.setLegend(this.createLegend((ModelView)view));
        return diagram;
    }

    public Diagram export(ComponentView view, Integer animationStep) {
        this.frame = animationStep;
        IndentingWriter writer = new IndentingWriter();
        this.writeHeader((ModelView)view, writer);
        boolean elementsWritten = false;
        for (ElementView elementView : view.getElements()) {
            if (elementView.getElement() instanceof Component) continue;
            this.writeElement((ModelView)view, elementView.getElement(), writer);
            elementsWritten = true;
        }
        if (elementsWritten) {
            writer.writeLine();
        }
        boolean includeSoftwareSystemBoundaries = "true".equals(view.getProperties().getOrDefault("structurizr.softwareSystemBoundaries", "false"));
        List<Container> containers = this.getBoundaryContainers((ModelView)view);
        Set softwareSystems = containers.stream().map(Container::getSoftwareSystem).collect(Collectors.toCollection(LinkedHashSet::new));
        for (SoftwareSystem softwareSystem : softwareSystems) {
            if (includeSoftwareSystemBoundaries) {
                this.startSoftwareSystemBoundary((ModelView)view, softwareSystem, writer);
                writer.indent();
            }
            for (Container container : containers) {
                if (container.getSoftwareSystem() != softwareSystem) continue;
                this.startContainerBoundary((ModelView)view, container, writer);
                ArrayList<GroupableElement> scopedElements = new ArrayList<GroupableElement>();
                for (ElementView elementView : view.getElements()) {
                    if (elementView.getElement().getParent() != container) continue;
                    scopedElements.add((GroupableElement)((StaticStructureElement)elementView.getElement()));
                }
                this.writeElements((ModelView)view, scopedElements, writer);
                this.endContainerBoundary((ModelView)view, writer);
            }
            if (!includeSoftwareSystemBoundaries) continue;
            this.endSoftwareSystemBoundary((ModelView)view, writer);
            writer.outdent();
        }
        this.writeRelationships((ModelView)view, writer);
        this.writeFooter((ModelView)view, writer);
        return this.createDiagram((ModelView)view, writer.toString());
    }

    protected List<Container> getBoundaryContainers(ModelView view) {
        ArrayList<Container> containers = new ArrayList<Container>(view.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof Component).map(c -> ((Component)c).getContainer()).collect(Collectors.toSet()));
        containers.sort(Comparator.comparing(ModelItem::getId));
        return containers;
    }

    public Diagram export(DynamicView view) {
        Diagram diagram = this.export(view, null);
        if (this.isAnimationSupported((ModelView)view)) {
            LinkedHashSet<String> orders = new LinkedHashSet<String>();
            for (RelationshipView relationshipView : view.getRelationships()) {
                orders.add(relationshipView.getOrder());
            }
            for (String order : orders) {
                Diagram frame = this.export(view, order);
                diagram.addFrame(frame);
            }
        }
        diagram.setLegend(this.createLegend((ModelView)view));
        return diagram;
    }

    public Diagram export(DynamicView view, String order) {
        this.frame = order;
        IndentingWriter writer = new IndentingWriter();
        this.writeHeader((ModelView)view, writer);
        boolean elementsWritten = false;
        Element element = view.getElement();
        if (element == null) {
            ArrayList<GroupableElement> elements = new ArrayList<GroupableElement>();
            for (ElementView elementView : view.getElements()) {
                elements.add((GroupableElement)((StaticStructureElement)elementView.getElement()));
            }
            this.writeElements((ModelView)view, elements, writer);
        } else if (element instanceof SoftwareSystem) {
            List<SoftwareSystem> softwareSystems = this.getBoundarySoftwareSystems((ModelView)view);
            for (SoftwareSystem softwareSystem : softwareSystems) {
                this.startSoftwareSystemBoundary((ModelView)view, softwareSystem, writer);
                ArrayList<GroupableElement> scopedElements = new ArrayList<GroupableElement>();
                for (ElementView elementView : view.getElements()) {
                    if (elementView.getElement().getParent() != softwareSystem) continue;
                    scopedElements.add((GroupableElement)((StaticStructureElement)elementView.getElement()));
                }
                this.writeElements((ModelView)view, scopedElements, writer);
                this.endSoftwareSystemBoundary((ModelView)view, writer);
            }
            for (ElementView elementView : view.getElements()) {
                if (elementView.getElement().getParent() != null) continue;
                this.writeElement((ModelView)view, elementView.getElement(), writer);
                elementsWritten = true;
            }
        } else if (element instanceof Container) {
            boolean includeSoftwareSystemBoundaries = "true".equals(view.getProperties().getOrDefault("structurizr.softwareSystemBoundaries", "false"));
            List<Container> containers = this.getBoundaryContainers((ModelView)view);
            Set softwareSystems = containers.stream().map(Container::getSoftwareSystem).collect(Collectors.toCollection(LinkedHashSet::new));
            for (SoftwareSystem softwareSystem : softwareSystems) {
                if (includeSoftwareSystemBoundaries) {
                    this.startSoftwareSystemBoundary((ModelView)view, softwareSystem, writer);
                    writer.indent();
                }
                for (Container container : containers) {
                    if (container.getSoftwareSystem() != softwareSystem) continue;
                    this.startContainerBoundary((ModelView)view, container, writer);
                    ArrayList<GroupableElement> scopedElements = new ArrayList<GroupableElement>();
                    for (ElementView elementView : view.getElements()) {
                        if (elementView.getElement().getParent() != container) continue;
                        scopedElements.add((GroupableElement)((StaticStructureElement)elementView.getElement()));
                    }
                    this.writeElements((ModelView)view, scopedElements, writer);
                    this.endContainerBoundary((ModelView)view, writer);
                }
                if (!includeSoftwareSystemBoundaries) continue;
                this.endSoftwareSystemBoundary((ModelView)view, writer);
                writer.outdent();
            }
            for (ElementView elementView : view.getElements()) {
                if (elementView.getElement().getParent() instanceof Container) continue;
                this.writeElement((ModelView)view, elementView.getElement(), writer);
                elementsWritten = true;
            }
        }
        if (elementsWritten) {
            writer.writeLine();
        }
        this.writeRelationships((ModelView)view, writer);
        this.writeFooter((ModelView)view, writer);
        return this.createDiagram((ModelView)view, writer.toString());
    }

    public Diagram export(DeploymentView view) {
        Diagram diagram = this.export(view, null);
        if (this.isAnimationSupported((ModelView)view) && !view.getAnimations().isEmpty()) {
            for (Animation animation : view.getAnimations()) {
                Diagram frame = this.export(view, (Integer)animation.getOrder());
                diagram.addFrame(frame);
            }
        }
        diagram.setLegend(this.createLegend((ModelView)view));
        return diagram;
    }

    public Diagram export(DeploymentView view, Integer animationStep) {
        this.frame = animationStep;
        IndentingWriter writer = new IndentingWriter();
        this.writeHeader((ModelView)view, writer);
        ArrayList<GroupableElement> elements = new ArrayList<GroupableElement>();
        for (ElementView elementView : view.getElements()) {
            if (!(elementView.getElement() instanceof DeploymentNode) || elementView.getElement().getParent() != null) continue;
            elements.add((GroupableElement)((DeploymentNode)elementView.getElement()));
        }
        this.writeElements((ModelView)view, elements, writer);
        this.writeRelationships((ModelView)view, writer);
        this.writeFooter((ModelView)view, writer);
        return this.createDiagram((ModelView)view, writer.toString());
    }

    protected void writeElements(ModelView view, List<GroupableElement> elements, IndentingWriter writer) {
        String groupSeparator = (String)view.getModel().getProperties().get(GROUP_SEPARATOR_PROPERTY_NAME);
        boolean nested = !StringUtils.isNullOrEmpty((String)groupSeparator);
        elements.sort(Comparator.comparing(ModelItem::getId));
        HashSet<Object> groupsAsSet = new HashSet<Object>();
        for (GroupableElement element : elements) {
            Object group = element.getGroup();
            if (StringUtils.isNullOrEmpty((String)group)) continue;
            groupsAsSet.add(group);
            if (!nested) continue;
            while (((String)group).contains(groupSeparator)) {
                group = ((String)group).substring(0, ((String)group).lastIndexOf(groupSeparator));
                groupsAsSet.add(group);
            }
        }
        ArrayList groupsAsList = new ArrayList(groupsAsSet);
        Collections.sort(groupsAsList);
        if (groupsAsList.size() > 0) {
            if (nested) {
                String context = "";
                for (String group : groupsAsList) {
                    int contextCount;
                    int groupCount = group.split(Pattern.quote(groupSeparator)).length;
                    if (groupCount > (contextCount = context.split(Pattern.quote(groupSeparator)).length)) {
                        writer.indent();
                    } else if (groupCount == contextCount) {
                        if (context.length() > 1) {
                            this.endGroupBoundary(view, writer);
                        }
                    } else {
                        for (int i = 0; i < contextCount - groupCount; ++i) {
                            this.endGroupBoundary(view, writer);
                            writer.outdent();
                        }
                        this.endGroupBoundary(view, writer);
                    }
                    this.startGroupBoundary(view, group, writer);
                    for (GroupableElement element : elements) {
                        if (!group.equals(element.getGroup())) continue;
                        this.write(view, (Element)element, writer);
                    }
                    context = group;
                }
                int contextCount = context.split(Pattern.quote(groupSeparator)).length;
                for (int i = 0; i < contextCount; ++i) {
                    this.endGroupBoundary(view, writer);
                    if (i >= contextCount - 1) continue;
                    writer.outdent();
                }
            } else {
                for (Object group : groupsAsList) {
                    this.startGroupBoundary(view, (String)group, writer);
                    for (GroupableElement element : elements) {
                        if (!((String)group).equals(element.getGroup())) continue;
                        this.write(view, (Element)element, writer);
                    }
                    this.endGroupBoundary(view, writer);
                }
            }
        }
        for (GroupableElement element : elements) {
            if (!StringUtils.isNullOrEmpty((String)element.getGroup())) continue;
            this.write(view, (Element)element, writer);
        }
    }

    protected void writeRelationships(ModelView view, IndentingWriter writer) {
        Collection relationshipList = view instanceof DynamicView ? view.getRelationships() : (Collection)view.getRelationships().stream().sorted(Comparator.comparing(rv -> rv.getRelationship().getId())).collect(Collectors.toList());
        for (RelationshipView relationshipView : relationshipList) {
            this.writeRelationship(view, relationshipView, writer);
        }
    }

    protected abstract void writeHeader(ModelView var1, IndentingWriter var2);

    protected abstract void writeFooter(ModelView var1, IndentingWriter var2);

    protected abstract void startEnterpriseBoundary(ModelView var1, String var2, IndentingWriter var3);

    protected abstract void endEnterpriseBoundary(ModelView var1, IndentingWriter var2);

    protected abstract void startGroupBoundary(ModelView var1, String var2, IndentingWriter var3);

    protected abstract void endGroupBoundary(ModelView var1, IndentingWriter var2);

    protected abstract void startSoftwareSystemBoundary(ModelView var1, SoftwareSystem var2, IndentingWriter var3);

    protected abstract void endSoftwareSystemBoundary(ModelView var1, IndentingWriter var2);

    protected abstract void startContainerBoundary(ModelView var1, Container var2, IndentingWriter var3);

    protected abstract void endContainerBoundary(ModelView var1, IndentingWriter var2);

    protected abstract void startDeploymentNodeBoundary(DeploymentView var1, DeploymentNode var2, IndentingWriter var3);

    protected abstract void endDeploymentNodeBoundary(ModelView var1, IndentingWriter var2);

    private void write(ModelView view, Element element, IndentingWriter writer) {
        if (view instanceof DeploymentView && element instanceof DeploymentNode) {
            this.writeDeploymentNode((DeploymentView)view, (DeploymentNode)element, writer);
        } else {
            this.writeElement(view, element, writer);
        }
    }

    private void writeDeploymentNode(DeploymentView view, DeploymentNode deploymentNode, IndentingWriter writer) {
        this.startDeploymentNodeBoundary(view, deploymentNode, writer);
        ArrayList<GroupableElement> elements = new ArrayList<GroupableElement>();
        ArrayList<DeploymentNode> children = new ArrayList<DeploymentNode>(deploymentNode.getChildren());
        children.sort(Comparator.comparing(Element::getName));
        for (DeploymentNode deploymentNode2 : children) {
            if (!view.isElementInView((Element)deploymentNode2)) continue;
            elements.add((GroupableElement)deploymentNode2);
        }
        ArrayList<InfrastructureNode> infrastructureNodes = new ArrayList<InfrastructureNode>(deploymentNode.getInfrastructureNodes());
        infrastructureNodes.sort(Comparator.comparing(Element::getName));
        for (InfrastructureNode infrastructureNode : infrastructureNodes) {
            if (!view.isElementInView((Element)infrastructureNode)) continue;
            elements.add((GroupableElement)infrastructureNode);
        }
        ArrayList<SoftwareSystemInstance> arrayList = new ArrayList<SoftwareSystemInstance>(deploymentNode.getSoftwareSystemInstances());
        arrayList.sort(Comparator.comparing(StaticStructureElementInstance::getName));
        for (SoftwareSystemInstance softwareSystemInstance : arrayList) {
            if (!view.isElementInView((Element)softwareSystemInstance)) continue;
            elements.add((GroupableElement)softwareSystemInstance);
        }
        ArrayList<ContainerInstance> arrayList2 = new ArrayList<ContainerInstance>(deploymentNode.getContainerInstances());
        arrayList2.sort(Comparator.comparing(StaticStructureElementInstance::getName));
        for (ContainerInstance containerInstance : arrayList2) {
            if (!view.isElementInView((Element)containerInstance)) continue;
            elements.add((GroupableElement)containerInstance);
        }
        this.writeElements((ModelView)view, elements, writer);
        this.endDeploymentNodeBoundary((ModelView)view, writer);
    }

    protected abstract void writeElement(ModelView var1, Element var2, IndentingWriter var3);

    protected abstract void writeRelationship(ModelView var1, RelationshipView var2, IndentingWriter var3);

    protected boolean isAnimationSupported(ModelView view) {
        return false;
    }

    protected boolean isVisible(ModelView view, Element element) {
        if (this.frame != null) {
            HashSet elementIds = new HashSet();
            if (view instanceof StaticView) {
                int step = (Integer)this.frame;
                if (step > 0) {
                    StaticView staticView = (StaticView)view;
                    staticView.getAnimations().stream().filter(a -> a.getOrder() <= step).forEach(a -> elementIds.addAll(a.getElements()));
                    return elementIds.contains(element.getId());
                }
            } else if (view instanceof DeploymentView) {
                int step = (Integer)this.frame;
                if (step > 0) {
                    DeploymentView deploymentView = (DeploymentView)view;
                    deploymentView.getAnimations().stream().filter(a -> a.getOrder() <= step).forEach(a -> elementIds.addAll(a.getElements()));
                    return elementIds.contains(element.getId());
                }
            } else if (view instanceof DynamicView) {
                String order = (String)this.frame;
                view.getRelationships().stream().filter(rv -> order.equals(rv.getOrder())).forEach(rv -> {
                    elementIds.add(rv.getRelationship().getSourceId());
                    elementIds.add(rv.getRelationship().getDestinationId());
                });
                return elementIds.contains(element.getId());
            }
        }
        return true;
    }

    protected boolean isVisible(ModelView view, RelationshipView relationshipView) {
        if (view instanceof DynamicView && this.frame != null) {
            return this.frame.equals(relationshipView.getOrder());
        }
        return true;
    }

    protected abstract Diagram createDiagram(ModelView var1, String var2);

    protected Legend createLegend(ModelView view) {
        return null;
    }

    protected String getViewOrViewSetProperty(ModelView view, String name, String defaultValue) {
        ViewSet views = view.getViewSet();
        return view.getProperties().getOrDefault(name, views.getConfiguration().getProperties().getOrDefault(name, defaultValue));
    }
}

