/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.export.dot;

import com.structurizr.export.AbstractDiagramExporter;
import com.structurizr.export.Diagram;
import com.structurizr.export.IndentingWriter;
import com.structurizr.export.dot.DOTDiagram;
import com.structurizr.export.dot.RankDirection;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.model.StaticStructureElementInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ComponentView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.Font;
import com.structurizr.view.LineStyle;
import com.structurizr.view.ModelView;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.Shape;

public class DOTExporter
extends AbstractDiagramExporter {
    private static final int DEFAULT_WIDTH = 450;
    private static final int DEFAULT_HEIGHT = 300;
    private static final String DEFAULT_FONT = "Arial";
    private int clusterInternalMargin = 25;

    public void setClusterInternalMargin(int clusterInternalMargin) {
        this.clusterInternalMargin = clusterInternalMargin;
    }

    @Override
    protected void writeHeader(ModelView view, IndentingWriter writer) {
        String description;
        String title = view.getTitle();
        if (StringUtils.isNullOrEmpty((String)title)) {
            title = view.getName();
        }
        description = StringUtils.isNullOrEmpty((String)(description = view.getDescription())) ? "" : String.format("<br /><font point-size=\"24\">%s</font>", description);
        String fontName = DEFAULT_FONT;
        Font font = view.getViewSet().getConfiguration().getBranding().getFont();
        if (font != null) {
            fontName = font.getName();
        }
        RankDirection rankDirection = RankDirection.TopBottom;
        if (view.getAutomaticLayout() != null) {
            switch (view.getAutomaticLayout().getRankDirection()) {
                case TopBottom: {
                    rankDirection = RankDirection.TopBottom;
                    break;
                }
                case BottomTop: {
                    rankDirection = RankDirection.BottomTop;
                    break;
                }
                case LeftRight: {
                    rankDirection = RankDirection.LeftRight;
                    break;
                }
                case RightLeft: {
                    rankDirection = RankDirection.RightLeft;
                }
            }
        }
        writer.writeLine("digraph {");
        writer.indent();
        writer.writeLine("compound=true");
        writer.writeLine(String.format("graph [fontname=\"%s\", rankdir=%s, ranksep=1.0, nodesep=1.0]", fontName, rankDirection.getCode()));
        writer.writeLine(String.format("node [fontname=\"%s\", shape=box, margin=\"0.4,0.3\"]", fontName));
        writer.writeLine(String.format("edge [fontname=\"%s\"]", fontName));
        writer.writeLine(String.format("label=<<br /><font point-size=\"34\">%s</font>%s>", title, description));
        writer.writeLine();
    }

    @Override
    protected void writeFooter(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
    }

    @Override
    protected void startGroupBoundary(ModelView view, String group, IndentingWriter writer) {
        ElementStyle elementStyle;
        String color = "#cccccc";
        String groupName = group;
        String groupSeparator = (String)view.getModel().getProperties().get("structurizr.groupSeparator");
        if (!StringUtils.isNullOrEmpty((String)groupSeparator)) {
            groupName = group.substring(group.lastIndexOf(groupSeparator) + groupSeparator.length());
        }
        if ((elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle("Group:" + group)) == null || StringUtils.isNullOrEmpty((String)elementStyle.getColor())) {
            elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle("Group");
        }
        if (elementStyle != null && !StringUtils.isNullOrEmpty((String)elementStyle.getColor())) {
            color = elementStyle.getColor();
        }
        writer.writeLine("subgraph \"cluster_group_" + groupName + "\" {");
        writer.indent();
        writer.writeLine("margin=" + this.clusterInternalMargin);
        writer.writeLine(String.format("label=<<font point-size=\"24\"><br />%s</font>>", groupName));
        writer.writeLine("labelloc=b");
        writer.writeLine(String.format("color=\"%s\"", color));
        writer.writeLine(String.format("fontcolor=\"%s\"", color));
        writer.writeLine("fillcolor=\"#ffffff\"");
        writer.writeLine("style=\"dashed\"");
        writer.writeLine();
    }

    @Override
    protected void endGroupBoundary(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    @Override
    protected void startSoftwareSystemBoundary(ModelView view, SoftwareSystem softwareSystem, IndentingWriter writer) {
        String color = softwareSystem.equals(view.getSoftwareSystem()) ? "#444444" : "#cccccc";
        writer.writeLine(String.format("subgraph cluster_%s {", softwareSystem.getId()));
        writer.indent();
        writer.writeLine("margin=" + this.clusterInternalMargin);
        writer.writeLine(String.format("label=<<font point-size=\"24\"><br />%s</font><br /><font point-size=\"19\">%s</font>>", softwareSystem.getName(), this.typeOf(view, (Element)softwareSystem, true)));
        writer.writeLine("labelloc=b");
        writer.writeLine(String.format("color=\"%s\"", color));
        writer.writeLine(String.format("fontcolor=\"%s\"", color));
        writer.writeLine(String.format("fillcolor=\"%s\"", color));
        writer.writeLine();
    }

    @Override
    protected void endSoftwareSystemBoundary(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    @Override
    protected void startContainerBoundary(ModelView view, Container container, IndentingWriter writer) {
        String color = "#444444";
        if (view instanceof ComponentView) {
            color = container.equals(((ComponentView)view).getContainer()) ? "#444444" : "#cccccc";
        } else if (view instanceof DynamicView) {
            color = container.equals(((DynamicView)view).getElement()) ? "#444444" : "#cccccc";
        }
        writer.writeLine(String.format("subgraph cluster_%s {", container.getId()));
        writer.indent();
        writer.writeLine("margin=" + this.clusterInternalMargin);
        writer.writeLine(String.format("label=<<font point-size=\"24\"><br />%s</font><br /><font point-size=\"19\">%s</font>>", container.getName(), this.typeOf(view, (Element)container, true)));
        writer.writeLine("labelloc=b");
        writer.writeLine(String.format("color=\"%s\"", color));
        writer.writeLine(String.format("fontcolor=\"%s\"", color));
        writer.writeLine(String.format("fillcolor=\"%s\"", color));
        writer.writeLine();
    }

    @Override
    protected void endContainerBoundary(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    @Override
    protected void startDeploymentNodeBoundary(DeploymentView view, DeploymentNode deploymentNode, IndentingWriter writer) {
        ElementStyle elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle((Element)deploymentNode);
        writer.writeLine(String.format("subgraph cluster_%s {", deploymentNode.getId()));
        writer.indent();
        writer.writeLine("margin=" + this.clusterInternalMargin);
        writer.writeLine(String.format("label=<<font point-size=\"24\">%s</font><br /><font point-size=\"19\">%s</font>>", deploymentNode.getName(), this.typeOf((ModelView)view, (Element)deploymentNode, true)));
        writer.writeLine("labelloc=b");
        writer.writeLine(String.format("color=\"%s\"", elementStyle.getStroke()));
        writer.writeLine(String.format("fontcolor=\"%s\"", elementStyle.getColor()));
        writer.writeLine("fillcolor=\"#ffffff\"");
        writer.writeLine();
    }

    @Override
    protected void endDeploymentNodeBoundary(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    @Override
    protected void writeElement(ModelView view, Element element, IndentingWriter writer) {
        ElementStyle elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle(element);
        if (elementStyle.getWidth() == null) {
            elementStyle.setWidth(Integer.valueOf(450));
        }
        if (elementStyle.getHeight() == null) {
            elementStyle.setHeight(Integer.valueOf(300));
        }
        int nameFontSize = elementStyle.getFontSize() + 10;
        int metadataFontSize = elementStyle.getFontSize() - 5;
        int descriptionFontSize = elementStyle.getFontSize();
        String shape = this.shapeOf(view, element);
        String name = element.getName();
        String description = element.getDescription();
        String type = this.typeOf(view, element, true);
        if (element instanceof StaticStructureElementInstance) {
            StaticStructureElementInstance elementInstance = (StaticStructureElementInstance)element;
            name = elementInstance.getElement().getName();
            description = elementInstance.getElement().getDescription();
            type = this.typeOf(view, (Element)elementInstance.getElement(), true);
            shape = this.shapeOf(view, (Element)elementInstance.getElement());
        }
        name = StringUtils.isNullOrEmpty((String)name) ? "" : String.format("<font point-size=\"%s\">%s</font>", nameFontSize, this.breakText(elementStyle.getWidth(), nameFontSize, this.escape(name)));
        description = StringUtils.isNullOrEmpty((String)description) || false == elementStyle.getDescription() ? "" : String.format("<br /><br /><font point-size=\"%s\">%s</font>", descriptionFontSize, this.breakText(elementStyle.getWidth(), descriptionFontSize, this.escape(description)));
        type = StringUtils.isNullOrEmpty((String)type) || false == elementStyle.getMetadata() ? "" : String.format("<br /><font point-size=\"%s\">%s</font>", metadataFontSize, type);
        writer.writeLine(String.format("%s [id=%s,shape=%s, label=<%s%s%s>, style=filled, color=\"%s\", fillcolor=\"%s\", fontcolor=\"%s\"]", element.getId(), element.getId(), shape, name, type, description, elementStyle.getStroke(), elementStyle.getBackground(), elementStyle.getColor()));
    }

    @Override
    protected void writeRelationship(ModelView view, RelationshipView relationshipView, IndentingWriter writer) {
        Element destination;
        Element source;
        RelationshipStyle relationshipStyle = view.getViewSet().getConfiguration().getStyles().findRelationshipStyle(relationshipView.getRelationship());
        relationshipStyle.setWidth(Integer.valueOf(400));
        int descriptionFontSize = relationshipStyle.getFontSize();
        int metadataFontSize = relationshipStyle.getFontSize() - 5;
        Object description = relationshipView.getDescription();
        if (StringUtils.isNullOrEmpty((String)description)) {
            description = relationshipView.getRelationship().getDescription();
        }
        if (!StringUtils.isNullOrEmpty((String)relationshipView.getOrder())) {
            description = relationshipView.getOrder() + ". " + (String)description;
        }
        if (StringUtils.isNullOrEmpty((String)description)) {
            description = "";
        } else {
            description = this.breakText(relationshipStyle.getWidth(), descriptionFontSize, (String)description);
            description = String.format("<font point-size=\"%s\">%s</font>", descriptionFontSize, description);
        }
        String technology = relationshipView.getRelationship().getTechnology();
        technology = StringUtils.isNullOrEmpty((String)technology) ? "" : String.format("<br /><font point-size=\"%s\">[%s]</font>", metadataFontSize, technology);
        Object clusterConfig = "";
        if (relationshipView.getRelationship().getSource() instanceof DeploymentNode || relationshipView.getRelationship().getDestination() instanceof DeploymentNode) {
            source = relationshipView.getRelationship().getSource();
            if (source instanceof DeploymentNode) {
                source = this.findElementInside((DeploymentNode)source, view);
            }
            if ((destination = relationshipView.getRelationship().getDestination()) instanceof DeploymentNode) {
                destination = this.findElementInside((DeploymentNode)destination, view);
            }
            if (source != null && destination != null) {
                if (relationshipView.getRelationship().getSource() instanceof DeploymentNode) {
                    clusterConfig = (String)clusterConfig + ",ltail=cluster_" + relationshipView.getRelationship().getSource().getId();
                }
                if (relationshipView.getRelationship().getDestination() instanceof DeploymentNode) {
                    clusterConfig = (String)clusterConfig + ",lhead=cluster_" + relationshipView.getRelationship().getDestination().getId();
                }
            }
        } else {
            source = relationshipView.getRelationship().getSource();
            destination = relationshipView.getRelationship().getDestination();
            if (relationshipView.isResponse() != null && relationshipView.isResponse().booleanValue()) {
                source = relationshipView.getRelationship().getDestination();
                destination = relationshipView.getRelationship().getSource();
            }
        }
        boolean solid = relationshipStyle.getStyle() == LineStyle.Solid || false == relationshipStyle.getDashed();
        writer.writeLine(String.format("%s -> %s [id=%s, label=<%s%s>, style=\"%s\", color=\"%s\", fontcolor=\"%s\"%s]", source.getId(), destination.getId(), relationshipView.getId(), description, technology, solid ? "solid" : "dashed", relationshipStyle.getColor(), relationshipStyle.getColor(), clusterConfig));
    }

    private String escape(String s) {
        if (StringUtils.isNullOrEmpty((String)s)) {
            return s;
        }
        return s.replaceAll("\"", "\\\\\"");
    }

    private String shapeOf(ModelView view, Element element) {
        if (element instanceof DeploymentNode) {
            return "node";
        }
        Shape shape = view.getViewSet().getConfiguration().getStyles().findElementStyle(element).getShape();
        switch (shape) {
            case Circle: {
                return "circle";
            }
            case Component: {
                return "component";
            }
            case Cylinder: {
                return "cylinder";
            }
            case Ellipse: {
                return "ellipse";
            }
            case Folder: {
                return "folder";
            }
            case Hexagon: {
                return "hexagon";
            }
            case Diamond: {
                return "diamond";
            }
        }
        return "rect";
    }

    private Element findElementInside(DeploymentNode deploymentNode, ModelView view) {
        for (SoftwareSystemInstance softwareSystemInstance : deploymentNode.getSoftwareSystemInstances()) {
            if (!view.isElementInView((Element)softwareSystemInstance)) continue;
            return softwareSystemInstance;
        }
        for (ContainerInstance containerInstance : deploymentNode.getContainerInstances()) {
            if (!view.isElementInView((Element)containerInstance)) continue;
            return containerInstance;
        }
        for (InfrastructureNode infrastructureNode : deploymentNode.getInfrastructureNodes()) {
            if (!view.isElementInView((Element)infrastructureNode)) continue;
            return infrastructureNode;
        }
        if (deploymentNode.hasChildren()) {
            for (DeploymentNode child : deploymentNode.getChildren()) {
                Element element = this.findElementInside(child, view);
                if (element == null) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    protected Diagram createDiagram(ModelView view, String definition) {
        return new DOTDiagram(view, definition);
    }
}

