/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.export.plantuml;

import com.structurizr.export.IndentingWriter;
import com.structurizr.export.plantuml.PlantUMLStyle;
import com.structurizr.util.StringUtils;

class PlantUMLRootStyle
extends PlantUMLStyle {
    private final String background;
    private final String color;
    private final String fontName;

    PlantUMLRootStyle(String background, String color, String fontName) {
        super(".root");
        this.background = background;
        this.color = color;
        this.fontName = fontName;
    }

    @Override
    String getClassSelector() {
        return "root";
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass();
    }

    public String toString() {
        IndentingWriter writer = new IndentingWriter();
        writer.indent();
        writer.writeLine(String.format("%s {", this.getClassSelector()));
        writer.indent();
        writer.writeLine(String.format("BackgroundColor: %s;", this.background));
        writer.writeLine(String.format("FontColor: %s;", this.color));
        if (!StringUtils.isNullOrEmpty((String)this.fontName)) {
            writer.writeLine(String.format("FontName: %s;", this.fontName));
        }
        writer.outdent();
        writer.writeLine("}");
        writer.outdent();
        writer.writeLine();
        return writer.toString();
    }
}

