/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.export.plantuml;

import com.structurizr.export.Diagram;
import com.structurizr.export.IndentingWriter;
import com.structurizr.export.Legend;
import com.structurizr.export.plantuml.AbstractPlantUMLExporter;
import com.structurizr.export.plantuml.PlantUMLBoundaryStyle;
import com.structurizr.export.plantuml.PlantUMLDeploymentNodeStyle;
import com.structurizr.export.plantuml.PlantUMLElementStyle;
import com.structurizr.export.plantuml.PlantUMLGroupStyle;
import com.structurizr.export.plantuml.PlantUMLLegendStyle;
import com.structurizr.export.plantuml.PlantUMLRelationshipStyle;
import com.structurizr.export.plantuml.PlantUMLRootStyle;
import com.structurizr.export.plantuml.PlantUMLStyle;
import com.structurizr.model.Container;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.StaticStructureElementInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.Border;
import com.structurizr.view.ColorScheme;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.Font;
import com.structurizr.view.ModelView;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.RelationshipView;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class StructurizrPlantUMLExporter
extends AbstractPlantUMLExporter {
    public static final String PLANTUML_SHADOW = "plantuml.shadow";
    private static final int DEFAULT_WIDTH = 450;
    private static final int DEFAULT_HEIGHT = 300;
    private static final int DEFAULT_STROKE_WIDTH = 2;
    private static final double METADATA_FONT_SIZE_RATIO = 0.7;
    private static final int MAX_ICON_SIZE_RATIO = 3;
    private Set<PlantUMLStyle> plantUMLStyles;

    public StructurizrPlantUMLExporter() {
        this(ColorScheme.Light);
    }

    public StructurizrPlantUMLExporter(ColorScheme colorScheme) {
        super(colorScheme);
    }

    @Override
    protected void writeHeader(ModelView view, IndentingWriter writer) {
        this.plantUMLStyles = new HashSet<PlantUMLStyle>();
        super.writeHeader(view, writer);
        if (!this.renderAsSequenceDiagram(view)) {
            if (view.getAutomaticLayout() != null) {
                switch (view.getAutomaticLayout().getRankDirection()) {
                    case LeftRight: {
                        writer.writeLine("left to right direction");
                        break;
                    }
                    default: {
                        writer.writeLine("top to bottom direction");
                    }
                }
                writer.writeLine("skinparam ranksep " + view.getAutomaticLayout().getRankSeparation() / 5);
                writer.writeLine("skinparam nodesep " + view.getAutomaticLayout().getNodeSeparation() / 10);
            } else {
                writer.writeLine("top to bottom direction");
            }
        }
        writer.writeLine("hide stereotype");
        this.writeSkinParams(writer);
        writer.writeLine("<style></style>");
        writer.writeLine();
        String fontName = null;
        Font font = view.getViewSet().getConfiguration().getBranding().getFont();
        if (font != null && !StringUtils.isNullOrEmpty((String)(fontName = font.getName()))) {
            writer.writeLine("FontName: " + fontName);
        }
        if (this.colorScheme == ColorScheme.Dark) {
            this.plantUMLStyles.add(new PlantUMLRootStyle("#111111", "#cccccc", fontName));
        } else {
            this.plantUMLStyles.add(new PlantUMLRootStyle("#ffffff", "#444444", fontName));
        }
        this.writeIncludes(view, writer);
    }

    @Override
    protected void writeFooter(ModelView view, IndentingWriter writer) {
        super.writeFooter(view, writer);
        this.writeStyles(writer);
    }

    private void writeStyles(IndentingWriter writer) {
        StringBuilder styles = new StringBuilder();
        List<PlantUMLStyle> sortedStyles = this.plantUMLStyles.stream().sorted(Comparator.comparing(PlantUMLStyle::getName)).toList();
        sortedStyles.stream().filter(style -> style instanceof PlantUMLRootStyle).forEach(style -> styles.append(style.toString()));
        sortedStyles.stream().filter(style -> style instanceof PlantUMLElementStyle).forEach(style -> styles.append(style.toString()));
        sortedStyles.stream().filter(style -> style instanceof PlantUMLRelationshipStyle).forEach(style -> styles.append(style.toString()));
        sortedStyles.stream().filter(style -> style instanceof PlantUMLDeploymentNodeStyle).forEach(style -> styles.append(style.toString()));
        sortedStyles.stream().filter(style -> style instanceof PlantUMLBoundaryStyle).forEach(style -> styles.append(style.toString()));
        sortedStyles.stream().filter(style -> style instanceof PlantUMLGroupStyle).forEach(style -> styles.append(style.toString()));
        sortedStyles.stream().filter(style -> style instanceof PlantUMLLegendStyle).forEach(style -> styles.append(style.toString()));
        writer.replace("<style></style>", "<style>\n" + styles + "</style>");
    }

    @Override
    protected void startGroupBoundary(ModelView view, String group, IndentingWriter writer) {
        String groupName = group;
        String groupSeparator = (String)view.getModel().getProperties().get("structurizr.groupSeparator");
        if (!StringUtils.isNullOrEmpty((String)groupSeparator)) {
            groupName = group.substring(group.lastIndexOf(groupSeparator) + groupSeparator.length());
        }
        ElementStyle elementStyle = this.findGroupStyle(view, group);
        PlantUMLGroupStyle plantUMLBoundaryStyle = new PlantUMLGroupStyle(group, elementStyle.getBackground(), elementStyle.getColor(), elementStyle.getStroke(), elementStyle.getStrokeWidth() != null ? elementStyle.getStrokeWidth() : 2, elementStyle.getBorder(), elementStyle.getFontSize(), "true".equalsIgnoreCase(elementStyle.getProperties().getOrDefault(PLANTUML_SHADOW, "false")));
        this.plantUMLStyles.add(plantUMLBoundaryStyle);
        if (!this.renderAsSequenceDiagram(view)) {
            Object icon = elementStyle.getIcon();
            if (!StringUtils.isNullOrEmpty((String)icon)) {
                double scale = this.calculateIconScale((String)icon, elementStyle.getFontSize() * 3);
                icon = "\\n\\n<img:" + (String)icon + "{scale=" + scale + "}>";
            } else {
                icon = "";
            }
            writer.writeLine(String.format("rectangle \"%s%s\" <<%s>> as group%s {", groupName, icon, this.classSelectorForGroup(group), Base64.getEncoder().encodeToString(group.getBytes())));
            writer.indent();
        }
    }

    @Override
    protected void endGroupBoundary(ModelView view, IndentingWriter writer) {
        if (!this.renderAsSequenceDiagram(view)) {
            writer.outdent();
            writer.writeLine("}");
            writer.writeLine();
        }
    }

    @Override
    protected void startSoftwareSystemBoundary(ModelView view, SoftwareSystem softwareSystem, IndentingWriter writer) {
        if (!this.renderAsSequenceDiagram(view)) {
            ElementStyle elementStyle = this.findBoundaryStyle(view, (Element)softwareSystem);
            PlantUMLBoundaryStyle plantUMLBoundaryStyle = new PlantUMLBoundaryStyle(softwareSystem.getName(), elementStyle.getBackground(), elementStyle.getColor(), elementStyle.getStroke(), elementStyle.getStrokeWidth() != null ? elementStyle.getStrokeWidth() : 2, elementStyle.getBorder(), elementStyle.getFontSize(), "true".equalsIgnoreCase(elementStyle.getProperties().getOrDefault(PLANTUML_SHADOW, "false")));
            this.plantUMLStyles.add(plantUMLBoundaryStyle);
            writer.writeLine(String.format("rectangle \"%s\\n<size:%s>%s</size>\" <<%s>> {", softwareSystem.getName(), this.calculateMetadataFontSize(elementStyle.getFontSize()), this.typeOf(view, (Element)softwareSystem, true), plantUMLBoundaryStyle.getClassSelector()));
            writer.indent();
        }
    }

    @Override
    protected void endSoftwareSystemBoundary(ModelView view, IndentingWriter writer) {
        if (!this.renderAsSequenceDiagram(view)) {
            writer.outdent();
            writer.writeLine("}");
            writer.writeLine();
        }
    }

    @Override
    protected void startContainerBoundary(ModelView view, Container container, IndentingWriter writer) {
        if (!this.renderAsSequenceDiagram(view)) {
            ElementStyle elementStyle = this.findBoundaryStyle(view, (Element)container);
            PlantUMLBoundaryStyle plantUMLBoundaryStyle = new PlantUMLBoundaryStyle(container.getName(), elementStyle.getBackground(), elementStyle.getColor(), elementStyle.getStroke(), elementStyle.getStrokeWidth() != null ? elementStyle.getStrokeWidth() : 2, elementStyle.getBorder(), elementStyle.getFontSize(), "true".equalsIgnoreCase(elementStyle.getProperties().getOrDefault(PLANTUML_SHADOW, "false")));
            this.plantUMLStyles.add(plantUMLBoundaryStyle);
            writer.writeLine(String.format("rectangle \"%s\\n<size:%s>%s</size>\" <<%s>> {", container.getName(), this.calculateMetadataFontSize(this.findBoundaryStyle(view, (Element)container).getFontSize()), this.typeOf(view, (Element)container, true), plantUMLBoundaryStyle.getClassSelector()));
            writer.indent();
        }
    }

    @Override
    protected void endContainerBoundary(ModelView view, IndentingWriter writer) {
        if (!this.renderAsSequenceDiagram(view)) {
            writer.outdent();
            writer.writeLine("}");
            writer.writeLine();
        }
    }

    @Override
    protected void startDeploymentNodeBoundary(DeploymentView view, DeploymentNode deploymentNode, IndentingWriter writer) {
        Object url;
        ElementStyle elementStyle = this.findElementStyle((ModelView)view, (Element)deploymentNode);
        PlantUMLDeploymentNodeStyle plantUMLDeploymentNodeStyle = new PlantUMLDeploymentNodeStyle(elementStyle.getTag(), elementStyle.getBackground(), elementStyle.getColor(), elementStyle.getStroke(), elementStyle.getStrokeWidth() != null ? elementStyle.getStrokeWidth() : 2, elementStyle.getBorder(), elementStyle.getFontSize(), elementStyle.getIcon(), "true".equalsIgnoreCase(elementStyle.getProperties().getOrDefault(PLANTUML_SHADOW, "false")));
        this.plantUMLStyles.add(plantUMLDeploymentNodeStyle);
        Object icon = "";
        if (this.isSupportedIcon(elementStyle.getIcon())) {
            double scale = this.calculateIconScale(elementStyle.getIcon(), elementStyle.getFontSize() * 3);
            icon = "\\n\\n<img:" + elementStyle.getIcon() + "{scale=" + scale + "}>";
        }
        url = !StringUtils.isNullOrEmpty((String)(url = deploymentNode.getUrl())) ? " [[" + (String)url + "]]" : "";
        writer.writeLine(String.format("rectangle \"%s\\n<size:%s>%s</size>%s\" <<%s>> as %s%s {", deploymentNode.getName() + (String)(!"1".equals(deploymentNode.getInstances()) ? " (x" + deploymentNode.getInstances() + ")" : ""), this.calculateMetadataFontSize(this.findElementStyle((ModelView)view, (Element)deploymentNode).getFontSize()), this.typeOf((ModelView)view, (Element)deploymentNode, true), icon, plantUMLDeploymentNodeStyle.getClassSelector(), this.idOf((ModelItem)deploymentNode), url));
        writer.indent();
        if (!this.isVisible((ModelView)view, (Element)deploymentNode)) {
            writer.writeLine("hide " + this.idOf((ModelItem)deploymentNode));
        }
    }

    @Override
    protected void endDeploymentNodeBoundary(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    @Override
    public Diagram export(DynamicView view) {
        if (this.renderAsSequenceDiagram((ModelView)view)) {
            IndentingWriter writer = new IndentingWriter();
            this.writeHeader((ModelView)view, writer);
            LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
            for (RelationshipView relationshipView : view.getRelationships()) {
                elements.add(relationshipView.getRelationship().getSource());
                elements.add(relationshipView.getRelationship().getDestination());
            }
            for (Element element : elements) {
                this.writeElement((ModelView)view, element, writer);
            }
            if (!elements.isEmpty()) {
                writer.writeLine();
            }
            this.writeRelationships((ModelView)view, writer);
            this.writeFooter((ModelView)view, writer);
            Diagram diagram = this.createDiagram((ModelView)view, writer.toString());
            diagram.setLegend(this.createLegend((ModelView)view));
            return diagram;
        }
        return super.export(view);
    }

    @Override
    protected void writeElement(ModelView view, Element element, IndentingWriter writer) {
        ElementStyle elementStyle = this.findElementStyle(view, element);
        if (elementStyle.getWidth() == null) {
            elementStyle.setWidth(Integer.valueOf(450));
        }
        if (elementStyle.getHeight() == null) {
            elementStyle.setHeight(Integer.valueOf(300));
        }
        String sequenceDiagramShape = this.plantumlSequenceType(view, element);
        if (this.renderAsSequenceDiagram(view) && ("actor".equals(sequenceDiagramShape) || "database".equals(sequenceDiagramShape))) {
            elementStyle.color(elementStyle.getStroke());
        }
        PlantUMLElementStyle plantUMLElementStyle = new PlantUMLElementStyle(elementStyle.getTag(), elementStyle.getShape(), elementStyle.getWidth(), elementStyle.getBackground(), elementStyle.getColor(), elementStyle.getStroke(), this.renderAsSequenceDiagram(view) ? 2 : (elementStyle.getStrokeWidth() != null ? elementStyle.getStrokeWidth() : 2), elementStyle.getBorder(), elementStyle.getFontSize(), elementStyle.getIcon(), "true".equalsIgnoreCase(elementStyle.getProperties().getOrDefault(PLANTUML_SHADOW, "false")));
        this.plantUMLStyles.add(plantUMLElementStyle);
        int metadataFontSize = this.calculateMetadataFontSize(elementStyle.getFontSize());
        if (this.renderAsSequenceDiagram(view)) {
            writer.writeLine(String.format("%s \"%s\\n<size:%s>%s</size>\" as %s <<%s>>", sequenceDiagramShape, element.getName(), metadataFontSize, this.typeOf(view, element, true), this.idOf((ModelItem)element), plantUMLElementStyle.getClassSelector()));
        } else {
            String shape = this.plantUMLShapeOf(view, element);
            String name = element.getName();
            Object description = element.getDescription();
            String type = this.typeOf(view, element, true);
            Object icon = "";
            Object url = element.getUrl();
            if (element instanceof StaticStructureElementInstance) {
                StaticStructureElementInstance elementInstance = (StaticStructureElementInstance)element;
                name = elementInstance.getElement().getName();
                description = elementInstance.getElement().getDescription();
                type = this.typeOf(view, (Element)elementInstance.getElement(), true);
                shape = this.plantUMLShapeOf(view, (Element)elementInstance.getElement());
                url = elementInstance.getUrl();
                if (StringUtils.isNullOrEmpty((String)url)) {
                    url = elementInstance.getElement().getUrl();
                }
            }
            url = !StringUtils.isNullOrEmpty((String)url) ? " [[" + (String)url + "]]" : "";
            description = StringUtils.isNullOrEmpty((String)description) || false == elementStyle.getDescription() ? "" : "\\n\\n" + (String)description;
            type = StringUtils.isNullOrEmpty((String)type) || false == elementStyle.getMetadata() ? "" : String.format("\\n<size:%s>%s</size>", metadataFontSize, type);
            if (this.isSupportedIcon(elementStyle.getIcon())) {
                double scale = this.calculateIconScale(elementStyle.getIcon(), elementStyle.getFontSize() * 3);
                icon = "\\n\\n<img:" + elementStyle.getIcon() + "{scale=" + scale + "}>";
            }
            String classSelector = plantUMLElementStyle.getClassSelector();
            String id = this.idOf((ModelItem)element);
            writer.writeLine(String.format("%s \"==%s%s%s%s\" <<%s>> as %s%s", shape, name, type, icon, description, classSelector, id, url));
            if (!this.isVisible(view, element)) {
                writer.writeLine("hide " + id);
            }
        }
    }

    @Override
    protected void writeRelationship(ModelView view, RelationshipView relationshipView, IndentingWriter writer) {
        Relationship relationship = relationshipView.getRelationship();
        RelationshipStyle style = this.findRelationshipStyle(view, relationship);
        PlantUMLRelationshipStyle plantUMLRelationshipStyle = new PlantUMLRelationshipStyle(style.getTag(), style.getColor(), style.getStyle(), this.renderAsSequenceDiagram(view) ? 2 : style.getThickness(), style.getFontSize());
        this.plantUMLStyles.add(plantUMLRelationshipStyle);
        int metadataFontSize = this.calculateMetadataFontSize(style.getFontSize());
        Object description = "";
        String technology = relationship.getTechnology();
        if (!StringUtils.isNullOrEmpty((String)relationshipView.getOrder())) {
            description = relationshipView.getOrder() + ": ";
        }
        description = (String)description + (this.hasValue(relationshipView.getDescription()) ? relationshipView.getDescription() : (this.hasValue(relationshipView.getRelationship().getDescription()) ? relationshipView.getRelationship().getDescription() : ""));
        if (this.renderAsSequenceDiagram(view)) {
            String arrowStart = "-";
            String arrowEnd = ">";
            if (relationshipView.isResponse() != null && relationshipView.isResponse().booleanValue()) {
                arrowStart = "<-";
                arrowEnd = "-";
            }
            writer.writeLine(String.format("%s %s%s %s <<%s>> : %s%s", this.idOf((ModelItem)relationship.getSource()), arrowStart, arrowEnd, this.idOf((ModelItem)relationship.getDestination()), plantUMLRelationshipStyle.getClassSelector(), description, StringUtils.isNullOrEmpty((String)technology) ? "" : "\\n<size:" + metadataFontSize + ">[" + technology + "]</size>"));
        } else {
            String arrow = relationshipView.isResponse() != null && relationshipView.isResponse() != false ? "<--" : "-->";
            writer.writeLine(String.format("%s %s %s <<%s>> : \"%s%s\"", this.idOf((ModelItem)relationship.getSource()), arrow, this.idOf((ModelItem)relationship.getDestination()), plantUMLRelationshipStyle.getClassSelector(), description, StringUtils.isNullOrEmpty((String)technology) ? "" : "\\n<size:" + metadataFontSize + ">[" + technology + "]</size>"));
        }
    }

    @Override
    protected Legend createLegend(ModelView view) {
        IndentingWriter writer = new IndentingWriter();
        writer.writeLine("@startuml");
        writer.writeLine();
        writer.writeLine("set separator none");
        writer.writeLine("hide stereotype");
        writer.writeLine();
        writer.writeLine("<style></style>");
        writer.writeLine();
        this.plantUMLStyles.stream().sorted(Comparator.comparing(PlantUMLStyle::getName)).filter(style -> style instanceof PlantUMLDeploymentNodeStyle).map(style -> (PlantUMLDeploymentNodeStyle)style).forEach(style -> {
            style.setWidth(200);
            String description = style.getName();
            if (description.startsWith("Element,")) {
                description = description.substring("Element,".length());
            }
            description = description.replaceAll(",", ", ");
            Object icon = "";
            if (this.isSupportedIcon(style.getIcon())) {
                double scale = this.calculateIconScale(style.getIcon(), style.getFontSize() * 3);
                icon = "\\n\\n<img:" + style.getIcon() + "{scale=" + scale + "}>";
            }
            writer.writeLine(String.format("rectangle \"==%s%s\" <<%s>>", description, icon, style.getClassSelector()));
            writer.writeLine();
        });
        this.plantUMLStyles.stream().sorted(Comparator.comparing(PlantUMLStyle::getName)).filter(style -> style instanceof PlantUMLElementStyle).map(style -> (PlantUMLElementStyle)style).forEach(style -> {
            style.setWidth(200);
            String description = style.getName();
            if (description.startsWith("Element,")) {
                description = description.substring("Element,".length());
            }
            description = description.replaceAll(",", ", ");
            Object icon = "";
            if (this.isSupportedIcon(style.getIcon())) {
                double scale = this.calculateIconScale(style.getIcon(), style.getFontSize() * 3);
                icon = "\\n\\n<img:" + style.getIcon() + "{scale=" + scale + "}>";
            }
            writer.writeLine(String.format("%s \"==%s%s\" <<%s>>", this.plantUMLShapeOf(style.getShape()), description, icon, style.getClassSelector()));
            writer.writeLine();
        });
        int id = 0;
        List<PlantUMLRelationshipStyle> relationshipStyles = this.plantUMLStyles.stream().sorted(Comparator.comparing(PlantUMLStyle::getName)).filter(style -> style instanceof PlantUMLRelationshipStyle).map(style -> (PlantUMLRelationshipStyle)style).toList();
        for (PlantUMLRelationshipStyle relationshipStyle : relationshipStyles) {
            ++id;
            String description = relationshipStyle.getName();
            if (description.startsWith("Relationship,")) {
                description = description.substring("Relationship,".length());
            }
            description = description.replaceAll(",", ", ");
            writer.writeLine(String.format("rectangle \".\" <<.Element-Transparent>> as %s", id));
            writer.writeLine(String.format("%s --> %s <<%s>> : \"%s\"", id, id, relationshipStyle.getClassSelector(), description));
            writer.writeLine();
        }
        writer.writeLine("@enduml");
        this.plantUMLStyles.add(new PlantUMLLegendStyle());
        this.writeStyles(writer);
        return new Legend(writer.toString());
    }

    protected boolean renderAsSequenceDiagram(ModelView view) {
        return view instanceof DynamicView && "true".equalsIgnoreCase(this.getViewOrViewSetProperty(view, "plantuml.sequenceDiagram", "false"));
    }

    private ElementStyle findBoundaryStyle(ModelView view, Element element) {
        String background = this.colorScheme == ColorScheme.Dark ? "#111111" : "#ffffff";
        String stroke = this.colorScheme == ColorScheme.Dark ? "#cccccc" : "#444444";
        int strokeWidth = 2;
        Border border = Border.Dotted;
        String color = this.colorScheme == ColorScheme.Dark ? "#cccccc" : "#444444";
        String icon = "";
        int fontSize = 24;
        String type = element instanceof SoftwareSystem ? "SoftwareSystem" : "Container";
        ElementStyle style = new ElementStyle("");
        ElementStyle elementStyleForBoundary = this.findElementStyle(view, "Boundary:" + type);
        ElementStyle elementStyleForAllBoundaries = this.findElementStyle(view, "Boundary");
        ElementStyle elementStyleForElement = this.findElementStyle(view, element);
        if (elementStyleForBoundary != null && !StringUtils.isNullOrEmpty((String)elementStyleForBoundary.getBackground())) {
            background = elementStyleForBoundary.getBackground();
        } else if (elementStyleForAllBoundaries != null && !StringUtils.isNullOrEmpty((String)elementStyleForAllBoundaries.getBackground())) {
            background = elementStyleForAllBoundaries.getBackground();
        }
        style.setBackground(background);
        if (elementStyleForBoundary != null && !StringUtils.isNullOrEmpty((String)elementStyleForBoundary.getStroke())) {
            stroke = elementStyleForBoundary.getStroke();
        } else if (elementStyleForAllBoundaries != null && !StringUtils.isNullOrEmpty((String)elementStyleForAllBoundaries.getStroke())) {
            stroke = elementStyleForAllBoundaries.getStroke();
        } else if (!StringUtils.isNullOrEmpty((String)elementStyleForElement.getStroke())) {
            stroke = elementStyleForElement.getStroke();
        }
        style.setStroke(stroke);
        if (elementStyleForBoundary != null && elementStyleForBoundary.getStrokeWidth() != null) {
            strokeWidth = elementStyleForBoundary.getStrokeWidth();
        } else if (elementStyleForAllBoundaries != null && elementStyleForAllBoundaries.getStrokeWidth() != null) {
            strokeWidth = elementStyleForAllBoundaries.getStrokeWidth();
        } else if (elementStyleForElement.getStrokeWidth() != null) {
            strokeWidth = elementStyleForElement.getStrokeWidth();
        }
        style.setStrokeWidth(Integer.valueOf(strokeWidth));
        if (elementStyleForBoundary != null && !StringUtils.isNullOrEmpty((String)elementStyleForBoundary.getColor())) {
            color = elementStyleForBoundary.getColor();
        } else if (elementStyleForAllBoundaries != null && !StringUtils.isNullOrEmpty((String)elementStyleForAllBoundaries.getColor())) {
            color = elementStyleForAllBoundaries.getColor();
        } else if (!StringUtils.isNullOrEmpty((String)elementStyleForElement.getColor())) {
            color = elementStyleForElement.getColor();
        }
        style.setColor(color);
        if (elementStyleForBoundary != null && elementStyleForBoundary.getBorder() != null) {
            border = elementStyleForBoundary.getBorder();
        } else if (elementStyleForAllBoundaries != null && elementStyleForAllBoundaries.getBorder() != null) {
            border = elementStyleForAllBoundaries.getBorder();
        } else if (elementStyleForElement.getBorder() != null) {
            border = elementStyleForElement.getBorder();
        }
        style.setBorder(border);
        if (elementStyleForBoundary != null && this.isSupportedIcon(elementStyleForBoundary.getIcon())) {
            icon = elementStyleForBoundary.getIcon();
        } else if (elementStyleForAllBoundaries != null && this.isSupportedIcon(elementStyleForAllBoundaries.getIcon())) {
            icon = elementStyleForAllBoundaries.getIcon();
        } else if (this.isSupportedIcon(elementStyleForElement.getIcon())) {
            icon = elementStyleForElement.getIcon();
        }
        style.setIcon(icon);
        if (elementStyleForBoundary != null && elementStyleForBoundary.getFontSize() != null) {
            fontSize = elementStyleForBoundary.getFontSize();
        } else if (elementStyleForAllBoundaries != null && elementStyleForAllBoundaries.getFontSize() != null) {
            fontSize = elementStyleForAllBoundaries.getFontSize();
        } else if (elementStyleForElement.getFontSize() != null) {
            fontSize = elementStyleForElement.getFontSize();
        }
        style.setFontSize(Integer.valueOf(fontSize));
        return style;
    }

    private String classSelectorForGroup(String group) {
        return "Group-" + Base64.getEncoder().encodeToString(group.getBytes());
    }

    private ElementStyle findGroupStyle(ModelView view, String group) {
        String background = this.colorScheme == ColorScheme.Dark ? "#111111" : "#ffffff";
        String stroke = this.colorScheme == ColorScheme.Dark ? "#cccccc" : "#444444";
        int strokeWidth = 2;
        Border border = Border.Dotted;
        String color = this.colorScheme == ColorScheme.Dark ? "#cccccc" : "#444444";
        String icon = "";
        int fontSize = 24;
        ElementStyle style = new ElementStyle("");
        ElementStyle elementStyleForGroup = this.findElementStyle(view, "Group:" + group);
        ElementStyle elementStyleForAllGroups = this.findElementStyle(view, "Group");
        if (elementStyleForGroup != null && !StringUtils.isNullOrEmpty((String)elementStyleForGroup.getBackground())) {
            background = elementStyleForGroup.getBackground();
        } else if (elementStyleForAllGroups != null && !StringUtils.isNullOrEmpty((String)elementStyleForAllGroups.getBackground())) {
            background = elementStyleForAllGroups.getBackground();
        }
        style.setBackground(background);
        if (elementStyleForGroup != null && !StringUtils.isNullOrEmpty((String)elementStyleForGroup.getStroke())) {
            stroke = elementStyleForGroup.getStroke();
        } else if (elementStyleForAllGroups != null && !StringUtils.isNullOrEmpty((String)elementStyleForAllGroups.getStroke())) {
            stroke = elementStyleForAllGroups.getStroke();
        }
        style.setStroke(stroke);
        if (elementStyleForGroup != null && elementStyleForGroup.getStrokeWidth() != null) {
            strokeWidth = elementStyleForGroup.getStrokeWidth();
        } else if (elementStyleForAllGroups != null && elementStyleForAllGroups.getStrokeWidth() != null) {
            strokeWidth = elementStyleForAllGroups.getStrokeWidth();
        }
        style.setStrokeWidth(Integer.valueOf(strokeWidth));
        if (elementStyleForGroup != null && !StringUtils.isNullOrEmpty((String)elementStyleForGroup.getColor())) {
            color = elementStyleForGroup.getColor();
        } else if (elementStyleForAllGroups != null && !StringUtils.isNullOrEmpty((String)elementStyleForAllGroups.getColor())) {
            color = elementStyleForAllGroups.getColor();
        }
        style.setColor(color);
        if (elementStyleForGroup != null && elementStyleForGroup.getBorder() != null) {
            border = elementStyleForGroup.getBorder();
        } else if (elementStyleForAllGroups != null && elementStyleForAllGroups.getBorder() != null) {
            border = elementStyleForAllGroups.getBorder();
        }
        style.setBorder(border);
        if (elementStyleForGroup != null && this.isSupportedIcon(elementStyleForGroup.getIcon())) {
            icon = elementStyleForGroup.getIcon();
        } else if (elementStyleForAllGroups != null && this.isSupportedIcon(elementStyleForAllGroups.getIcon())) {
            icon = elementStyleForAllGroups.getColor();
        }
        style.setIcon(icon);
        if (elementStyleForGroup != null && elementStyleForGroup.getFontSize() != null) {
            fontSize = elementStyleForGroup.getFontSize();
        } else if (elementStyleForAllGroups != null && elementStyleForAllGroups.getFontSize() != null) {
            fontSize = elementStyleForAllGroups.getFontSize();
        }
        style.setFontSize(Integer.valueOf(fontSize));
        return style;
    }

    private int calculateMetadataFontSize(int fontSize) {
        return (int)Math.floor((double)fontSize * 0.7);
    }

    private String toLineStyle(ElementStyle elementStyle) {
        int strokeWidth = elementStyle.getStrokeWidth() != null ? elementStyle.getStrokeWidth() : 2;
        switch (elementStyle.getBorder()) {
            case Dotted: {
                return strokeWidth * 1 + "-" + strokeWidth * 1;
            }
            case Dashed: {
                return strokeWidth * 5 + "-" + strokeWidth * 5;
            }
        }
        return "0";
    }
}

