/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.graphviz;

import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.view.Dimensions;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.ElementView;
import com.structurizr.view.ModelView;
import com.structurizr.view.PaperSize;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.Vertex;
import java.io.File;
import java.io.FileInputStream;
import java.util.LinkedHashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

class SVGReader {
    private File path;
    private boolean changePaperSize;
    private int margin;

    SVGReader(File path, int margin, boolean changePaperSize) {
        this.path = path;
        this.margin = margin;
        this.changePaperSize = changePaperSize;
    }

    void parseAndApplyLayout(ModelView view) throws Exception {
        String expression;
        File file = new File(this.path, view.getKey() + ".dot.svg");
        FileInputStream fileIS = new FileInputStream(file);
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(false);
        builderFactory.setValidating(false);
        builderFactory.setFeature("http://xml.org/sax/features/namespaces", false);
        builderFactory.setFeature("http://xml.org/sax/features/validation", false);
        builderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        builderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document xmlDocument = builder.parse(fileIS);
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xPath.compile("/svg/g[@class=\"graph\"]").evaluate(xmlDocument, XPathConstants.NODESET);
        String transform = nodeList.item(0).getAttributes().getNamedItem("transform").getNodeValue();
        String translate = transform.substring(transform.indexOf("translate"));
        String numbers = translate.substring(translate.indexOf("(") + 1, translate.indexOf(")"));
        int transformX = (int)Double.parseDouble(numbers.split(" ")[0]);
        int transformY = (int)Double.parseDouble(numbers.split(" ")[1]);
        int minimumX = Integer.MAX_VALUE;
        int minimumY = Integer.MAX_VALUE;
        int maximumX = Integer.MIN_VALUE;
        int maximumY = Integer.MIN_VALUE;
        for (ElementView elementView : view.getElements()) {
            if (elementView.getElement() instanceof DeploymentNode || (nodeList = (NodeList)xPath.compile(expression = String.format("/svg/g/g[@id=\"%s\"]/polygon", elementView.getId())).evaluate(xmlDocument, XPathConstants.NODESET)).getLength() == 0) continue;
            String pointsAsString = nodeList.item(0).getAttributes().getNamedItem("points").getNodeValue();
            String[] points = pointsAsString.split(" ");
            String[] coordinates = points[1].split(",");
            double x = Double.parseDouble(coordinates[0]) + (double)transformX;
            double y = Double.parseDouble(coordinates[1]) + (double)transformY;
            elementView.setX((int)(x * 4.166666666666667));
            elementView.setY((int)(y * 4.166666666666667));
            minimumX = Math.min(elementView.getX(), minimumX);
            minimumY = Math.min(elementView.getY(), minimumY);
            ElementStyle style = view.getViewSet().getConfiguration().getStyles().findElementStyle(view.getModel().getElement(elementView.getId()));
            maximumX = Math.max(elementView.getX() + style.getWidth(), maximumX);
            maximumY = Math.max(elementView.getY() + style.getHeight(), maximumY);
        }
        for (RelationshipView relationshipView : view.getRelationships()) {
            expression = String.format("/svg/g/g[@id=\"%s\"]/path", relationshipView.getId());
            nodeList = (NodeList)xPath.compile(expression).evaluate(xmlDocument, XPathConstants.NODESET);
            if (nodeList.getLength() == 0) continue;
            String dAsString = nodeList.item(0).getAttributes().getNamedItem("d").getNodeValue();
            String[] d = dAsString.split(" ");
            LinkedHashSet<Vertex> vertices = new LinkedHashSet<Vertex>();
            if (d.length == 3) {
                relationshipView.setVertices(vertices);
                continue;
            }
            for (int i = 1; i < d.length - 2; ++i) {
                double x = Double.parseDouble(d[i].split(",")[0]) + (double)transformX;
                double y = Double.parseDouble(d[i].split(",")[1]) + (double)transformY;
                Vertex vertex = new Vertex((int)(x * 4.166666666666667), (int)(y * 4.166666666666667));
                vertices.add(vertex);
                minimumX = Math.min(vertex.getX(), minimumX);
                minimumY = Math.min(vertex.getY(), minimumY);
                maximumX = Math.max(vertex.getX(), maximumX);
                maximumY = Math.max(vertex.getY(), maximumY);
            }
            relationshipView.setVertices(vertices);
        }
        String expression2 = "/svg/g/g[@class=\"cluster\"]/polygon";
        nodeList = (NodeList)xPath.compile(expression2).evaluate(xmlDocument, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String[] points = nodeList.item(i).getAttributes().getNamedItem("points").getNodeValue().split(" ");
            for (String point : points) {
                int x = (int)((Double.parseDouble(point.split(",")[0]) + (double)transformX) * 4.166666666666667);
                int y = (int)((Double.parseDouble(point.split(",")[1]) + (double)transformY) * 4.166666666666667);
                minimumX = Math.min(x, minimumX);
                minimumY = Math.min(y, minimumY);
                maximumX = Math.max(x, maximumX);
                maximumY = Math.max(y, maximumY);
            }
        }
        int pageWidth = Math.max(this.margin, maximumX + this.margin);
        int pageHeight = Math.max(this.margin, maximumY + this.margin);
        if (this.changePaperSize) {
            view.setPaperSize(null);
            view.setDimensions(new Dimensions(pageWidth, pageHeight));
            PaperSize.Orientation orientation = pageWidth > pageHeight ? PaperSize.Orientation.Landscape : PaperSize.Orientation.Portrait;
            for (PaperSize paperSize : PaperSize.getOrderedPaperSizes((PaperSize.Orientation)orientation)) {
                if (paperSize.getWidth() <= pageWidth || paperSize.getHeight() <= pageHeight) continue;
                view.setPaperSize(paperSize);
                break;
            }
        }
        int deltaX = (pageWidth - maximumX + minimumX) / 2;
        int deltaY = (pageHeight - maximumY + minimumY) / 2;
        for (ElementView elementView : view.getElements()) {
            elementView.setX(elementView.getX() - minimumX);
            elementView.setY(elementView.getY() - minimumY);
        }
        for (RelationshipView relationshipView : view.getRelationships()) {
            for (Vertex vertex : relationshipView.getVertices()) {
                vertex.setX(vertex.getX() - minimumX);
                vertex.setY(vertex.getY() - minimumY);
            }
        }
        for (ElementView elementView : view.getElements()) {
            elementView.setX(elementView.getX() + deltaX);
            elementView.setY(elementView.getY() + deltaY);
        }
        for (RelationshipView relationshipView : view.getRelationships()) {
            for (Vertex vertex : relationshipView.getVertices()) {
                vertex.setX(vertex.getX() + deltaX);
                vertex.setY(vertex.getY() + deltaY);
            }
        }
    }

    private int getElementWidth(ModelView view, String elementId) {
        Element element = view.getModel().getElement(elementId);
        return view.getViewSet().getConfiguration().getStyles().findElementStyle(element).getWidth();
    }

    private int getElementHeight(ModelView view, String elementId) {
        Element element = view.getModel().getElement(elementId);
        return view.getViewSet().getConfiguration().getStyles().findElementStyle(element).getHeight();
    }
}

