/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.graphviz;

import com.structurizr.graphviz.RankDirection;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.CustomElement;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.GroupableElement;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.Location;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Person;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.model.StaticStructureElement;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.CustomView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementView;
import com.structurizr.view.ModelView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.SystemContextView;
import com.structurizr.view.SystemLandscapeView;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

class DotFileWriter {
    private static final int CLUSTER_INTERNAL_MARGIN = 25;
    private static final String INDENT = "  ";
    private static final String GROUP_SEPARATOR_PROPERTY_NAME = "structurizr.groupSeparator";
    private Locale locale = Locale.US;
    private final File path;
    private RankDirection rankDirection;
    private double rankSeparation;
    private double nodeSeparation;
    private int groupId = 1;

    DotFileWriter(File path, RankDirection rankDirection, double rankSeparation, double nodeSeparation) {
        this.path = path;
        this.rankDirection = rankDirection;
        this.rankSeparation = rankSeparation;
        this.nodeSeparation = nodeSeparation;
    }

    void setLocale(Locale locale) {
        this.locale = locale;
    }

    private void writeHeader(Writer writer, ModelView view) throws Exception {
        if (view.getAutomaticLayout() != null) {
            switch (view.getAutomaticLayout().getRankDirection()) {
                case TopBottom: {
                    this.rankDirection = RankDirection.TopBottom;
                    break;
                }
                case BottomTop: {
                    this.rankDirection = RankDirection.BottomTop;
                    break;
                }
                case LeftRight: {
                    this.rankDirection = RankDirection.LeftRight;
                    break;
                }
                case RightLeft: {
                    this.rankDirection = RankDirection.RightLeft;
                }
            }
            this.rankSeparation = view.getAutomaticLayout().getRankSeparation();
            this.nodeSeparation = view.getAutomaticLayout().getNodeSeparation();
        }
        this.rankSeparation /= 300.0;
        this.nodeSeparation /= 300.0;
        writer.write("digraph {");
        writer.write("\n");
        writer.write("  compound=true");
        writer.write("\n");
        writer.write(String.format(this.locale, "  graph [splines=polyline,rankdir=%s,ranksep=%s,nodesep=%s,fontsize=5]", this.rankDirection.getCode(), this.rankSeparation, this.nodeSeparation));
        writer.write("\n");
        writer.write("  node [shape=box,fontsize=5]");
        writer.write("\n");
        writer.write("  edge []");
        writer.write("\n");
        writer.write("\n");
    }

    private void writeFooter(Writer writer) throws Exception {
        writer.write("}");
    }

    void write(CustomView view) throws Exception {
        File file = new File(this.path, view.getKey() + ".dot");
        FileWriter fileWriter = new FileWriter(file);
        this.writeHeader(fileWriter, (ModelView)view);
        LinkedHashSet<GroupableElement> elements = new LinkedHashSet<GroupableElement>();
        for (ElementView elementView : view.getElements()) {
            elements.add((GroupableElement)elementView.getElement());
        }
        this.writeElements((ModelView)view, INDENT, elements, fileWriter);
        this.writeRelationships((ModelView)view, fileWriter);
        this.writeFooter(fileWriter);
        fileWriter.close();
    }

    void write(SystemLandscapeView view) throws Exception {
        this.write((ModelView)view, view.isEnterpriseBoundaryVisible());
    }

    void write(SystemContextView view) throws Exception {
        this.write((ModelView)view, view.isEnterpriseBoundaryVisible());
    }

    private void write(ModelView view, boolean enterpriseBoundaryIsVisible) throws Exception {
        File file = new File(this.path, view.getKey() + ".dot");
        FileWriter fileWriter = new FileWriter(file);
        this.writeHeader(fileWriter, view);
        if (enterpriseBoundaryIsVisible) {
            fileWriter.write("  subgraph cluster_enterprise {\n");
            fileWriter.write("    margin=25\n");
            LinkedHashSet<GroupableElement> elementsInsideEnterpriseBoundary = new LinkedHashSet<GroupableElement>();
            for (Object elementView : view.getElements()) {
                if (elementView.getElement() instanceof Person && ((Person)elementView.getElement()).getLocation() == Location.Internal) {
                    elementsInsideEnterpriseBoundary.add((GroupableElement)((StaticStructureElement)elementView.getElement()));
                }
                if (!(elementView.getElement() instanceof SoftwareSystem) || ((SoftwareSystem)elementView.getElement()).getLocation() != Location.Internal) continue;
                elementsInsideEnterpriseBoundary.add((GroupableElement)((StaticStructureElement)elementView.getElement()));
            }
            this.writeElements(view, "    ", elementsInsideEnterpriseBoundary, fileWriter);
            fileWriter.write("  }\n\n");
            LinkedHashSet<GroupableElement> elementsOutsideEnterpriseBoundary = new LinkedHashSet<GroupableElement>();
            for (ElementView elementView : view.getElements()) {
                if (elementView.getElement() instanceof Person && ((Person)elementView.getElement()).getLocation() != Location.Internal) {
                    elementsOutsideEnterpriseBoundary.add((GroupableElement)((StaticStructureElement)elementView.getElement()));
                }
                if (elementView.getElement() instanceof SoftwareSystem && ((SoftwareSystem)elementView.getElement()).getLocation() != Location.Internal) {
                    elementsOutsideEnterpriseBoundary.add((GroupableElement)((StaticStructureElement)elementView.getElement()));
                }
                if (!(elementView.getElement() instanceof CustomElement)) continue;
                elementsOutsideEnterpriseBoundary.add((GroupableElement)((CustomElement)elementView.getElement()));
            }
            this.writeElements(view, INDENT, elementsOutsideEnterpriseBoundary, fileWriter);
        } else {
            LinkedHashSet<GroupableElement> elements = new LinkedHashSet<GroupableElement>();
            for (ElementView elementView : view.getElements()) {
                elements.add((GroupableElement)elementView.getElement());
            }
            this.writeElements(view, INDENT, elements, fileWriter);
        }
        this.writeRelationships(view, fileWriter);
        this.writeFooter(fileWriter);
        fileWriter.close();
    }

    void write(ContainerView view) throws Exception {
        File file = new File(this.path, view.getKey() + ".dot");
        FileWriter fileWriter = new FileWriter(file);
        this.writeHeader(fileWriter, (ModelView)view);
        HashSet<SoftwareSystem> softwareSystems = new HashSet<SoftwareSystem>();
        for (ElementView elementView : view.getElements()) {
            if (!(elementView.getElement().getParent() instanceof SoftwareSystem)) continue;
            softwareSystems.add((SoftwareSystem)elementView.getElement().getParent());
        }
        ArrayList<SoftwareSystem> sortedSoftwareSystems = new ArrayList<SoftwareSystem>(softwareSystems);
        sortedSoftwareSystems.sort(Comparator.comparing(ModelItem::getId));
        for (SoftwareSystem softwareSystem : sortedSoftwareSystems) {
            fileWriter.write(String.format(this.locale, "  subgraph cluster_%s {\n", softwareSystem.getId()));
            fileWriter.write("    margin=25\n");
            LinkedHashSet<GroupableElement> scopedElements = new LinkedHashSet<GroupableElement>();
            for (ElementView elementView : view.getElements()) {
                if (elementView.getElement().getParent() != softwareSystem) continue;
                scopedElements.add((GroupableElement)((StaticStructureElement)elementView.getElement()));
            }
            this.writeElements((ModelView)view, "    ", scopedElements, fileWriter);
            fileWriter.write("  }\n");
        }
        for (ElementView elementView : view.getElements()) {
            if (elementView.getElement().getParent() != null) continue;
            this.writeElement((ModelView)view, INDENT, elementView.getElement(), fileWriter);
        }
        this.writeRelationships((ModelView)view, fileWriter);
        this.writeFooter(fileWriter);
        fileWriter.close();
    }

    void write(ComponentView view) throws Exception {
        File file = new File(this.path, view.getKey() + ".dot");
        FileWriter fileWriter = new FileWriter(file);
        this.writeHeader(fileWriter, (ModelView)view);
        HashSet<Container> containers = new HashSet<Container>();
        for (ElementView elementView : view.getElements()) {
            if (!(elementView.getElement().getParent() instanceof Container)) continue;
            containers.add((Container)elementView.getElement().getParent());
        }
        ArrayList<Container> sortedContainers = new ArrayList<Container>(containers);
        sortedContainers.sort(Comparator.comparing(ModelItem::getId));
        for (Container container : sortedContainers) {
            fileWriter.write(String.format(this.locale, "  subgraph cluster_%s {\n", container.getId()));
            fileWriter.write("    margin=25\n");
            LinkedHashSet<GroupableElement> scopedElements = new LinkedHashSet<GroupableElement>();
            for (ElementView elementView : view.getElements()) {
                if (elementView.getElement().getParent() != container) continue;
                scopedElements.add((GroupableElement)((StaticStructureElement)elementView.getElement()));
            }
            this.writeElements((ModelView)view, "    ", scopedElements, fileWriter);
            fileWriter.write("  }\n");
        }
        for (ElementView elementView : view.getElements()) {
            if (elementView.getElement().getParent() instanceof Container) continue;
            this.writeElement((ModelView)view, INDENT, elementView.getElement(), fileWriter);
        }
        this.writeRelationships((ModelView)view, fileWriter);
        this.writeFooter(fileWriter);
        fileWriter.close();
    }

    void write(DynamicView view) throws Exception {
        File file = new File(this.path, view.getKey() + ".dot");
        FileWriter fileWriter = new FileWriter(file);
        this.writeHeader(fileWriter, (ModelView)view);
        Element element = view.getElement();
        if (element == null) {
            for (ElementView elementView : view.getElements()) {
                this.writeElement((ModelView)view, INDENT, elementView.getElement(), fileWriter);
            }
        } else if (element instanceof SoftwareSystem) {
            ArrayList<SoftwareSystem> softwareSystems = new ArrayList<SoftwareSystem>(view.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof Container).map(c -> ((Container)c).getSoftwareSystem()).collect(Collectors.toSet()));
            softwareSystems.sort(Comparator.comparing(ModelItem::getId));
            for (SoftwareSystem softwareSystem : softwareSystems) {
                fileWriter.write(String.format(this.locale, "  subgraph cluster_%s {\n", softwareSystem.getId()));
                fileWriter.write("    margin=25\n");
                for (ElementView elementView : view.getElements()) {
                    if (elementView.getElement().getParent() != softwareSystem) continue;
                    this.writeElement((ModelView)view, "    ", elementView.getElement(), fileWriter);
                }
                fileWriter.write("  }\n");
            }
            for (ElementView elementView : view.getElements()) {
                if (elementView.getElement().getParent() != null) continue;
                this.writeElement((ModelView)view, INDENT, elementView.getElement(), fileWriter);
            }
        } else if (element instanceof Container) {
            ArrayList<Container> containers = new ArrayList<Container>(view.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof Component).map(c -> ((Component)c).getContainer()).collect(Collectors.toSet()));
            containers.sort(Comparator.comparing(ModelItem::getId));
            for (Container container : containers) {
                fileWriter.write(String.format(this.locale, "  subgraph cluster_%s {\n", container.getId()));
                fileWriter.write("    margin=25\n");
                for (ElementView elementView : view.getElements()) {
                    if (elementView.getElement().getParent() != container) continue;
                    this.writeElement((ModelView)view, "    ", elementView.getElement(), fileWriter);
                }
                fileWriter.write("  }\n");
            }
            for (ElementView elementView : view.getElements()) {
                if (elementView.getElement().getParent() instanceof Container) continue;
                this.writeElement((ModelView)view, INDENT, elementView.getElement(), fileWriter);
            }
        }
        this.writeRelationships((ModelView)view, fileWriter);
        this.writeFooter(fileWriter);
        fileWriter.close();
    }

    void write(DeploymentView view) throws Exception {
        File file = new File(this.path, view.getKey() + ".dot");
        FileWriter fileWriter = new FileWriter(file);
        this.writeHeader(fileWriter, (ModelView)view);
        for (ElementView elementView : view.getElements()) {
            if (elementView.getElement() instanceof DeploymentNode && elementView.getElement().getParent() == null) {
                this.write(view, (DeploymentNode)elementView.getElement(), fileWriter, "");
                continue;
            }
            if (!(elementView.getElement() instanceof CustomElement)) continue;
            this.writeElement((ModelView)view, INDENT, elementView.getElement(), fileWriter);
        }
        this.writeRelationships((ModelView)view, fileWriter);
        this.writeFooter(fileWriter);
        fileWriter.close();
    }

    private void write(DeploymentView view, DeploymentNode deploymentNode, FileWriter fileWriter, String indent) throws Exception {
        fileWriter.write(String.format(this.locale, indent + "subgraph cluster_%s {\n", deploymentNode.getId()));
        fileWriter.write(indent + "  margin=" + 25 + "\n");
        fileWriter.write(String.format(this.locale, indent + "  label=\"%s: %s\"\n", deploymentNode.getId(), deploymentNode.getName()));
        for (DeploymentNode child : deploymentNode.getChildren()) {
            if (!view.isElementInView((Element)child)) continue;
            this.write(view, child, fileWriter, indent + INDENT);
        }
        for (InfrastructureNode infrastructureNode : deploymentNode.getInfrastructureNodes()) {
            if (!view.isElementInView((Element)infrastructureNode)) continue;
            this.writeElement((ModelView)view, indent + INDENT, (Element)infrastructureNode, fileWriter);
        }
        for (SoftwareSystemInstance softwareSystemInstance : deploymentNode.getSoftwareSystemInstances()) {
            if (!view.isElementInView((Element)softwareSystemInstance)) continue;
            this.writeElement((ModelView)view, indent + INDENT, (Element)softwareSystemInstance, fileWriter);
        }
        for (ContainerInstance containerInstance : deploymentNode.getContainerInstances()) {
            if (!view.isElementInView((Element)containerInstance)) continue;
            this.writeElement((ModelView)view, indent + INDENT, (Element)containerInstance, fileWriter);
        }
        fileWriter.write(indent + "}\n");
    }

    private void writeElements(ModelView view, String padding, Set<GroupableElement> elements, Writer writer) throws Exception {
        String groupSeparator = (String)view.getModel().getProperties().get(GROUP_SEPARATOR_PROPERTY_NAME);
        boolean nested = !StringUtils.isNullOrEmpty((String)groupSeparator);
        HashSet<Object> groups = new HashSet<Object>();
        for (GroupableElement element : elements) {
            Object group = element.getGroup();
            if (StringUtils.isNullOrEmpty((String)group)) continue;
            groups.add(group);
            if (!nested) continue;
            while (((String)group).contains(groupSeparator)) {
                group = ((String)group).substring(0, ((String)group).lastIndexOf(groupSeparator));
                groups.add(group);
            }
        }
        ArrayList sortedGroups = new ArrayList(groups);
        sortedGroups.sort(String::compareTo);
        if (nested) {
            if (groups.size() > 0) {
                String context = "";
                for (String group : sortedGroups) {
                    int contextCount;
                    int groupCount = group.split(groupSeparator).length;
                    if (groupCount > (contextCount = context.split(groupSeparator).length)) {
                        padding = padding + INDENT;
                    } else if (groupCount == contextCount) {
                        if (context.length() > 0) {
                            writer.write(padding + "}\n");
                        }
                    } else {
                        for (int i = 0; i < contextCount - groupCount; ++i) {
                            writer.write(padding + "}\n");
                            padding = padding.substring(0, padding.length() - INDENT.length());
                        }
                        writer.write(padding + "}\n");
                    }
                    writer.write(padding + "subgraph cluster_group_" + this.groupId + " {\n");
                    writer.write(padding + "  margin=" + 25 + "\n");
                    for (GroupableElement element : elements) {
                        if (!group.equals(element.getGroup())) continue;
                        this.writeElement(view, padding + INDENT, (Element)element, writer);
                    }
                    ++this.groupId;
                    context = group;
                }
                int contextCount = context.split(groupSeparator).length;
                for (int i = 0; i < contextCount; ++i) {
                    writer.write(padding + "}\n");
                    padding = padding.substring(0, padding.length() - INDENT.length());
                }
            }
        } else {
            for (Object group : sortedGroups) {
                writer.write(padding + "subgraph cluster_group_" + this.groupId + " {\n");
                writer.write(padding + "  margin=" + 25 + "\n");
                for (GroupableElement element : elements) {
                    if (!((String)group).equals(element.getGroup())) continue;
                    this.writeElement(view, padding + INDENT, (Element)element, writer);
                }
                writer.write(padding + "}\n");
                ++this.groupId;
            }
        }
        for (GroupableElement element : elements) {
            if (!StringUtils.isNullOrEmpty((String)element.getGroup())) continue;
            this.writeElement(view, padding, (Element)element, writer);
        }
    }

    private void writeElement(ModelView view, String padding, Element element, Writer writer) throws Exception {
        writer.write(String.format(this.locale, "%s%s [width=%f,height=%f,fixedsize=true,id=%s,label=\"%s: %s\"]", padding, element.getId(), (double)this.getElementWidth(view, element.getId()) / 300.0, (double)this.getElementHeight(view, element.getId()) / 300.0, element.getId(), element.getId(), this.escape(element.getName())));
        writer.write("\n");
    }

    private String escape(String s) {
        if (StringUtils.isNullOrEmpty((String)s)) {
            return s;
        }
        return s.replaceAll("\"", "\\\\\"");
    }

    private void writeRelationships(ModelView view, Writer writer) throws Exception {
        writer.write("\n");
        for (RelationshipView relationshipView : view.getRelationships()) {
            Element destination;
            Element source;
            if (relationshipView.getRelationship().getSource() instanceof DeploymentNode || relationshipView.getRelationship().getDestination() instanceof DeploymentNode) {
                source = relationshipView.getRelationship().getSource();
                if (source instanceof DeploymentNode) {
                    source = this.findElementInside((DeploymentNode)source, view);
                }
                if ((destination = relationshipView.getRelationship().getDestination()) instanceof DeploymentNode) {
                    destination = this.findElementInside((DeploymentNode)destination, view);
                }
                if (source == null || destination == null) continue;
                String clusterConfig = "";
                if (relationshipView.getRelationship().getSource() instanceof DeploymentNode) {
                    clusterConfig = clusterConfig + ",ltail=cluster_" + relationshipView.getRelationship().getSource().getId();
                }
                if (relationshipView.getRelationship().getDestination() instanceof DeploymentNode) {
                    clusterConfig = clusterConfig + ",lhead=cluster_" + relationshipView.getRelationship().getDestination().getId();
                }
                writer.write(String.format(this.locale, "  %s -> %s [id=%s%s]", source.getId(), destination.getId(), relationshipView.getId(), clusterConfig));
                writer.write("\n");
                continue;
            }
            source = relationshipView.getRelationship().getSource();
            destination = relationshipView.getRelationship().getDestination();
            if (relationshipView.isResponse() != null && relationshipView.isResponse().booleanValue()) {
                source = relationshipView.getRelationship().getDestination();
                destination = relationshipView.getRelationship().getSource();
            }
            writer.write(String.format(this.locale, "  %s -> %s [id=%s]", source.getId(), destination.getId(), relationshipView.getId()));
            writer.write("\n");
        }
    }

    private Element findElementInside(DeploymentNode deploymentNode, ModelView view) {
        for (SoftwareSystemInstance softwareSystemInstance : deploymentNode.getSoftwareSystemInstances()) {
            if (!view.isElementInView((Element)softwareSystemInstance)) continue;
            return softwareSystemInstance;
        }
        for (ContainerInstance containerInstance : deploymentNode.getContainerInstances()) {
            if (!view.isElementInView((Element)containerInstance)) continue;
            return containerInstance;
        }
        for (InfrastructureNode infrastructureNode : deploymentNode.getInfrastructureNodes()) {
            if (!view.isElementInView((Element)infrastructureNode)) continue;
            return infrastructureNode;
        }
        if (deploymentNode.hasChildren()) {
            for (DeploymentNode child : deploymentNode.getChildren()) {
                Element element = this.findElementInside(child, view);
                if (element == null) continue;
                return element;
            }
        }
        return null;
    }

    private int getElementWidth(ModelView view, String elementId) {
        Element element = view.getModel().getElement(elementId);
        return view.getViewSet().getConfiguration().getStyles().findElementStyle(element).getWidth();
    }

    private int getElementHeight(ModelView view, String elementId) {
        Element element = view.getModel().getElement(elementId);
        return view.getViewSet().getConfiguration().getStyles().findElementStyle(element).getHeight();
    }
}

