/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.graphviz;

import com.structurizr.Workspace;
import com.structurizr.graphviz.DotFileWriter;
import com.structurizr.graphviz.RankDirection;
import com.structurizr.graphviz.SVGReader;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.CustomView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ModelView;
import com.structurizr.view.SystemContextView;
import com.structurizr.view.SystemLandscapeView;
import com.structurizr.view.View;
import java.io.File;
import java.util.Locale;

public class GraphvizAutomaticLayout {
    private File path;
    private RankDirection rankDirection = RankDirection.TopBottom;
    private double rankSeparation = 1.0;
    private double nodeSeparation = 1.0;
    private int margin = 400;
    private boolean changePaperSize = true;
    private Locale locale = Locale.US;

    public GraphvizAutomaticLayout() {
        this(new File("."));
    }

    public GraphvizAutomaticLayout(File path) {
        this.path = path;
    }

    public void setRankDirection(RankDirection rankDirection) {
        this.rankDirection = rankDirection;
    }

    public void setRankSeparation(double rankSeparation) {
        this.rankSeparation = rankSeparation;
    }

    public void setNodeSeparation(double nodeSeparation) {
        this.nodeSeparation = nodeSeparation;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public void setChangePaperSize(boolean changePaperSize) {
        this.changePaperSize = changePaperSize;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private DotFileWriter createDotFileWriter() {
        DotFileWriter dotFileWriter = new DotFileWriter(this.path, this.rankDirection, this.rankSeparation, this.nodeSeparation);
        dotFileWriter.setLocale(this.locale);
        return dotFileWriter;
    }

    private SVGReader createSVGReader() {
        return new SVGReader(this.path, this.margin, this.changePaperSize);
    }

    private void runGraphviz(View view) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).inheritIO();
        processBuilder.command("dot", new File(this.path, view.getKey() + ".dot").getAbsolutePath(), "-Tsvg", "-O");
        Process process = processBuilder.start();
        int exitCode = process.waitFor();
        assert (exitCode == 0);
    }

    public void apply(CustomView view) throws Exception {
        this.createDotFileWriter().write(view);
        this.runGraphviz((View)view);
        this.createSVGReader().parseAndApplyLayout((ModelView)view);
    }

    public void apply(SystemLandscapeView view) throws Exception {
        this.createDotFileWriter().write(view);
        this.runGraphviz((View)view);
        this.createSVGReader().parseAndApplyLayout((ModelView)view);
    }

    public void apply(SystemContextView view) throws Exception {
        this.createDotFileWriter().write(view);
        this.runGraphviz((View)view);
        this.createSVGReader().parseAndApplyLayout((ModelView)view);
    }

    public void apply(ContainerView view) throws Exception {
        this.createDotFileWriter().write(view);
        this.runGraphviz((View)view);
        this.createSVGReader().parseAndApplyLayout((ModelView)view);
    }

    public void apply(ComponentView view) throws Exception {
        this.createDotFileWriter().write(view);
        this.runGraphviz((View)view);
        this.createSVGReader().parseAndApplyLayout((ModelView)view);
    }

    public void apply(DynamicView view) throws Exception {
        this.createDotFileWriter().write(view);
        this.runGraphviz((View)view);
        this.createSVGReader().parseAndApplyLayout((ModelView)view);
    }

    public void apply(DeploymentView view) throws Exception {
        this.createDotFileWriter().write(view);
        this.runGraphviz((View)view);
        this.createSVGReader().parseAndApplyLayout((ModelView)view);
    }

    public void apply(Workspace workspace) throws Exception {
        for (CustomView view : workspace.getViews().getCustomViews()) {
            this.apply(view);
        }
        for (CustomView view : workspace.getViews().getSystemLandscapeViews()) {
            this.apply((SystemLandscapeView)view);
        }
        for (CustomView view : workspace.getViews().getSystemContextViews()) {
            this.apply((SystemContextView)view);
        }
        for (CustomView view : workspace.getViews().getContainerViews()) {
            this.apply((ContainerView)view);
        }
        for (CustomView view : workspace.getViews().getComponentViews()) {
            this.apply((ComponentView)view);
        }
        for (CustomView view : workspace.getViews().getDynamicViews()) {
            this.apply((DynamicView)view);
        }
        for (CustomView view : workspace.getViews().getDeploymentViews()) {
            this.apply((DeploymentView)view);
        }
    }
}

