/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.graphviz;

import com.structurizr.Workspace;
import com.structurizr.export.Diagram;
import com.structurizr.graphviz.DOTExporter;
import com.structurizr.graphviz.RankDirection;
import com.structurizr.graphviz.SVGReader;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.CustomView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ModelView;
import com.structurizr.view.SystemContextView;
import com.structurizr.view.SystemLandscapeView;
import com.structurizr.view.View;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GraphvizAutomaticLayout {
    private static final Log log = LogFactory.getLog(GraphvizAutomaticLayout.class);
    private static final String DOT_EXECUTABLE = "dot";
    private static final String USE_SVG_OUTPUT_FORMAT_OPTION = "-Tsvg";
    private static final String AUTOMATICALLY_GENERATE_OUTPUT_FILE_OPTION = "-O";
    private static final String DOT_FILE_EXTENSION = ".dot";
    private final File path;
    private RankDirection rankDirection = RankDirection.TopBottom;
    private double rankSeparation = 1.0;
    private double nodeSeparation = 1.0;
    private int margin = 400;
    private boolean changePaperSize = true;
    private Locale locale = Locale.US;

    public GraphvizAutomaticLayout() {
        this(new File("."));
    }

    public GraphvizAutomaticLayout(File path) {
        this.path = path;
    }

    public void setRankDirection(RankDirection rankDirection) {
        this.rankDirection = rankDirection;
    }

    public void setRankSeparation(double rankSeparation) {
        this.rankSeparation = rankSeparation;
    }

    public void setNodeSeparation(double nodeSeparation) {
        this.nodeSeparation = nodeSeparation;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public void setChangePaperSize(boolean changePaperSize) {
        this.changePaperSize = changePaperSize;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private DOTExporter createDOTExporter() {
        DOTExporter exporter = new DOTExporter(this.rankDirection, this.rankSeparation, this.nodeSeparation);
        exporter.setLocale(this.locale);
        return exporter;
    }

    private void writeFile(Diagram diagram) throws Exception {
        File file = new File(this.path, diagram.getKey() + DOT_FILE_EXTENSION);
        log.debug((Object)("Writing " + file.getAbsolutePath()));
        BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
        writer.write(diagram.getDefinition());
        writer.flush();
        writer.close();
        if (!file.exists()) {
            log.error((Object)(file.getAbsolutePath() + " does not exist"));
        }
    }

    private SVGReader createSVGReader() {
        return new SVGReader(this.path, this.margin, this.changePaperSize);
    }

    private void runGraphviz(View view) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).inheritIO();
        List<String> command = List.of(DOT_EXECUTABLE, new File(this.path, view.getKey() + DOT_FILE_EXTENSION).getAbsolutePath(), USE_SVG_OUTPUT_FORMAT_OPTION, AUTOMATICALLY_GENERATE_OUTPUT_FILE_OPTION);
        processBuilder.command(command);
        StringBuilder buf = new StringBuilder();
        for (String s : command) {
            buf.append(s);
            buf.append(" ");
        }
        log.debug((Object)buf);
        Process process = processBuilder.start();
        int exitCode = process.waitFor();
        assert (exitCode == 0);
        String input = new String(process.getInputStream().readAllBytes());
        String error = new String(process.getErrorStream().readAllBytes());
        log.debug((Object)("stdout: " + input));
        log.debug((Object)("stderr: " + error));
    }

    public void apply(CustomView view) throws Exception {
        log.debug((Object)("Running Graphviz for view with key " + view.getKey()));
        Diagram diagram = this.createDOTExporter().export(view);
        this.writeFile(diagram);
        this.runGraphviz((View)view);
        this.createSVGReader().parseAndApplyLayout((ModelView)view);
    }

    public void apply(SystemLandscapeView view) throws Exception {
        log.debug((Object)("Running Graphviz for view with key " + view.getKey()));
        Diagram diagram = this.createDOTExporter().export(view);
        this.writeFile(diagram);
        this.runGraphviz((View)view);
        this.createSVGReader().parseAndApplyLayout((ModelView)view);
    }

    public void apply(SystemContextView view) throws Exception {
        log.debug((Object)("Running Graphviz for view with key " + view.getKey()));
        Diagram diagram = this.createDOTExporter().export(view);
        this.writeFile(diagram);
        this.runGraphviz((View)view);
        this.createSVGReader().parseAndApplyLayout((ModelView)view);
    }

    public void apply(ContainerView view) throws Exception {
        log.debug((Object)("Running Graphviz for view with key " + view.getKey()));
        Diagram diagram = this.createDOTExporter().export(view);
        this.writeFile(diagram);
        this.runGraphviz((View)view);
        this.createSVGReader().parseAndApplyLayout((ModelView)view);
    }

    public void apply(ComponentView view) throws Exception {
        log.debug((Object)("Running Graphviz for view with key " + view.getKey()));
        Diagram diagram = this.createDOTExporter().export(view);
        this.writeFile(diagram);
        this.runGraphviz((View)view);
        this.createSVGReader().parseAndApplyLayout((ModelView)view);
    }

    public void apply(DynamicView view) throws Exception {
        log.debug((Object)("Running Graphviz for view with key " + view.getKey()));
        Diagram diagram = this.createDOTExporter().export(view);
        this.writeFile(diagram);
        this.runGraphviz((View)view);
        this.createSVGReader().parseAndApplyLayout((ModelView)view);
    }

    public void apply(DeploymentView view) throws Exception {
        log.debug((Object)("Running Graphviz for view with key " + view.getKey()));
        Diagram diagram = this.createDOTExporter().export(view);
        this.writeFile(diagram);
        this.runGraphviz((View)view);
        this.createSVGReader().parseAndApplyLayout((ModelView)view);
    }

    public void apply(Workspace workspace) throws Exception {
        for (CustomView view : workspace.getViews().getCustomViews()) {
            this.apply(view);
        }
        for (CustomView view : workspace.getViews().getSystemLandscapeViews()) {
            this.apply((SystemLandscapeView)view);
        }
        for (CustomView view : workspace.getViews().getSystemContextViews()) {
            this.apply((SystemContextView)view);
        }
        for (CustomView view : workspace.getViews().getContainerViews()) {
            this.apply((ContainerView)view);
        }
        for (CustomView view : workspace.getViews().getComponentViews()) {
            this.apply((ComponentView)view);
        }
        for (CustomView view : workspace.getViews().getDynamicViews()) {
            this.apply((DynamicView)view);
        }
        for (CustomView view : workspace.getViews().getDeploymentViews()) {
            this.apply((DeploymentView)view);
        }
    }
}

